/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.nuiton.wikitty:wp-maven-plugin:3.2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Wikitty :: publication Maven plugin", 0);
        this.append(sb, "Maven plugin to execute wikitty publication maintenance tasks", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 8 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "clean".equals(this.goal)) {
            this.append(sb, "wp:clean", 0);
            this.append(sb, "Goal to remove properties files used by WikittyService over file system to ensure transformation wikitty-file. Delete '.wp' dirs.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "applicationName", 2);
                this.append(sb, "The mandatory application name.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wp.applicationName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "A flag to activate verbose mode.", 3);
                this.append(sb, "Expression: ${wp.verbose}", 3);
                this.append(sb, "", 0);
                this.append(sb, "wikittyServiceUrl", 2);
                this.append(sb, "The mandatory wikitty service url.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wp.wikittyServiceUrl}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "deploy".equals(this.goal)) {
            this.append(sb, "wp:deploy", 0);
            this.append(sb, "To deploy a wikitty publication.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "applicationName", 2);
                this.append(sb, "The mandatory application name.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wp.applicationName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "A flag to activate verbose mode.", 3);
                this.append(sb, "Expression: ${wp.verbose}", 3);
                this.append(sb, "", 0);
                this.append(sb, "wikittyServiceUrl", 2);
                this.append(sb, "The mandatory wikitty service url.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wp.wikittyServiceUrl}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "deploy-jar".equals(this.goal)) {
            this.append(sb, "wp:deploy-jar", 0);
            this.append(sb, "To deploy a wikitty publication jar.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "applicationName", 2);
                this.append(sb, "The mandatory application name.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wp.applicationName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmod (Default: true)", 2);
                this.append(sb, "Whether to run the 'chmod' command on the remote site after the deploy. Defaults to 'true'.", 3);
                this.append(sb, "Expression: ${maven.site.chmod}", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmodMode (Default: g+w,a+rX)", 2);
                this.append(sb, "The mode used by the 'chmod' command. Only used if chmod = true. Defaults to 'g+w,a+rX'.", 3);
                this.append(sb, "Expression: ${maven.site.chmod.mode}", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmodOptions (Default: -Rf)", 2);
                this.append(sb, "The options used by the 'chmod' command. Only used if chmod = true. Defaults to '-Rf'.", 3);
                this.append(sb, "Expression: ${maven.site.chmod.options}", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileToDeploy", 2);
                this.append(sb, "file to deploy", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${fileToDeploy}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "Id of server.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${serverId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverUrl", 2);
                this.append(sb, "URL of server to use to log into server.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${serverUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "A flag to activate verbose mode.", 3);
                this.append(sb, "Expression: ${wp.verbose}", 3);
                this.append(sb, "", 0);
                this.append(sb, "wikittyServiceUrl", 2);
                this.append(sb, "The mandatory wikitty service url.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wp.wikittyServiceUrl}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "wp:help", 0);
            this.append(sb, "Display help information on wp-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0wp:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "init".equals(this.goal)) {
            this.append(sb, "wp:init", 0);
            this.append(sb, "To init a wikitty publication project. To init directory architecture for wikitty publication project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "applicationName", 2);
                this.append(sb, "The mandatory application name.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wp.applicationName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "A flag to activate verbose mode.", 3);
                this.append(sb, "Expression: ${wp.verbose}", 3);
                this.append(sb, "", 0);
                this.append(sb, "wikittyServiceUrl", 2);
                this.append(sb, "The mandatory wikitty service url.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wp.wikittyServiceUrl}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jar".equals(this.goal)) {
            this.append(sb, "wp:jar", 0);
            this.append(sb, "To create a wikitty publication jar.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "applicationName", 2);
                this.append(sb, "The mandatory application name.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wp.applicationName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "A flag to activate verbose mode.", 3);
                this.append(sb, "Expression: ${wp.verbose}", 3);
                this.append(sb, "", 0);
                this.append(sb, "wikittyServiceUrl", 2);
                this.append(sb, "The mandatory wikitty service url.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wp.wikittyServiceUrl}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run".equals(this.goal)) {
            this.append(sb, "wp:run", 0);
            this.append(sb, "To run a wikitty publication project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "applicationName", 2);
                this.append(sb, "The mandatory application name.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wp.applicationName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "publicationVersion", 2);
                this.append(sb, "URL of server to use to log into server.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${publicationVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "A flag to activate verbose mode.", 3);
                this.append(sb, "Expression: ${wp.verbose}", 3);
                this.append(sb, "", 0);
                this.append(sb, "wikittyServiceUrl", 2);
                this.append(sb, "The mandatory wikitty service url.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wp.wikittyServiceUrl}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "update".equals(this.goal)) {
            this.append(sb, "wp:update", 0);
            this.append(sb, "To update a wikitty publication project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "applicationName", 2);
                this.append(sb, "The mandatory application name.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wp.applicationName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "A flag to activate verbose mode.", 3);
                this.append(sb, "Expression: ${wp.verbose}", 3);
                this.append(sb, "", 0);
                this.append(sb, "wikittyServiceUrl", 2);
                this.append(sb, "The mandatory wikitty service url.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wp.wikittyServiceUrl}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

