/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage.solr;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryResult;
import org.nuiton.wikitty.query.WikittyQueryVisitor;
import org.nuiton.wikitty.query.conditions.And;
import org.nuiton.wikitty.query.conditions.Between;
import org.nuiton.wikitty.query.conditions.Condition;
import org.nuiton.wikitty.query.conditions.ConditionValue;
import org.nuiton.wikitty.query.conditions.ConditionValueString;
import org.nuiton.wikitty.query.conditions.ContainsAll;
import org.nuiton.wikitty.query.conditions.ContainsOne;
import org.nuiton.wikitty.query.conditions.Equals;
import org.nuiton.wikitty.query.conditions.False;
import org.nuiton.wikitty.query.conditions.Greater;
import org.nuiton.wikitty.query.conditions.GreaterOrEquals;
import org.nuiton.wikitty.query.conditions.Keyword;
import org.nuiton.wikitty.query.conditions.Less;
import org.nuiton.wikitty.query.conditions.LessOrEquals;
import org.nuiton.wikitty.query.conditions.Like;
import org.nuiton.wikitty.query.conditions.Not;
import org.nuiton.wikitty.query.conditions.NotEquals;
import org.nuiton.wikitty.query.conditions.NotNull;
import org.nuiton.wikitty.query.conditions.Null;
import org.nuiton.wikitty.query.conditions.Or;
import org.nuiton.wikitty.query.conditions.Select;
import org.nuiton.wikitty.query.conditions.True;
import org.nuiton.wikitty.query.conditions.Unlike;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.solr.ElementModifier;
import org.nuiton.wikitty.storage.solr.WikittySearchEngineSolr;

public class WikittyQueryVisitorToSolr
extends WikittyQueryVisitor {
    private static Log log = LogFactory.getLog(WikittyQueryVisitorToSolr.class);
    protected WikittyTransaction tx;
    protected WikittySearchEngineSolr searchEngine;
    protected ElementModifier elementModifier;
    protected String solrQuery = "";

    public String getSolrQuery() {
        return this.solrQuery;
    }

    public WikittyQueryVisitorToSolr(WikittyTransaction tx, WikittySearchEngineSolr solrServer, ElementModifier elementModifier) {
        this.tx = tx;
        this.searchEngine = solrServer;
        this.elementModifier = elementModifier;
    }

    private String element2solr(Element element) {
        String result = this.elementModifier.convertToSolr(this.tx, element);
        return result;
    }

    private String escape2solr(String value) {
        if (value == null) {
            throw new WikittyException("Parse error, value must be not empty");
        }
        String LUCENE_REPLACE_PATTERN = "\\+|-|&&|\\||!|\\(|\\)|\\[|\\]|\\{|\\}|\"|:";
        String result = value.replaceAll("\\+|-|&&|\\||!|\\(|\\)|\\[|\\]|\\{|\\}|\"|:", "\\\\$0");
        if (result.contains(" ")) {
            result = "\"" + result + "\"";
        }
        return result;
    }

    protected List<String> evalConditionValueAsList(List<ConditionValue> o) {
        ArrayList<String> result = new ArrayList<String>(o.size());
        for (ConditionValue c : o) {
            result.addAll(this.evalConditionValueAsList(c));
        }
        return result;
    }

    protected List<String> evalConditionValueAsList(ConditionValue o) {
        ArrayList<String> result = new ArrayList<String>();
        if (o instanceof Select) {
            WikittyQuery query = new WikittyQuery((Condition)o);
            WikittyQueryResult<String> selectResult = this.searchEngine.findAllByQuery(this.tx, query);
            for (String s : selectResult) {
                result.add(this.escape2solr(s));
            }
        } else if (o instanceof ConditionValueString) {
            result.add(this.escape2solr(((ConditionValueString)o).getValue()));
        } else {
            throw new WikittyException(String.format("ConditionValue type unsupported %s", ClassUtils.getShortCanonicalName((Object)o, (String)"null")));
        }
        return result;
    }

    protected String evalConditionValue(ConditionValue o) {
        String result;
        if (o instanceof Select) {
            WikittyQuery query = new WikittyQuery((Condition)o);
            WikittyQueryResult<String> selectResult = this.searchEngine.findAllByQuery(this.tx, query);
            if (selectResult.size() == 0) {
                throw new WikittyException(String.format("Select return no result query was '%s' transformed to '%s'", o.toString(), selectResult.getQueryString()));
            }
            if (selectResult.size() > 1 && log.isWarnEnabled()) {
                log.warn((Object)String.format("Select return more than one result, only first is used. Query was '%s' transformed to '%s'", o.toString(), selectResult.getQueryString()));
            }
            result = (String)selectResult.peek();
        } else if (o instanceof ConditionValueString) {
            result = ((ConditionValueString)o).getValue();
        } else {
            throw new WikittyException(String.format("ConditionValue type unsupported %s", ClassUtils.getShortCanonicalName((Object)o, (String)"null")));
        }
        result = this.escape2solr(result);
        return result;
    }

    public void visit(ConditionValueString o) {
    }

    public boolean visitEnter(WikittyQuery o) {
        return true;
    }

    public void visitLeave(WikittyQuery o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(And o) {
        this.solrQuery = this.solrQuery + "(";
        return true;
    }

    public boolean visitMiddle(And o) {
        this.solrQuery = this.solrQuery + " AND ";
        return true;
    }

    public void visitLeave(And o, boolean enterResult) {
        this.solrQuery = this.solrQuery + ")";
    }

    public boolean visitEnter(Or o) {
        this.solrQuery = this.solrQuery + "(";
        return true;
    }

    public boolean visitMiddle(Or o) {
        this.solrQuery = this.solrQuery + " OR ";
        return true;
    }

    public void visitLeave(Or o, boolean enterResult) {
        this.solrQuery = this.solrQuery + ")";
    }

    public boolean visitEnter(Select o) {
        return true;
    }

    public void visitLeave(Select o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(Not o) {
        this.solrQuery = this.solrQuery + "NOT(";
        return true;
    }

    public void visitLeave(Not o, boolean enterResult) {
        this.solrQuery = this.solrQuery + ")";
    }

    public boolean visitEnter(Between o) {
        this.solrQuery = this.solrQuery + this.element2solr(o.getElement()) + ":[" + this.evalConditionValue(o.getMin()) + " TO " + this.evalConditionValue(o.getMax()) + "]";
        return false;
    }

    public boolean visitMiddle(Between o) {
        return true;
    }

    public void visitLeave(Between o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(ContainsAll o) {
        this.solrQuery = this.solrQuery + this.element2solr(o.getElement()) + ":(";
        String sep = "";
        for (String e : this.evalConditionValueAsList(o.getValues())) {
            this.solrQuery = this.solrQuery + sep + e;
            sep = " AND ";
        }
        this.solrQuery = this.solrQuery + ")";
        return false;
    }

    public boolean visitMiddle(ContainsAll o) {
        return false;
    }

    public void visitLeave(ContainsAll o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(ContainsOne o) {
        this.solrQuery = this.solrQuery + this.element2solr(o.getElement()) + ":(";
        String sep = "";
        for (String e : this.evalConditionValueAsList(o.getValues())) {
            this.solrQuery = this.solrQuery + sep + e;
            sep = " OR ";
        }
        this.solrQuery = this.solrQuery + ")";
        return false;
    }

    public boolean visitMiddle(ContainsOne o) {
        return false;
    }

    public void visitLeave(ContainsOne o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(Equals o) {
        this.solrQuery = this.solrQuery + this.element2solr(o.getElement()) + ":" + this.evalConditionValue(o.getValue());
        return false;
    }

    public void visitLeave(Equals o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(NotEquals o) {
        this.solrQuery = this.solrQuery + "-" + this.element2solr(o.getElement()) + ":" + this.evalConditionValue(o.getValue());
        return false;
    }

    public void visitLeave(NotEquals o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(Greater o) {
        this.solrQuery = this.solrQuery + this.element2solr(o.getElement()) + ":{" + this.evalConditionValue(o.getValue()) + " TO *}";
        return false;
    }

    public void visitLeave(Greater o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(GreaterOrEquals o) {
        this.solrQuery = this.solrQuery + this.element2solr(o.getElement()) + ":[" + this.evalConditionValue(o.getValue()) + " TO *]";
        return false;
    }

    public void visitLeave(GreaterOrEquals o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(Keyword o) {
        String value = this.evalConditionValue(o.getValue());
        value = value.toLowerCase();
        value = "*" + value + "*";
        this.solrQuery = this.solrQuery + value;
        return false;
    }

    public void visitLeave(Keyword o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(Less o) {
        this.solrQuery = this.solrQuery + this.element2solr(o.getElement()) + ":{* TO " + this.evalConditionValue(o.getValue()) + "}";
        return false;
    }

    public void visitLeave(Less o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(LessOrEquals o) {
        this.solrQuery = this.solrQuery + this.element2solr(o.getElement()) + ":[* TO " + this.evalConditionValue(o.getValue()) + "]";
        return false;
    }

    public void visitLeave(LessOrEquals o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(Like o) {
        String element2solr = this.element2solr(o.getElement());
        if (element2solr.endsWith("_s")) {
            element2solr = element2solr + "_t";
        }
        String value = this.evalConditionValue(o.getValue());
        value = value.toLowerCase();
        this.solrQuery = this.solrQuery + element2solr + ":" + value;
        return false;
    }

    public void visitLeave(Like o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(Unlike o) {
        String element2solr = this.element2solr(o.getElement());
        if (element2solr.endsWith("_s")) {
            element2solr = element2solr + "_t";
        }
        String value = this.evalConditionValue(o.getValue());
        value = value.toLowerCase();
        this.solrQuery = this.solrQuery + "-" + element2solr + ":" + value;
        return false;
    }

    public void visitLeave(Unlike o, boolean enterOrMiddleResult) {
    }

    public void visit(Null o) {
        this.solrQuery = this.solrQuery + "#null_field-" + o.getElement().getValue() + ":true";
    }

    public void visit(NotNull o) {
        this.solrQuery = this.solrQuery + "#null_field-" + o.getElement().getValue() + ":false";
    }

    public void visit(True o) {
        this.solrQuery = this.solrQuery + "( *:* )";
    }

    public void visit(False o) {
        this.solrQuery = this.solrQuery + "( *:* - *:* )";
    }

    public void defaultVisit(Object o) {
        throw new UnsupportedOperationException("Not supported:" + o.getClass());
    }

    public boolean defaultVisitEnter(Object o) {
        throw new UnsupportedOperationException("Not supported:" + o.getClass());
    }

    public boolean defaultVisitMiddle(Object o) {
        throw new UnsupportedOperationException("Not supported:" + o.getClass());
    }

    public void defaultVisitLeave(Object o, boolean enterResult) {
        throw new UnsupportedOperationException("Not supported:" + o.getClass());
    }
}

