/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage.solr;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.solr.core.StandardDirectoryFactory;

public class RAMDirectoryFactory
extends StandardDirectoryFactory {
    private static Map<String, RefCntRamDirectory> directories = new HashMap<String, RefCntRamDirectory>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directory open(String path) throws IOException {
        Class<RAMDirectoryFactory> clazz = RAMDirectoryFactory.class;
        synchronized (RAMDirectoryFactory.class) {
            RefCntRamDirectory directory = directories.get(path);
            if (directory == null || !directory.isOpen()) {
                directory = (RefCntRamDirectory)this.openNew(path);
                directories.put(path, directory);
            } else {
                directory.incRef();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return directory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String path) {
        Class<RAMDirectoryFactory> clazz = RAMDirectoryFactory.class;
        synchronized (RAMDirectoryFactory.class) {
            RefCntRamDirectory directory = directories.get(path);
            if (directory == null || !directory.isOpen()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    Directory openNew(String path) throws IOException {
        RefCntRamDirectory directory;
        File dirFile = new File(path);
        boolean indexExists = dirFile.canRead();
        if (indexExists) {
            Directory dir = super.open(path);
            directory = new RefCntRamDirectory(dir);
        } else {
            directory = new RefCntRamDirectory();
        }
        return directory;
    }

    public static class RefCntRamDirectory
    extends RAMDirectory {
        private final AtomicInteger refCount = new AtomicInteger();

        public RefCntRamDirectory() {
            this.refCount.set(1);
        }

        public RefCntRamDirectory(Directory dir) throws IOException {
            this();
            Directory.copy((Directory)dir, (Directory)this, (boolean)false);
        }

        public void incRef() {
            this.ensureOpen();
            this.refCount.incrementAndGet();
        }

        public void decRef() {
            this.ensureOpen();
            if (this.refCount.getAndDecrement() == 1) {
                super.close();
            }
        }

        public final synchronized void close() {
            this.decRef();
        }

        public boolean isOpen() {
            return this.isOpen;
        }
    }
}

