/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.wikitty.generator.WikittyTransformerUtil;

public class WikittyImplementationGenerator
extends ObjectModelTransformerToJava {
    protected Map<ObjectModelClass, ObjectModelClass> processedClasses = new HashMap<ObjectModelClass, ObjectModelClass>();

    public void transformFromClass(ObjectModelClass clazz) {
        if (clazz.getOperations().isEmpty()) {
            ObjectModelClass implementation;
            if (WikittyTransformerUtil.isBusinessEntity(clazz)) {
                implementation = this.prepareImplementation(clazz);
                this.processBusinessEntity(clazz, implementation);
            }
            if (WikittyTransformerUtil.isMetaExtension(clazz)) {
                implementation = this.prepareImplementation(clazz);
                this.processMetaExtension(clazz, implementation);
            }
        }
    }

    protected ObjectModelClass prepareImplementation(ObjectModelClass clazz) {
        ObjectModelClass implementation = this.processedClasses.get(clazz);
        if (implementation == null) {
            implementation = this.createClass(WikittyTransformerUtil.businessEntityToImplementationName(clazz), clazz.getPackageName());
            this.addImport((ObjectModelClassifier)implementation, "org.nuiton.wikitty.entities.BusinessEntity");
            this.addImport((ObjectModelClassifier)implementation, "org.nuiton.wikitty.entities.BusinessEntityImpl");
            this.addImport((ObjectModelClassifier)implementation, "org.nuiton.wikitty.entities.Wikitty");
            this.addImport((ObjectModelClassifier)implementation, "org.nuiton.wikitty.entities.WikittyExtension");
            this.addImport((ObjectModelClassifier)implementation, "org.nuiton.wikitty.WikittyUtil");
            this.addImport((ObjectModelClassifier)implementation, "org.nuiton.wikitty.entities.WikittyUser");
            this.addImport((ObjectModelClassifier)implementation, "org.nuiton.wikitty.entities.WikittyUserAbstract");
            this.addImport((ObjectModelClassifier)implementation, "org.nuiton.wikitty.entities.WikittyUserImpl");
            this.addImport((ObjectModelClassifier)implementation, "org.nuiton.wikitty.entities.WikittyTreeNode");
            this.addImport((ObjectModelClassifier)implementation, "org.nuiton.wikitty.entities.WikittyTreeNodeAbstract");
            this.addImport((ObjectModelClassifier)implementation, "org.nuiton.wikitty.entities.WikittyTreeNodeImpl");
            this.addImport((ObjectModelClassifier)implementation, List.class);
            this.addImport((ObjectModelClassifier)implementation, ArrayList.class);
            this.addImport((ObjectModelClassifier)implementation, Collection.class);
            this.addImport((ObjectModelClassifier)implementation, Collections.class);
            this.addImport((ObjectModelClassifier)implementation, Set.class);
            this.addImport((ObjectModelClassifier)implementation, Date.class);
            this.addImport((ObjectModelClassifier)implementation, LinkedHashSet.class);
            this.setSuperClass(implementation, WikittyTransformerUtil.businessEntityToAbstractName(clazz));
            Random random = new Random();
            Long serialVersionUIDs = random.nextLong();
            this.addConstant((ObjectModelClassifier)implementation, "serialVersionUID", "long", serialVersionUIDs.toString() + "L", ObjectModelModifier.PRIVATE);
            this.processedClasses.put(clazz, implementation);
        }
        return implementation;
    }

    protected void processBusinessEntity(ObjectModelClass clazz, ObjectModelClass implementation) {
        ObjectModelOperation constructor = this.addConstructor(implementation, ObjectModelModifier.PUBLIC);
        this.setOperationBody(constructor, "\n        super();\n");
        constructor = this.addConstructor(implementation, ObjectModelModifier.PUBLIC);
        this.addParameter(constructor, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
        this.setOperationBody(constructor, "\n        super(wikitty);\n");
        constructor = this.addConstructor(implementation, ObjectModelModifier.PUBLIC);
        this.addParameter(constructor, "org.nuiton.wikitty.entities.BusinessEntityImpl", "businessEntityImpl");
        this.setOperationBody(constructor, "\n        super(businessEntityImpl.getWikitty());\n");
    }

    protected void processMetaExtension(ObjectModelClass metaExtension, ObjectModelClass implementation) {
        ObjectModelOperation constructor = this.addConstructor(implementation, ObjectModelModifier.PUBLIC);
        this.addParameter(constructor, "org.nuiton.wikitty.entities.WikittyExtension", "extension");
        this.addParameter(constructor, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
        String contractName = WikittyTransformerUtil.businessEntityToContractName(metaExtension);
        this.setOperationBody(constructor, "\n        this.wikitty = wikitty;\n        setExtensionForMetaExtension(extension);\n");
    }
}

