package org.nuiton.wikitty.generator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.AbstractMetaTransformer;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;

/**
 * 
 * Wikitty generation steps :
 * <ol>
 *   <li>transform user model to wikitty intermediate model</li>
 *   <li>generate from wikitty intermediate model :
 *     <ul>
 *       <li>a contract;</li>
 *       <li>an abstract class;</li>
 *       <li>an implementation;</li>
 *       <li>a helper</li>
 *     </ul>
 *   </li>
 * </ol>
 * 
 * @author bleny
 * 
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.wikitty.generator.WikittyMetaGenerator"
 */

// TODO 20100610 use filter with /*[]*/




public class WikittyMetaTransformer extends AbstractMetaTransformer<ObjectModel> {
    
    private static final Log log = LogFactory.getLog(WikittyMetaTransformer.class);

    public WikittyMetaTransformer() {
        
        super(WikittyContractGenerator.class,
              WikittyAbstractGenerator.class,
              WikittyImplementationGenerator.class,
              WikittyHelperGenerator.class
              );
        
    }
    
    /**  */
    @Override
    protected boolean validateModel(ObjectModel model) {

        if (model.getClasses().isEmpty()) {
            log.warn("model doesn't contains any class");
        }

        for (ObjectModelClass clazz : model.getClasses()) {
            
            // warn user if deprecated stereotype is used
            if (clazz.getStereotypes().contains(WikittyTransformerUtil.BUSINESS_ENTITY_STEREOTYPE_OLD_NAME)) { 
                log.warn(clazz.getQualifiedName() + " uses deprecated \"" +
                        WikittyTransformerUtil.BUSINESS_ENTITY_STEREOTYPE_OLD_NAME
                        + "\" stereotype. use \"" +
                        WikittyTransformerUtil.BUSINESS_ENTITY_STEREOTYPE_NAME +
                        "\" instead");
            }

            if (!clazz.hasTagValue(WikittyTransformerUtil.TAG_VERSION)) {
                log.warn(clazz.getQualifiedName() + " misses a \"" + 
                         WikittyTransformerUtil.TAG_VERSION + "\" tagValue");
            }
        }

        return true;
    }

}
