package org.nuiton.wikitty.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelClass;

/**
 * Possible enhancement:
 * - generateParentMethod can generate attribut method access that call
 *   the same method on parent instance class. For that we must have one attribut
 *   instance by parent. This attribut we must be created in setWikitty method
 *   and used same wikitty object.
 *
 * @author poussin
 */
public class BusinessEntityImplGenerator extends WikengoCommonGenerator {
	
	private static final Log log = LogFactory.getLog(BusinessEntityImplGenerator.class);

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = clazz.getQualifiedName();
        log.info( "Filename for " + clazz.getName() + " is " +  fqn.replace('.', File.separatorChar) + ".java");
        return fqn.replace('.', File.separatorChar) + "Impl.java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz)
            throws IOException {
        if (!EugengoUtils.isBusinessEntity(clazz)) {
        	log.info( clazz.getName() + " is not a business entity");
            return;
        }

        // On ne génère pas le impl si l'entité a des opérations
        if (clazz.getOperations().size() > 0) {
            return;
        }

        log.info("Generate Business entity impl" + clazz.getName() + "... ");
        generateCopyright(output);

        String packageName = clazz.getPackageName();
        String className = clazz.getName();
        String name = className + "Impl";
output.write("package "+packageName+";\n");
output.write("\n");
output.write("");
        ObjectModelClass superClass = findSuperClass(clazz);

        clearImports();
        addImport(clazz);
        addImport(superClass);
        addImport("org.nuiton.wikitty.WikittyUtil");
        addImport("org.nuiton.wikitty.Wikitty");
        addImport("org.nuiton.wikitty.BusinessEntityWikitty");
        addImport("org.nuiton.wikitty.WikittyExtension");
        addImport(Collection.class);
        addImport(Collections.class);
        addImport(List.class);
        addImport(ArrayList.class);
        String parentImpl = null;
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (EugengoUtils.isBusinessEntity(parent)) {
                addImport(parent);
                parentImpl = parent.getQualifiedName() + "Impl"; 
                addImport( parentImpl );
            }
        }
        lookForAttributeImports(clazz);
        generateImports(output, packageName);

        generateClazzDocumentation(output, clazz);
        String abstractString = "";
        if (clazz.isAbstract()) {
            abstractString += "abstract ";
        }

output.write("public "+abstractString+"class "+className+"Impl extends "+className+"Abstract {\n");
output.write("\n");
output.write("");

        String svUID = GeneratorUtil.computeSerialVersionUID(clazz);
output.write("    private static final long serialVersionUID = "+svUID+";\n");
output.write("\n");
output.write("    public "+name+"() {\n");
output.write("        super();\n");
output.write("    }\n");
output.write("\n");
output.write("    public "+name+"(BusinessEntityWikitty wi) {\n");
output.write("        super(wi.getWikitty());\n");
output.write("    }\n");
output.write("\n");
output.write("    public "+name+"(Wikitty wi) {\n");
output.write("        super(wi);\n");
output.write("    }\n");
output.write("\n");
output.write("} //"+name+"\n");
output.write("");
    }
    
    private static Set<String> commonNumerics;
    static {
        commonNumerics = new HashSet<String>();
        commonNumerics.add("byte");
        commonNumerics.add("Byte");
        commonNumerics.add("short");
        commonNumerics.add("Short");
        commonNumerics.add("int");
        commonNumerics.add("Integer");
        commonNumerics.add("long");
        commonNumerics.add("Long");
        commonNumerics.add("float");
        commonNumerics.add("Float");
        commonNumerics.add("double");
        commonNumerics.add("Double");
    }

    private static Set<String> commonStrings;
    static {
        commonStrings = new HashSet<String>();
        commonStrings.add("char");
        commonStrings.add("Char");
        commonStrings.add("String");
    }

    private static Set<String> commonTypes;
    static {
        commonTypes = new HashSet<String>();
        commonTypes.addAll(commonNumerics);
        commonTypes.addAll(commonStrings);
        commonTypes.add("boolean");
        commonTypes.add("Boolean");
        commonTypes.add("Date");
    }

}
