/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query.function;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.query.ListObjectOrMap;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.function.FunctionValue;
import org.nuiton.wikitty.query.function.WikittyQueryFunction;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.WikittySearchEngine;

public class FunctionFieldValue
extends WikittyQueryFunction {
    private static Log log = LogFactory.getLog(FunctionFieldValue.class);

    public FunctionFieldValue(String name, String fieldName) {
        super("fieldValue", StringUtils.isNotBlank((CharSequence)name) ? name : Element.get(fieldName).getValue(), Collections.singletonList(new FunctionValue(null, Element.get(fieldName).getValue())));
    }

    public FunctionFieldValue(String methodName, String name, List<WikittyQueryFunction> args) {
        super(methodName, name, args);
        if (args.size() != 1) {
            throw new IllegalArgumentException("FieldValue accept only one argument");
        }
    }

    @Override
    public int getNumArg() {
        return 1;
    }

    @Override
    public List<Map<String, Object>> call(WikittySearchEngine searchEngine, WikittyTransaction tx, WikittyQuery query, List<Map<String, Object>> data) {
        WikittyQueryFunction f = this.getArgs().get(0);
        List<Map<String, Object>> fieldName = f.call(searchEngine, tx, query, data);
        String field = this.getUniqueValue(fieldName).toString();
        ListObjectOrMap result = new ListObjectOrMap();
        for (Map<String, Object> m : data) {
            Object val = m.get(field);
            if (val instanceof Collection) {
                for (Object o : (Collection)val) {
                    result.add(field, o);
                }
                continue;
            }
            result.add(field, val);
        }
        return result;
    }
}

