/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: FacetTopic.java 1462 2012-04-05 15:31:15Z maven-release $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.7/wikitty-api/src/main/java/org/nuiton/wikitty/query/FacetTopic.java $
 * %%
 * Copyright (C) 2012 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.query;

import java.io.Serializable;

/**
 * Represente un topic d'une facet. Les topic sont utilise dans les resultats
 * de requete
 *
 * @author poussin
 * @version $Revision: 1462 $
 * @since 3.3
 *
 * Last update: $Date: 2012-04-05 17:31:15 +0200 (Thu, 05 Apr 2012) $
 * by : $Author: maven-release $
 */
public class FacetTopic implements Serializable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1408493244549775810L;

    protected String facetName;

    protected String topicName;

    protected int count;

    public FacetTopic(String facetName, String topicName, int count) {
        this.facetName = facetName;
        this.topicName = topicName;
        this.count = count;
    }

    public String getFacetName() {
        return facetName;
    }

    public String getTopicName() {
        return topicName;
    }

    public int getCount() {
        return count;
    }

    @Override
    public String toString() {
        String result = String.format(
                "FacetTopic(facet: '%s' topic: '%s' count: '%s')",
                getFacetName(), getTopicName(), getCount());
        return result;
    }

    
}
