/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.api.InMemorySearchTest;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.ExtensionFactory;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.search.operators.Like;
import org.nuiton.wikitty.test.CategoryEntity;
import org.nuiton.wikitty.test.CategoryEntityImpl;
import org.nuiton.wikitty.test.ProductEntity;
import org.nuiton.wikitty.test.ProductEntityImpl;

public abstract class AbstractSearchTest {
    protected static final Log log = LogFactory.getLog(AbstractSearchTest.class);
    public static final String EXT_PRODUCT = "Product";
    public static final String EXT_CATEGORY = "Category";
    public static final String PRODUCT_PRICE = "price";
    public static final String PRODUCT_NAME = "name";
    public static final String PRODUCT_CATEGORY = "category";
    public static final String PRODUCT_COLOR = "colors";
    public static final String CATEGORY_NAME = "name";
    public static final String VERSION = "3.0";
    public static String W_ID = "";
    public static String W_ENTITY_ID = "";
    protected WikittyProxy proxy = new WikittyProxy(this.getWikittyService());

    @Before
    public void initData() {
        WikittyExtension product = ExtensionFactory.create((String)EXT_PRODUCT, (String)VERSION).addField(PRODUCT_PRICE, FieldType.TYPE.NUMERIC).addField("name", FieldType.TYPE.STRING).addField(PRODUCT_CATEGORY, FieldType.TYPE.WIKITTY).addField(PRODUCT_COLOR, FieldType.TYPE.STRING).maxOccur(Integer.MAX_VALUE).extension();
        this.proxy.storeExtension(product);
        WikittyExtension category = ExtensionFactory.create((String)EXT_CATEGORY, (String)VERSION).addField("name", FieldType.TYPE.STRING).extension();
        this.proxy.storeExtension(category);
        WikittyImpl category1 = new WikittyImpl();
        category1.addExtension(category);
        category1.setField(EXT_CATEGORY, "name", (Object)"HardWare");
        this.proxy.store((Wikitty)category1);
        WikittyImpl category2 = new WikittyImpl();
        category2.addExtension(category);
        category2.setField(EXT_CATEGORY, "name", (Object)"Wrong category");
        this.proxy.store((Wikitty)category2);
        WikittyImpl product1 = new WikittyImpl();
        product1.addExtension(product);
        product1.setField(EXT_PRODUCT, "name", (Object)"Paint");
        product1.setField(EXT_PRODUCT, PRODUCT_PRICE, (Object)20);
        product1.setField(EXT_PRODUCT, PRODUCT_CATEGORY, (Object)category1.getId());
        HashSet<String> colors1 = new HashSet<String>();
        colors1.add("Blue");
        colors1.add("Black");
        product1.setField(EXT_PRODUCT, PRODUCT_COLOR, colors1);
        this.proxy.store((Wikitty)product1);
        WikittyImpl product2 = new WikittyImpl();
        product2.addExtension(product);
        product2.setField(EXT_PRODUCT, "name", (Object)"Screwdriver");
        product2.setField(EXT_PRODUCT, PRODUCT_PRICE, (Object)3);
        product2.setField(EXT_PRODUCT, PRODUCT_CATEGORY, (Object)category2.getId());
        HashSet<String> colors2 = new HashSet<String>();
        colors2.add("Red");
        colors2.add("Black");
        product2.setField(EXT_PRODUCT, PRODUCT_COLOR, colors2);
        this.proxy.store((Wikitty)product2);
        WikittyImpl product3 = new WikittyImpl();
        product3.addExtension(product);
        product3.setField(EXT_PRODUCT, "name", (Object)"Paint Blue");
        product3.setField(EXT_PRODUCT, PRODUCT_PRICE, (Object)22);
        product3.setField(EXT_PRODUCT, PRODUCT_CATEGORY, (Object)category2.getId());
        HashSet<String> colors3 = new HashSet<String>();
        colors3.add("Blue");
        product3.setField(EXT_PRODUCT, PRODUCT_COLOR, colors3);
        this.proxy.store((Wikitty)product3);
        W_ID = product3.getId();
        CategoryEntityImpl categoryEntity1 = new CategoryEntityImpl();
        categoryEntity1.setName("HardWare");
        this.proxy.store((BusinessEntity)categoryEntity1);
        CategoryEntityImpl categoryEntity2 = new CategoryEntityImpl();
        categoryEntity2.setName("Wrong category");
        this.proxy.store((BusinessEntity)categoryEntity2);
        ProductEntityImpl productEntity1 = new ProductEntityImpl();
        productEntity1.setName("Paint");
        productEntity1.setPrice(20);
        productEntity1.setCategoryEntity(categoryEntity1.getWikittyId());
        productEntity1.setColors(colors1);
        this.proxy.store((BusinessEntity)productEntity1);
        ProductEntityImpl productEntity2 = new ProductEntityImpl();
        productEntity2.setName("Screwdriver");
        productEntity2.setPrice(3);
        productEntity2.setCategoryEntity(categoryEntity2.getWikittyId());
        productEntity2.setColors(colors2);
        this.proxy.store((BusinessEntity)productEntity2);
        ProductEntityImpl productEntity3 = new ProductEntityImpl();
        productEntity3.setName("Paint Blue");
        productEntity3.setPrice(22);
        productEntity3.setCategoryEntity(categoryEntity2.getWikittyId());
        productEntity3.setColors(colors3);
        this.proxy.store((BusinessEntity)productEntity3);
        W_ENTITY_ID = productEntity3.getWikittyId();
    }

    protected void assumeNotYetImplementedInMemory() {
        boolean isInMomory = this instanceof InMemorySearchTest;
        if (isInMomory) {
            log.warn((Object)"Not yet implemented in memory, skipping");
        }
        Assume.assumeTrue((!isInMomory ? 1 : 0) != 0);
    }

    @Test
    public void testEq() throws Exception {
        Search query = Search.query().eq("Product.price", "3");
        Criteria eqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(eqCriteria);
        this.assertPagedResultSizeEquals(1, results);
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
        Search query2 = Search.query().eq("Product.name", "*dri*");
        Criteria eqCriteria2 = query2.criteria();
        PagedResult results2 = this.proxy.findAllByCriteria(eqCriteria2);
        this.assertPagedResultSizeEquals(1, results2);
        Wikitty resultW2 = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW2.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW2.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
        Search query3 = Search.query().eq("Product.name", "*dri?er");
        Criteria eqCriteria3 = query3.criteria();
        PagedResult results3 = this.proxy.findAllByCriteria(eqCriteria3);
        this.assertPagedResultSizeEquals(1, results3);
        Wikitty resultW3 = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW3.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW3.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testEntitiesEq() throws Exception {
        Search query = Search.query().eq("ProductEntity.price", "3");
        Criteria eqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, eqCriteria);
        this.assertPagedResultSizeEquals(1, results);
        ProductEntity resultW = (ProductEntity)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getName());
        Assert.assertEquals((long)3L, (long)resultW.getPrice());
        Search query2 = Search.query().eq("ProductEntity.name", "*dri*");
        Criteria eqCriteria2 = query2.criteria();
        PagedResult results2 = this.proxy.findAllByCriteria(ProductEntity.class, eqCriteria2);
        this.assertPagedResultSizeEquals(1, results2);
        ProductEntity resultW2 = (ProductEntity)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW2.getName());
        Assert.assertEquals((long)3L, (long)resultW2.getPrice());
        Search query3 = Search.query().eq("ProductEntity.name", "*dri?er");
        Criteria eqCriteria3 = query3.criteria();
        PagedResult results3 = this.proxy.findAllByCriteria(ProductEntity.class, eqCriteria3);
        this.assertPagedResultSizeEquals(1, results3);
        ProductEntity resultW3 = (ProductEntity)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW3.getName());
        Assert.assertEquals((long)3L, (long)resultW3.getPrice());
    }

    @Test
    public void testNeq() throws Exception {
        Search query = Search.query().exteq(EXT_PRODUCT).neq("Product.price", "3");
        Criteria neqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(neqCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testEntitiesNeq() throws Exception {
        Search query = Search.query().exteq("ProductEntity").neq("ProductEntity.price", "3");
        Criteria neqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, neqCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testBw() throws Exception {
        Search query = Search.query().bw("Product.price", "3", "5");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        this.assertPagedResultSizeEquals(1, results);
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testEntitiesBw() throws Exception {
        Search query = Search.query().bw("ProductEntity.price", "3", "5");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, bwCriteria);
        this.assertPagedResultSizeEquals(1, results);
        ProductEntity resultW = (ProductEntity)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getName());
        Assert.assertEquals((long)3L, (long)resultW.getPrice());
    }

    @Test
    public void testLt() throws Exception {
        Search query = Search.query().lt("Product.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        this.assertPagedResultSizeEquals(1, results);
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testEntitiesLt() throws Exception {
        Search query = Search.query().lt("ProductEntity.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, bwCriteria);
        this.assertPagedResultSizeEquals(1, results);
        ProductEntity resultW = (ProductEntity)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getName());
        Assert.assertEquals((long)3L, (long)resultW.getPrice());
    }

    @Test
    public void testLe() throws Exception {
        Search query = Search.query().le("Product.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testEntitiesLe() throws Exception {
        Search query = Search.query().le("ProductEntity.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, bwCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testGt() throws Exception {
        Search query = Search.query().gt("Product.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        this.assertPagedResultSizeEquals(1, results);
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Paint Blue", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)22L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testEntitiesGt() throws Exception {
        Search query = Search.query().gt("ProductEntity.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, bwCriteria);
        this.assertPagedResultSizeEquals(1, results);
        ProductEntity resultW = (ProductEntity)results.getFirst();
        Assert.assertEquals((Object)"Paint Blue", (Object)resultW.getName());
        Assert.assertEquals((long)22L, (long)resultW.getPrice());
    }

    @Test
    public void testGe() throws Exception {
        Search query = Search.query().ge("Product.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testEntitiesGe() throws Exception {
        Search query = Search.query().ge("ProductEntity.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, bwCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testContains() throws Exception {
        Search query = Search.query().contains("Product.price", "3", new String[0]);
        Criteria inCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(inCriteria);
        this.assertPagedResultSizeEquals(1, results);
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testEntitiesContains() throws Exception {
        Search query = Search.query().contains("ProductEntity.price", "3", new String[0]);
        Criteria inCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, inCriteria);
        this.assertPagedResultSizeEquals(1, results);
        ProductEntity resultW = (ProductEntity)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getName());
        Assert.assertEquals((long)3L, (long)resultW.getPrice());
    }

    @Test
    public void testIn() throws Exception {
        Search query = Search.query().in("Product.price", "1", new String[]{"2", "3", "4", "5"});
        Criteria inCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(inCriteria);
        this.assertPagedResultSizeEquals(1, results);
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testEntitiesIn() throws Exception {
        Search query = Search.query().in("ProductEntity.price", "1", new String[]{"2", "3", "4", "5"});
        Criteria inCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, inCriteria);
        this.assertPagedResultSizeEquals(1, results);
        ProductEntity resultW = (ProductEntity)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getName());
        Assert.assertEquals((long)3L, (long)resultW.getPrice());
    }

    @Test
    public void testExteq() throws Exception {
        Search query = Search.query().exteq(EXT_PRODUCT);
        Criteria exteqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(exteqCriteria);
        this.assertPagedResultSizeEquals(3, results);
    }

    @Test
    public void testEntitiesExteq() throws Exception {
        Search query = Search.query().exteq("ProductEntity");
        Criteria exteqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, exteqCriteria);
        this.assertPagedResultSizeEquals(3, results);
    }

    @Test
    public void testExtneq() throws Exception {
        Search query = Search.query().extneq(EXT_PRODUCT);
        Criteria extneqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(extneqCriteria);
        this.assertPagedResultSizeEquals(7, results);
    }

    @Test
    public void testIdeq() throws Exception {
        Search query = Search.query().ideq(W_ID);
        Criteria ideqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ideqCriteria);
        this.assertPagedResultSizeEquals(1, results);
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Paint Blue", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)22L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testEntitiesIdeq() throws Exception {
        Search query = Search.query().ideq(W_ENTITY_ID);
        Criteria ideqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, ideqCriteria);
        this.assertPagedResultSizeEquals(1, results);
        ProductEntity resultW = (ProductEntity)results.getFirst();
        Assert.assertEquals((Object)"Paint Blue", (Object)resultW.getName());
        Assert.assertEquals((long)22L, (long)resultW.getPrice());
    }

    @Test
    public void testIdneq() throws Exception {
        Search query = Search.query().exteq(EXT_PRODUCT).idneq(W_ID);
        Criteria idneqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(idneqCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testEntitiesIdneq() throws Exception {
        Search query = Search.query().idneq(W_ENTITY_ID);
        Criteria idneqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, idneqCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testUnlike() throws Exception {
        this.assumeNotYetImplementedInMemory();
        Search query = Search.query().exteq(EXT_PRODUCT).unlike("Product.name", "*dri*");
        Criteria likeCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(likeCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testEntitiesUnlike() throws Exception {
        this.assumeNotYetImplementedInMemory();
        Search query = Search.query().unlike("ProductEntity.name", "*dri*");
        Criteria likeCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, likeCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testLike() throws Exception {
        this.assumeNotYetImplementedInMemory();
        Search query = Search.query().like("Product.name", "*dri*");
        Criteria likeCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(likeCriteria);
        this.assertPagedResultSizeEquals(1, results);
    }

    @Test
    public void testEntitiesLike() throws Exception {
        this.assumeNotYetImplementedInMemory();
        Search query = Search.query().like("ProductEntity.name", "*dri*");
        Criteria likeCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, likeCriteria);
        this.assertPagedResultSizeEquals(1, results);
    }

    @Test
    public void testSw() throws Exception {
        Search query = Search.query().sw("Product.name", "Scre");
        Criteria swCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(swCriteria);
        this.assertPagedResultSizeEquals(1, results);
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testEntitiesSw() throws Exception {
        Search query = Search.query().sw("ProductEntity.name", "Scre");
        Criteria swCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, swCriteria);
        this.assertPagedResultSizeEquals(1, results);
        ProductEntity resultW = (ProductEntity)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getName());
        Assert.assertEquals((long)3L, (long)resultW.getPrice());
    }

    @Test
    public void testNsw() throws Exception {
        Search query = Search.query().exteq(EXT_PRODUCT).nsw("Product.name", "Scre");
        Criteria nswCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(nswCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testEntitiesNsw() throws Exception {
        Search query = Search.query().nsw("ProductEntity.name", "Scre");
        Criteria nswCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, nswCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testEw() throws Exception {
        Search query = Search.query().ew("Product.name", "ver");
        Criteria ewCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ewCriteria);
        this.assertPagedResultSizeEquals(1, results);
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testEntitiesEw() throws Exception {
        Search query = Search.query().ew("ProductEntity.name", "ver");
        Criteria ewCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, ewCriteria);
        this.assertPagedResultSizeEquals(1, results);
        ProductEntity resultW = (ProductEntity)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getName());
        Assert.assertEquals((long)3L, (long)resultW.getPrice());
    }

    @Test
    public void testNotew() throws Exception {
        Search query = Search.query().exteq(EXT_PRODUCT).notew("Product.name", "ver");
        Criteria notewCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(notewCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testEntitiesNotew() throws Exception {
        Search query = Search.query().notew("ProductEntity.name", "ver");
        Criteria notewCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, notewCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testKeyword() throws Exception {
        Search query = Search.query().exteq(EXT_PRODUCT).keyword("Paint");
        Criteria keywordCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(keywordCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testEntitiesKeyword() throws Exception {
        Search query = Search.query().exteq("ProductEntity").keyword("Paint");
        Criteria keywordCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, keywordCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testIsNull() throws Exception {
        Search query = Search.query().isNull("Product.name");
        Criteria isNull = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(isNull);
        this.assertPagedResultSizeEquals(0, results);
    }

    @Test
    public void testEntitiesIsNull() throws Exception {
        Search query = Search.query().isNull("ProductEntity.name");
        Criteria isNull = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, isNull);
        this.assertPagedResultSizeEquals(0, results);
    }

    @Test
    public void testIsNotNull() throws Exception {
        Search query = Search.query().isNotNull("Product.name");
        Criteria isNotNull = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(isNotNull);
        this.assertPagedResultSizeEquals(3, results);
    }

    @Test
    public void testEntitiesIsNotNull() throws Exception {
        Search query = Search.query().isNotNull("ProductEntity.name");
        Criteria isNotNull = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, isNotNull);
        this.assertPagedResultSizeEquals(3, results);
    }

    @Test
    public void testFalse() throws Exception {
        Search query = Search.query().rFalse();
        Criteria rFalse = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(rFalse);
        this.assertPagedResultSizeEquals(0, results);
    }

    @Test
    public void testEntitiesFalse() throws Exception {
        Search query = Search.query().rFalse();
        Criteria rFalse = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, rFalse);
        this.assertPagedResultSizeEquals(0, results);
    }

    @Test
    public void testTrue() throws Exception {
        Search query = Search.query().exteq(EXT_PRODUCT).rTrue();
        Criteria rTrue = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(rTrue);
        this.assertPagedResultSizeEquals(3, results);
    }

    @Test
    public void testEntitiesTrue() throws Exception {
        Search query = Search.query().exteq("ProductEntity").rTrue();
        Criteria rTrue = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, rTrue);
        this.assertPagedResultSizeEquals(3, results);
    }

    @Test
    public void testAnd() throws Exception {
        Search query = Search.query().and().bw("Product.price", "15", "25").sw("Product.name", "Paint");
        Criteria andCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(andCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testEntitiesAnd() throws Exception {
        Search query = Search.query().and().bw("ProductEntity.price", "15", "25").sw("ProductEntity.name", "Paint");
        Criteria andCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, andCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testOr() throws Exception {
        Search query = Search.query();
        query.or().gt("Product.price", "20").sw("Product.name", "Screw");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testEntitiesOr() throws Exception {
        Search query = Search.query();
        query.or().gt("ProductEntity.price", "20").sw("ProductEntity.name", "Screw");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, bwCriteria);
        this.assertPagedResultSizeEquals(2, results);
    }

    @Test
    public void testNot() throws Exception {
        Search query = Search.query();
        query.exteq(EXT_PRODUCT).not().ge("Product.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        this.assertPagedResultSizeEquals(1, results);
    }

    @Test
    public void testEntitiesNot() throws Exception {
        Search query = Search.query();
        query.exteq("ProductEntity").not().ge("ProductEntity.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, bwCriteria);
        this.assertPagedResultSizeEquals(1, results);
    }

    @Test
    public void testAssociated() throws Exception {
        Search query = Search.query().bw("Product.price", "15", "25").sw("Product.name", "Paint").associated("Product.category").eq("Category.name", "HardWare");
        Criteria associatedCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(associatedCriteria);
        this.assertPagedResultSizeEquals(1, results);
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Paint", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)20L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
        query = Search.query().bw("Product.price", "15", "25").sw("Product.name", "Paint").associated("Product.category").eq("Category.name", "don't return anything");
        associatedCriteria = query.criteria();
        results = this.proxy.findAllByCriteria(associatedCriteria);
        this.assertPagedResultSizeEquals(0, results);
    }

    @Test
    public void testEntitiesAssociated() throws Exception {
        Search query = Search.query().bw("ProductEntity.price", "15", "25").sw("ProductEntity.name", "Paint").associated("ProductEntity.categoryEntity").eq("CategoryEntity.name", "HardWare");
        Criteria associatedCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ProductEntity.class, associatedCriteria);
        this.assertPagedResultSizeEquals(1, results);
        ProductEntity resultW = (ProductEntity)results.getFirst();
        Assert.assertEquals((Object)"Paint", (Object)resultW.getName());
        Assert.assertEquals((long)20L, (long)resultW.getPrice());
        query = Search.query().bw("ProductEntity.price", "15", "25").sw("ProductEntity.name", "Paint").associated("ProductEntity.categoryEntity").eq("CategoryEntity.name", "don't return anything");
        associatedCriteria = query.criteria();
        results = this.proxy.findAllByCriteria(ProductEntity.class, associatedCriteria);
        this.assertPagedResultSizeEquals(0, results);
    }

    @Test
    public void testSearchAllEquals() {
        this.assumeNotYetImplementedInMemory();
        Criteria criteria = Search.query().eq("Category.name", "HardWare").criteria();
        PagedResult pagedResult = this.proxy.findAllByCriteria(criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().eq("*.name", "HardWare").criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        this.assertPagedResultSizeEquals(2, pagedResult);
        criteria = Search.query().eq("Category.name." + FieldType.TYPE.STRING, "HardWare").criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().eq("*.name." + FieldType.TYPE.STRING, "HardWare").criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        this.assertPagedResultSizeEquals(2, pagedResult);
    }

    @Test
    public void testEntitiesSearchAllEquals() {
        this.assumeNotYetImplementedInMemory();
        Criteria criteria = Search.query().eq("CategoryEntity.name", "HardWare").criteria();
        PagedResult pagedResult = this.proxy.findAllByCriteria(CategoryEntity.class, criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().eq("*.name", "HardWare").criteria();
        pagedResult = this.proxy.findAllByCriteria(CategoryEntity.class, criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().eq("CategoryEntity.name." + FieldType.TYPE.STRING, "HardWare").criteria();
        pagedResult = this.proxy.findAllByCriteria(CategoryEntity.class, criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().eq("*.name." + FieldType.TYPE.STRING, "HardWare").criteria();
        pagedResult = this.proxy.findAllByCriteria(CategoryEntity.class, criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
    }

    @Test
    public void testSearchAllContains() {
        this.assumeNotYetImplementedInMemory();
        Criteria criteria = Search.query().contains("Product.colors", "Red", new String[0]).criteria();
        PagedResult pagedResult = this.proxy.findAllByCriteria(criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().contains("*.colors", "Red", new String[0]).criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        this.assertPagedResultSizeEquals(2, pagedResult);
        criteria = Search.query().contains("Product.colors." + FieldType.TYPE.STRING, "Red", new String[0]).criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().contains("*.colors." + FieldType.TYPE.STRING, "Red", new String[0]).criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        this.assertPagedResultSizeEquals(2, pagedResult);
    }

    @Test
    public void testEntitiesSearchAllContains() {
        this.assumeNotYetImplementedInMemory();
        Criteria criteria = Search.query().contains("ProductEntity.colors", "Red", new String[0]).criteria();
        PagedResult pagedResult = this.proxy.findAllByCriteria(ProductEntity.class, criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().contains("*.colors", "Red", new String[0]).criteria();
        pagedResult = this.proxy.findAllByCriteria(ProductEntity.class, criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().contains("ProductEntity.colors." + FieldType.TYPE.STRING, "Red", new String[0]).criteria();
        pagedResult = this.proxy.findAllByCriteria(ProductEntity.class, criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().contains("*.colors." + FieldType.TYPE.STRING, "Red", new String[0]).criteria();
        pagedResult = this.proxy.findAllByCriteria(ProductEntity.class, criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
    }

    @Test
    public void testSearchAllLike() {
        this.assumeNotYetImplementedInMemory();
        Criteria criteria = Search.query().like("Product.name", "*Blue").criteria();
        PagedResult pagedResult = this.proxy.findAllByCriteria(criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().like("*.name", "*Blue").criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        this.assertPagedResultSizeEquals(2, pagedResult);
        criteria = Search.query().like("Product.name." + FieldType.TYPE.STRING, "*Blue").criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().like("*.name." + FieldType.TYPE.STRING, "*Blue").criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        this.assertPagedResultSizeEquals(2, pagedResult);
    }

    @Test
    public void testEntitiesSearchAllLike() {
        this.assumeNotYetImplementedInMemory();
        Criteria criteria = Search.query().like("ProductEntity.name", "*Blue").criteria();
        PagedResult pagedResult = this.proxy.findAllByCriteria(ProductEntity.class, criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().like("*.name", "*Blue").criteria();
        pagedResult = this.proxy.findAllByCriteria(ProductEntity.class, criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().like("ProductEntity.name." + FieldType.TYPE.STRING, "*Blue").criteria();
        pagedResult = this.proxy.findAllByCriteria(ProductEntity.class, criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().like("*.name." + FieldType.TYPE.STRING, "*Blue").criteria();
        pagedResult = this.proxy.findAllByCriteria(ProductEntity.class, criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
    }

    @Test
    public void testSearchAllLowerCase() {
        this.assumeNotYetImplementedInMemory();
        Criteria criteria = Search.query().eq("Category.name", "HardWare").criteria();
        PagedResult pagedResult = this.proxy.findAllByCriteria(criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().eq("Category.name", "hardware").criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        this.assertPagedResultSizeEquals(0, pagedResult);
        criteria = Search.query().like("Category.name", "HardWare", Like.SearchAs.ToLowerCase).criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().like("Category.name", "hardware", Like.SearchAs.ToLowerCase).criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().like("Category.name", "HardWare", Like.SearchAs.AsText).criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().like("Category.name", "hardware", Like.SearchAs.AsText).criteria();
        pagedResult = this.proxy.findAllByCriteria(criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
    }

    @Test
    public void testEntitiesSearchAllLowerCase() {
        this.assumeNotYetImplementedInMemory();
        Criteria criteria = Search.query().eq("CategoryEntity.name", "HardWare").criteria();
        PagedResult pagedResult = this.proxy.findAllByCriteria(CategoryEntity.class, criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().eq("CategoryEntity.name", "hardware").criteria();
        pagedResult = this.proxy.findAllByCriteria(CategoryEntity.class, criteria);
        this.assertPagedResultSizeEquals(0, pagedResult);
        criteria = Search.query().like("CategoryEntity.name", "HardWare", Like.SearchAs.ToLowerCase).criteria();
        pagedResult = this.proxy.findAllByCriteria(CategoryEntity.class, criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().like("CategoryEntity.name", "hardware", Like.SearchAs.ToLowerCase).criteria();
        pagedResult = this.proxy.findAllByCriteria(CategoryEntity.class, criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().like("CategoryEntity.name", "HardWare", Like.SearchAs.AsText).criteria();
        pagedResult = this.proxy.findAllByCriteria(CategoryEntity.class, criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
        criteria = Search.query().like("CategoryEntity.name", "hardware", Like.SearchAs.AsText).criteria();
        pagedResult = this.proxy.findAllByCriteria(CategoryEntity.class, criteria);
        this.assertPagedResultSizeEquals(1, pagedResult);
    }

    @Test
    public void testSearchWithSort() {
        this.assumeNotYetImplementedInMemory();
        Criteria criteria = Search.query().like("*.name", "*").criteria();
        criteria.setSortAscending(new String[]{"*.name"});
        try {
            this.proxy.findAllByCriteria(criteria);
        }
        catch (Exception eee) {
            eee.printStackTrace();
            Assert.fail();
        }
        String sortableExtName = "sortable";
        String numFieldName = "num";
        WikittyExtension sortable = ExtensionFactory.create((String)sortableExtName, (String)"1.0").addField(numFieldName, FieldType.TYPE.NUMERIC).extension();
        this.proxy.storeExtension(sortable);
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(10);
        expected.add(1);
        expected.add(7);
        for (Integer i : expected) {
            WikittyImpl w = new WikittyImpl();
            w.addExtension(sortable);
            w.setField(sortableExtName, numFieldName, (Object)i);
            this.proxy.store((Wikitty)w);
        }
        Collections.sort(expected);
        Criteria criteria2 = Search.query().eq(Element.ELT_EXTENSION, sortableExtName).criteria();
        criteria2.setSortAscending(new String[]{WikittyUtil.getFQFieldName((String)sortableExtName, (String)numFieldName)});
        PagedResult result = this.proxy.findAllByCriteria(criteria2);
        ArrayList<Integer> resulted = new ArrayList<Integer>();
        for (Wikitty w : result) {
            resulted.add(w.getFieldAsInt(sortableExtName, numFieldName));
        }
        Assert.assertEquals(expected, resulted);
    }

    @Test
    public void testSelect() throws Exception {
        this.assumeNotYetImplementedInMemory();
        Search query = Search.query().bw("Product.price", "15", "25").sw("Product.name", "Paint");
        Criteria selectCriteria = query.criteria();
        selectCriteria.setSelect("Product.category");
        PagedResult results = this.proxy.findAllByCriteria(selectCriteria);
        this.assertPagedResultSizeEquals(2, results);
        query = Search.query().bw("Product.price", "15", "25").sw("Product.name", "Paint");
        selectCriteria = query.criteria();
        selectCriteria.setSelect("Product.name");
        results = this.proxy.findAllByCriteria(selectCriteria);
        this.assertPagedResultSizeEquals(0, results);
    }

    @Test
    public void testEntitiesSelect() throws Exception {
        this.assumeNotYetImplementedInMemory();
        Search query = Search.query().bw("ProductEntity.price", "15", "25").sw("ProductEntity.name", "Paint");
        Criteria selectCriteria = query.criteria();
        selectCriteria.setSelect("ProductEntity.categoryEntity");
        PagedResult results = this.proxy.findAllByCriteria(CategoryEntity.class, selectCriteria);
        this.assertPagedResultSizeEquals(2, results);
        query = Search.query().bw("ProductEntity.price", "15", "25").sw("ProductEntity.name", "Paint");
        selectCriteria = query.criteria();
        selectCriteria.setSelect("ProductEntity.name");
        results = this.proxy.findAllByCriteria(CategoryEntity.class, selectCriteria);
        this.assertPagedResultSizeEquals(0, results);
    }

    @Test
    public void testPaginedSelect() throws Exception {
        this.assumeNotYetImplementedInMemory();
        Search query = Search.query().exteq(EXT_PRODUCT);
        Criteria selectCriteria = query.criteria();
        selectCriteria.setSelect("Product.category");
        selectCriteria.setFirstIndex(1);
        selectCriteria.setEndIndex(1);
        PagedResult results = this.proxy.findAllByCriteria(selectCriteria);
        this.assertPaginedPagedResultSizeEquals(1, 2, results);
        query = Search.query().exteq(EXT_PRODUCT);
        selectCriteria = query.criteria();
        selectCriteria.setSelect("Product.category");
        selectCriteria.setFirstIndex(0);
        selectCriteria.setEndIndex(-1);
        results = this.proxy.findAllByCriteria(selectCriteria);
        this.assertPaginedPagedResultSizeEquals(2, 2, results);
        query = Search.query().exteq(EXT_PRODUCT);
        selectCriteria = query.criteria();
        selectCriteria.setSelect("Product.category");
        selectCriteria.setFirstIndex(0);
        selectCriteria.setEndIndex(0);
        results = this.proxy.findAllByCriteria(selectCriteria);
        this.assertPaginedPagedResultSizeEquals(1, 2, results);
        query = Search.query().exteq(EXT_PRODUCT);
        selectCriteria = query.criteria();
        selectCriteria.setSelect("Product.category");
        selectCriteria.setFirstIndex(0);
        selectCriteria.setEndIndex(1);
        results = this.proxy.findAllByCriteria(selectCriteria);
        this.assertPaginedPagedResultSizeEquals(2, 2, results);
    }

    @Test
    public void testPaginedEntitiesSelect() throws Exception {
        this.assumeNotYetImplementedInMemory();
        Search query = Search.query().exteq("ProductEntity");
        Criteria selectCriteria = query.criteria();
        selectCriteria.setSelect("ProductEntity.categoryEntity");
        selectCriteria.setFirstIndex(1);
        selectCriteria.setEndIndex(1);
        PagedResult results = this.proxy.findAllByCriteria(CategoryEntity.class, selectCriteria);
        this.assertPaginedPagedResultSizeEquals(1, 2, results);
        query = Search.query().exteq("ProductEntity");
        selectCriteria = query.criteria();
        selectCriteria.setSelect("ProductEntity.categoryEntity");
        selectCriteria.setFirstIndex(0);
        selectCriteria.setEndIndex(-1);
        results = this.proxy.findAllByCriteria(CategoryEntity.class, selectCriteria);
        this.assertPaginedPagedResultSizeEquals(2, 2, results);
        query = Search.query().exteq("ProductEntity");
        selectCriteria = query.criteria();
        selectCriteria.setSelect("ProductEntity.categoryEntity");
        selectCriteria.setFirstIndex(0);
        selectCriteria.setEndIndex(0);
        results = this.proxy.findAllByCriteria(CategoryEntity.class, selectCriteria);
        this.assertPaginedPagedResultSizeEquals(1, 2, results);
        query = Search.query().exteq("ProductEntity");
        selectCriteria = query.criteria();
        selectCriteria.setSelect("ProductEntity.categoryEntity");
        selectCriteria.setFirstIndex(0);
        selectCriteria.setEndIndex(1);
        results = this.proxy.findAllByCriteria(CategoryEntity.class, selectCriteria);
        this.assertPaginedPagedResultSizeEquals(2, 2, results);
    }

    @Test
    public void testComplexQueries() throws Exception {
    }

    protected void assertPagedResultSizeEquals(int expected, PagedResult result) {
        Assert.assertEquals((long)expected, (long)result.size());
        Assert.assertEquals((long)expected, (long)result.getNumFound());
    }

    protected void assertPaginedPagedResultSizeEquals(int expected, int expectedNumFound, PagedResult result) {
        Assert.assertEquals((long)expected, (long)result.size());
        Assert.assertEquals((long)expectedNumFound, (long)result.getNumFound());
    }

    public abstract WikittyService getWikittyService();
}

