/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyClient;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.query.FacetTopic;
import org.nuiton.wikitty.query.WikittyQuery;

public class WikittyQueryResult<T>
implements Serializable,
Iterable<T> {
    private static Log log = LogFactory.getLog(WikittyQueryResult.class);
    private static final long serialVersionUID = 1L;
    protected String queryName;
    protected int offset;
    protected int totalResult;
    protected String queryString;
    protected WikittyQuery query;
    protected List<T> results;
    protected List<String> wikittyIdResult;
    protected List<Map<String, Object>> selectResult;
    protected Map<String, List<FacetTopic>> facets;
    protected transient Map<String, Map<String, FacetTopic>> facetsAsMap = null;
    protected long timeQuery;
    protected long timeConvertion;

    public WikittyQueryResult(String queryName, int offset, int totalResult, WikittyQuery query, String queryString, List<T> results, List<Map<String, Object>> selectResult, List<String> wikittyIdResult, Map<String, List<FacetTopic>> facets, long timeQuery, long timeConvertion) {
        this.queryName = queryName;
        this.offset = offset;
        this.totalResult = totalResult;
        this.query = query;
        this.queryString = queryString;
        this.results = Collections.unmodifiableList(results);
        this.selectResult = selectResult;
        this.wikittyIdResult = wikittyIdResult;
        this.facets = facets;
        this.timeQuery = timeQuery;
        this.timeConvertion = timeConvertion;
    }

    public <E> WikittyQueryResult<E> convertMapToSimple() {
        WikittyQueryResult result;
        if (this.results.isEmpty() || !(this.results.get(0) instanceof Map)) {
            result = this;
        } else {
            ArrayList data = new ArrayList(this.results.size());
            for (Map map : this.results) {
                if (map.size() != 1) {
                    throw new IllegalStateException(String.format("Map must have ONE element (currently %s", map.size()));
                }
                data.addAll(map.values());
            }
            result = new WikittyQueryResult(this.queryName, this.offset, this.totalResult, this.query, this.queryString, data, this.selectResult, this.wikittyIdResult, this.facets, this.timeQuery, this.timeConvertion);
        }
        return result;
    }

    public WikittyQueryResult<String> convertMapToSimpleString() {
        List dataObject = this.convertMapToSimple().getAll();
        ArrayList<String> data = new ArrayList<String>(dataObject.size());
        for (Object o : dataObject) {
            data.add(WikittyUtil.toString(o));
        }
        WikittyQueryResult<String> result = new WikittyQueryResult<String>(this.queryName, this.offset, this.totalResult, this.query, this.queryString, data, this.selectResult, this.wikittyIdResult, this.facets, this.timeQuery, this.timeConvertion);
        return result;
    }

    public String getQueryName() {
        return this.queryName;
    }

    @Deprecated
    public int getFirst() {
        return this.offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getTotalResult() {
        return this.totalResult;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public WikittyQuery getQuery() {
        return this.query;
    }

    public int getWikittyResultSize() {
        int result = 0;
        if (this.wikittyIdResult != null) {
            result = this.wikittyIdResult.size();
        }
        return result;
    }

    public WikittyQueryResult<String> getWikittyResult() {
        WikittyQueryResult<String> result = new WikittyQueryResult<String>(this.queryName, this.offset, this.totalResult, this.query, this.queryString, this.wikittyIdResult, this.selectResult, this.wikittyIdResult, this.facets, this.timeQuery, this.timeConvertion);
        return result;
    }

    public <E extends BusinessEntity> WikittyQueryResult<E> getWikittyResult(WikittyClient client, Class<E> clazz) {
        WikittyQueryResult<E> result = this.getWikittyResult().castTo(client, clazz);
        return result;
    }

    public boolean hasSelectResult() {
        boolean result = CollectionUtils.isNotEmpty(this.selectResult);
        return result;
    }

    public int selectResultSize() {
        int result = 0;
        if (this.hasSelectResult()) {
            result = this.selectResult.size();
        }
        return result;
    }

    public List<String> getSelectResultName() {
        ArrayList<String> result = null;
        if (this.hasSelectResult()) {
            Map<String, Object> first = this.selectResult.get(0);
            result = new ArrayList<String>(first.keySet());
        }
        return result;
    }

    public WikittyQueryResult<Map<String, Object>> getSelectResult() {
        WikittyQueryResult<Map<String, Object>> result = null;
        if (this.hasSelectResult()) {
            result = new WikittyQueryResult<Map<String, Object>>(this.queryName, this.offset, this.totalResult, this.query, this.queryString, this.selectResult, this.selectResult, this.wikittyIdResult, this.facets, this.timeQuery, this.timeConvertion);
        }
        return result;
    }

    public <E> WikittyQueryResult<Map<String, E>> getSelectResult(WikittyClient client, Class<E> clazz) {
        WikittyQueryResult<Map<String, E>> result = this.getSelectResult().castToMap(client, clazz);
        return result;
    }

    public WikittyQueryResult<Object> getSelectResult(String resultName) {
        ArrayList<Object> data = new ArrayList<Object>(this.selectResultSize());
        for (Map<String, Object> m : this.selectResult) {
            data.add(m.get(resultName));
        }
        WikittyQueryResult<Object> result = new WikittyQueryResult<Object>(this.queryName, this.offset, this.totalResult, this.query, this.queryString, data, this.selectResult, this.wikittyIdResult, this.facets, this.timeQuery, this.timeConvertion);
        return result;
    }

    public <E> WikittyQueryResult<E> getSelectResult(WikittyClient client, Class<E> clazz, String resultName) {
        WikittyQueryResult<E> result = this.getSelectResult(resultName).castTo(client, clazz);
        return result;
    }

    public Collection<String> getFacetNames() {
        Set<String> result = this.facets.keySet();
        return result;
    }

    public List<FacetTopic> getTopic(String facetName) {
        List<FacetTopic> result = this.facets.get(facetName);
        return result;
    }

    public List<FacetTopic> getTopic(Element facetName) {
        List<FacetTopic> result = this.getTopic(facetName.getValue());
        return result;
    }

    public FacetTopic getTopic(String facetName, String topicName) {
        FacetTopic result = this.getFacetsAsMap().get(facetName).get(topicName);
        return result;
    }

    public int getTopicCount(String facetName, String topicName) {
        FacetTopic topic;
        Map<String, FacetTopic> topics;
        int result = 0;
        if (this.getFacetsAsMap() != null && (topics = this.getFacetsAsMap().get(facetName)) != null && (topic = topics.get(topicName)) != null) {
            result = topic.getCount();
        }
        return result;
    }

    public Map<String, List<FacetTopic>> getFacets() {
        return this.facets;
    }

    public Map<String, Map<String, FacetTopic>> getFacetsAsMap() {
        if (this.facetsAsMap == null && this.facets != null) {
            HashMap<String, Map<String, FacetTopic>> localFacetsAsMap = new HashMap<String, Map<String, FacetTopic>>();
            for (Map.Entry<String, List<FacetTopic>> e : this.getFacets().entrySet()) {
                HashMap<String, FacetTopic> topics = new HashMap<String, FacetTopic>();
                localFacetsAsMap.put(e.getKey(), topics);
                for (FacetTopic t : e.getValue()) {
                    topics.put(t.getTopicName(), t);
                }
            }
            this.facetsAsMap = localFacetsAsMap;
        }
        return this.facetsAsMap;
    }

    public T peek() {
        T result = this.get(0);
        return result;
    }

    public T get(int i) {
        T result = this.results.get(i);
        return result;
    }

    public List<T> getAll() {
        return this.results;
    }

    public int size() {
        int result = this.results.size();
        return result;
    }

    public long getTimeQuery() {
        return this.timeQuery;
    }

    public void setTimeQuery(long timeQuery) {
        this.timeQuery = timeQuery;
    }

    public long getTimeConvertion() {
        return this.timeConvertion;
    }

    public void setTimeConvertion(long timeConvertion) {
        this.timeConvertion = timeConvertion;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator<T> result = this.getAll().iterator();
        return result;
    }

    public String toString() {
        String result = this.getQueryString() + " results " + this.getAll();
        if (!this.getFacetNames().isEmpty()) {
            result = result + "\nfacets " + this.getFacets();
        }
        return result;
    }

    public <E> WikittyQueryResult<E> castTo(WikittyClient client, Class<E> target) {
        WikittyQueryResult<E> result;
        if (target == null || Map.class.isAssignableFrom(target)) {
            result = this;
        } else {
            long startTime = System.nanoTime();
            WikittyQueryResult<E> queryResultFlated = this.convertMapToSimple();
            List<E> castedResult = client.castTo(target, queryResultFlated.getAll());
            long estimatedTime = System.nanoTime() - startTime;
            result = new WikittyQueryResult<E>(this.queryName, this.offset, this.totalResult, this.query, this.queryString, castedResult, this.selectResult, this.wikittyIdResult, this.facets, this.timeQuery, estimatedTime);
        }
        return result;
    }

    public <E, F> WikittyQueryResult<Map<String, E>> castToMap(WikittyClient client, Class<E> target) {
        long startTime = System.nanoTime();
        List castedResult = client.castToMap(target, this.getAll());
        long estimatedTime = System.nanoTime() - startTime;
        WikittyQueryResult<Map<String, E>> result = new WikittyQueryResult<Map<String, E>>(this.queryName, this.offset, this.totalResult, this.query, this.queryString, castedResult, this.selectResult, this.wikittyIdResult, this.facets, this.timeQuery, estimatedTime);
        return result;
    }
}

