package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.nuiton.wikitty.WikittyUtil;

@Generated(value = "org.nuiton.wikitty.generator.WikittyHelperGenerator", date = "Mon Jul 20 19:15:08 CEST 2015")
public class WikittyHookHelper {

    /**
     * utility class all provided methods are accessible the static way
     */
    private WikittyHookHelper() {// empty
}

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_NAME);
        return value;
}

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_NAME, name);
        return oldValue;
}

    public static Set<String> getActionToHook(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK, String.class);
        return result;
}

    public static void setActionToHook(Wikitty wikitty, Set<String> actionToHook) {
        wikitty.setField(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK, actionToHook);
}

    public static void addAllActionToHook(Wikitty wikitty, Collection<String> actionToHook) {
        if(actionToHook != null){
            for (String v:actionToHook){
                addActionToHook(wikitty, v);
            }
        }
}

    public static void addActionToHook(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.addToField(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK, v);
        }
}

    public static void removeActionToHook(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.removeFromField(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK, v);
        }
}

    public static void clearActionToHook(Wikitty wikitty) {
        wikitty.clearField(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK);
}

    public static String getScript(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_SCRIPT);
        return value;
}

    public static String setScript(Wikitty wikitty, String script) {
        String oldValue = getScript(wikitty);
        wikitty.setField(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_SCRIPT, script);
        return oldValue;
}

    public static String getMimetype(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_MIMETYPE);
        return value;
}

    public static String setMimetype(Wikitty wikitty, String mimetype) {
        String oldValue = getMimetype(wikitty);
        wikitty.setField(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_MIMETYPE, mimetype);
        return oldValue;
}

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_NAME);
            Object f2 = w2.getFieldAsObject(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK);
            Object f2 = w2.getFieldAsObject(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_SCRIPT);
            Object f2 = w2.getFieldAsObject(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_SCRIPT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_MIMETYPE);
            Object f2 = w2.getFieldAsObject(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_MIMETYPE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return 
     */
    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * check if wikitty has current extension
     * @param wikitty 
     * @return 
     */
    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WikittyHook.EXT_WIKITTYHOOK);
}

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyHookAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * supprime les extensions de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void removeExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyHookAbstract.extensions) {
            wikitty.removeExtension(ext.getName());
        }
}

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @param wikitty 
     * @return 
     */
    public static String toString(Wikitty wikitty) {

        return wikitty.toString(WikittyHook.EXT_WIKITTYHOOK);
}

} //WikittyHookHelper
