package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;

public interface WikittyGroup extends BusinessEntity {

    String EXT_WIKITTYGROUP = "WikittyGroup";

    String FIELD_WIKITTYGROUP_NAME = "name";

    String FQ_FIELD_WIKITTYGROUP_NAME = EXT_WIKITTYGROUP + ".name";

    ElementField ELEMENT_FIELD_WIKITTYGROUP_NAME = new ElementField(FQ_FIELD_WIKITTYGROUP_NAME);

    String FIELD_WIKITTYGROUP_MEMBERS = "members";

    String FQ_FIELD_WIKITTYGROUP_MEMBERS = EXT_WIKITTYGROUP + ".members";

    ElementField ELEMENT_FIELD_WIKITTYGROUP_MEMBERS = new ElementField(FQ_FIELD_WIKITTYGROUP_MEMBERS);

    String getName();

    void setName(String name);

    Set<String> getMembers();

    void setMembers(Set<String> members);

    void addAllMembers(Collection<String> members);

    void addMembers(String... element);

    void removeMembers(String... element);

    void clearMembers();

    Set<Wikitty> getMembers(boolean exceptionIfNotLoaded);

    void setMembersEntity(Collection<Wikitty> members);

    void addAllMembersEntity(Collection<Wikitty> members);

    void addMembers(Wikitty... element);

    void removeMembers(Wikitty... element);

} //WikittyGroup
