/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.api;

import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyField;
import org.nuiton.wikitty.entities.WikittyLabel;
import org.nuiton.wikitty.entities.WikittyLabelImpl;
import org.nuiton.wikitty.services.WikittyServiceInMemory;

public class WikittyUtilTest {
    private static Log log = LogFactory.getLog(WikittyUtilTest.class);

    @Test
    public void testNormalizeVersion() {
        String version = null;
        String expResult = "0.0";
        String result = WikittyUtil.normalizeVersion(version);
        Assert.assertEquals((Object)expResult, (Object)result);
        version = "";
        expResult = "0.0";
        result = WikittyUtil.normalizeVersion((String)version);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testVersionEquals() {
        String v1 = "0.4";
        String v2 = "0.4";
        boolean expResult = true;
        boolean result = WikittyUtil.versionEquals((String)v1, (String)v2);
        Assert.assertEquals((Object)expResult, (Object)result);
        v1 = "0.4.0";
        v2 = "0.4";
        expResult = false;
        result = WikittyUtil.versionEquals((String)v1, (String)v2);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testVersionGreaterThan() {
        String v1 = "4.5";
        String v2 = "4.4";
        boolean expResult = true;
        boolean result = WikittyUtil.versionGreaterThan((String)v1, (String)v2);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testIncrementMinorRevision() {
        String v = "";
        String expResult = "0.1";
        String result = WikittyUtil.incrementMinorRevision((String)v);
        Assert.assertEquals((Object)expResult, (Object)result);
        v = "0";
        expResult = "0.1";
        result = WikittyUtil.incrementMinorRevision((String)v);
        Assert.assertEquals((Object)expResult, (Object)result);
        v = "1.0";
        expResult = "1.1";
        result = WikittyUtil.incrementMinorRevision((String)v);
        Assert.assertEquals((Object)expResult, (Object)result);
        v = "1.4";
        expResult = "1.5";
        result = WikittyUtil.incrementMinorRevision((String)v);
        Assert.assertEquals((Object)expResult, (Object)result);
        v = "1.9";
        expResult = "1.10";
        result = WikittyUtil.incrementMinorRevision((String)v);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testPerfIncrementMinorRevision() {
        int MAX = 3000000;
        String v = "0";
        long time = System.currentTimeMillis();
        for (int cpt = 0; cpt < MAX; ++cpt) {
            int i = Integer.parseInt(v) + 1;
            v = String.valueOf(i);
        }
        long timeParse = System.currentTimeMillis() - time;
        v = "0";
        time = System.currentTimeMillis();
        for (int cpt = 0; cpt < MAX; ++cpt) {
            v = this.inc(v);
        }
        long timeCall = System.currentTimeMillis() - time;
        v = "0";
        time = System.currentTimeMillis();
        for (int cpt = 0; cpt < MAX; ++cpt) {
            char[] c = v.toCharArray();
            boolean retenue = true;
            block14: for (int i = c.length - 1; retenue && i >= 0; --i) {
                switch (c[i]) {
                    case '0': {
                        c[i] = 49;
                        retenue = false;
                        continue block14;
                    }
                    case '1': {
                        c[i] = 50;
                        retenue = false;
                        continue block14;
                    }
                    case '2': {
                        c[i] = 51;
                        retenue = false;
                        continue block14;
                    }
                    case '3': {
                        c[i] = 52;
                        retenue = false;
                        continue block14;
                    }
                    case '4': {
                        c[i] = 53;
                        retenue = false;
                        continue block14;
                    }
                    case '5': {
                        c[i] = 54;
                        retenue = false;
                        continue block14;
                    }
                    case '6': {
                        c[i] = 55;
                        retenue = false;
                        continue block14;
                    }
                    case '7': {
                        c[i] = 56;
                        retenue = false;
                        continue block14;
                    }
                    case '8': {
                        c[i] = 57;
                        retenue = false;
                        continue block14;
                    }
                    default: {
                        c[i] = 48;
                    }
                }
            }
            v = retenue ? "1" + String.valueOf(c) : String.valueOf(c);
        }
        long timeSwitch = System.currentTimeMillis() - time;
        log.info((Object)("Inc parse: " + timeParse + " call: " + timeCall + " switch: " + timeSwitch + " (" + v + ")"));
    }

    protected String inc(String v) {
        char[] c = v.toCharArray();
        boolean retenue = true;
        block11: for (int i = c.length - 1; retenue && i >= 0; --i) {
            switch (c[i]) {
                case '0': {
                    c[i] = 49;
                    retenue = false;
                    continue block11;
                }
                case '1': {
                    c[i] = 50;
                    retenue = false;
                    continue block11;
                }
                case '2': {
                    c[i] = 51;
                    retenue = false;
                    continue block11;
                }
                case '3': {
                    c[i] = 52;
                    retenue = false;
                    continue block11;
                }
                case '4': {
                    c[i] = 53;
                    retenue = false;
                    continue block11;
                }
                case '5': {
                    c[i] = 54;
                    retenue = false;
                    continue block11;
                }
                case '6': {
                    c[i] = 55;
                    retenue = false;
                    continue block11;
                }
                case '7': {
                    c[i] = 56;
                    retenue = false;
                    continue block11;
                }
                case '8': {
                    c[i] = 57;
                    retenue = false;
                    continue block11;
                }
                default: {
                    c[i] = 48;
                }
            }
        }
        v = retenue ? "1" + String.valueOf(c) : String.valueOf(c);
        return v;
    }

    @Test
    public void testIncrementMajorRevision() {
        String v = "";
        String expResult = "1.0";
        String result = WikittyUtil.incrementMajorRevision((String)v);
        Assert.assertEquals((Object)expResult, (Object)result);
        v = "0";
        expResult = "1.0";
        result = WikittyUtil.incrementMajorRevision((String)v);
        Assert.assertEquals((Object)expResult, (Object)result);
        v = "1.5";
        expResult = "2.0";
        result = WikittyUtil.incrementMajorRevision((String)v);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testToBigDecimal() {
        Object value = null;
        BigDecimal expResult = new BigDecimal(0);
        BigDecimal result = WikittyUtil.toBigDecimal(value);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testToBoolean() {
        Object value = null;
        boolean expResult = false;
        boolean result = WikittyUtil.toBoolean(value);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testToString() {
        Object value = null;
        Object expResult = null;
        String result = WikittyUtil.toString(value);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testToDate() {
        Object value = null;
        Object expResult = null;
        Date result = WikittyUtil.toDate(value);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testToWikitty() {
        Object value = null;
        Object expResult = null;
        String result = WikittyUtil.toWikitty(value);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testToList() {
        Object value = null;
        Class<Object> clazz = Object.class;
        Object expResult = null;
        List result = WikittyUtil.toList(value, clazz);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testGetClass() {
        Object value = null;
        Object expResult = null;
        Class result = WikittyUtil.getClass(value);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testCast() {
        Object obj = null;
        Class<Object> clazz = null;
        Object expResult = null;
        Object result = WikittyUtil.cast(obj, clazz);
        Assert.assertEquals(expResult, (Object)result);
        obj = "Toto";
        clazz = Object.class;
        expResult = "Toto";
        result = WikittyUtil.cast((Object)obj, clazz);
        Assert.assertEquals((Object)expResult, (Object)result);
        obj = new Object();
        clazz = String.class;
        expResult = obj;
        try {
            result = WikittyUtil.cast((Object)obj, clazz);
            Assert.fail((String)"cast object to string !!!");
        }
        catch (Exception eee) {
            // empty catch block
        }
    }

    @Test
    public void testUID() throws Exception {
        for (int i = 0; i < 8; ++i) {
            String uid = WikittyUtil.genUID();
            log.info((Object)("uid = " + uid));
        }
    }

    @Test
    public void testWikittyExtensionBuild() {
        String extName = "Produit";
        LinkedHashMap fields = WikittyUtil.buildFieldMapExtension((String[])new String[]{"String name", "Numeric amount", "Date buildDate"});
        Assert.assertNotNull(fields.get("name"));
        Assert.assertNotNull(fields.get("amount"));
        Assert.assertNotNull(fields.get("buildDate"));
        WikittyExtension ext = new WikittyExtension(extName, "1", null, fields);
        Assert.assertNotNull((Object)ext.getFieldType("name"));
        Assert.assertNotNull((Object)ext.getFieldType("amount"));
        Assert.assertNotNull((Object)ext.getFieldType("buildDate"));
    }

    @Test
    public void testWikittyExtensionTagValue() {
        String accentValue = "Av\u00e8c_d\u00e9s_a\u00e7cents";
        String floatValue = "3.3";
        String dateValue = "2009-12-10T12:45:31:551Z";
        String whitespaceCharacters = "ertyuio\n   <df ds \r\rf sf >sd f\n\tdf";
        LinkedHashMap fields = WikittyUtil.buildFieldMapExtension((String[])new String[]{"String name test=" + accentValue, "Numeric amount defaultValue=" + floatValue, "Date buildDate now=" + dateValue});
        FieldType fieldName = (FieldType)fields.get("name");
        Assert.assertEquals((Object)accentValue, (Object)fieldName.getTagValue("test"));
        Assert.assertEquals((Object)floatValue, (Object)((FieldType)fields.get("amount")).getTagValue("defaultValue"));
        Assert.assertEquals((Object)dateValue, (Object)((FieldType)fields.get("buildDate")).getTagValue("now"));
        fieldName.addTagValue("whitespaceCharacters", whitespaceCharacters);
        String toDefinition = fieldName.toDefinition("name");
        WikittyUtil.parseField((String)toDefinition, (FieldType)fieldName);
    }

    @Test
    public void testDateConsistency() throws Exception {
        Date date = WikittyUtil.parseDate((String)"30/01/2009");
        Date dateFormatedAndParsed = WikittyUtil.parseDate((String)WikittyUtil.formatDate((Date)date));
        Assert.assertEquals((Object)date, (Object)dateFormatedAndParsed);
        date = new Date();
        dateFormatedAndParsed = WikittyUtil.parseDate((String)WikittyUtil.formatDate((Date)date));
        Assert.assertEquals((Object)date, (Object)dateFormatedAndParsed);
    }

    @Test
    public void testParseDate() throws ParseException {
        String date = "1982-01-22T23:00:00.000+0000Z";
        Date date2 = WikittyUtil.parseDate((String)date);
        Assert.assertNotNull((Object)date2);
    }

    @Test
    public void testGetWikitty() {
        WikittyLabelImpl label = new WikittyLabelImpl();
        label.addLabels("Test");
        String wikittyId = label.getWikittyId();
        Wikitty labelWikitty = WikittyUtil.getWikitty(null, null, (BusinessEntity)label);
        Assert.assertEquals((Object)wikittyId, (Object)labelWikitty.getId());
        Assert.assertEquals(Collections.singleton("Test"), (Object)labelWikitty.getFieldAsObject("WikittyLabel", "labels"));
        ApplicationConfig config = WikittyConfig.getConfig();
        WikittyServiceInMemory ws = new WikittyServiceInMemory(config);
        ws.store(null, Collections.singleton(labelWikitty), false);
        LabelDTO dto = new LabelDTO(wikittyId);
        dto.addLabels("toto");
        dto.setWikittyVersion("2.0");
        Wikitty w = WikittyUtil.getWikitty((WikittyService)ws, null, (BusinessEntity)dto);
        WikittyLabelImpl l = new WikittyLabelImpl(w);
        Assert.assertEquals((Object)dto.getWikittyId(), (Object)l.getWikittyId());
        Assert.assertEquals((Object)dto.getWikittyVersion(), (Object)l.getWikittyVersion());
        Assert.assertEquals(dto.getLabels(), (Object)l.getLabels());
    }

    @Test
    public void testCopyBean() throws Exception {
        WikittyLabelImpl source = new WikittyLabelImpl();
        source.addLabels("toto");
        WikittyLabelImpl dest = new WikittyLabelImpl();
        WikittyUtil.copyBean((Object)source, (Object)dest);
        Assert.assertFalse((boolean)source.getWikittyId().equals(dest.getWikittyId()));
        Assert.assertEquals((Object)source.getWikittyVersion(), (Object)dest.getWikittyVersion());
        Assert.assertEquals((Object)source.getLabels(), (Object)dest.getLabels());
    }

    @Test
    public void testCopyFrom() throws Exception {
        LabelDTO source = new LabelDTO(WikittyUtil.genUID());
        source.addLabels("toto");
        source.addLabels("titi");
        Object dest = new WikittyLabelImpl();
        dest.copyFrom((BusinessEntity)source);
        Assert.assertFalse((boolean)source.getWikittyId().equals(dest.getWikittyId()));
        Assert.assertEquals((Object)source.getWikittyVersion(), (Object)dest.getWikittyVersion());
        Assert.assertEquals((Object)source.getLabels(), (Object)dest.getLabels());
        source = new WikittyLabelImpl();
        source.addLabels("toto");
        source.addLabels("titi");
        dest = new LabelDTO(WikittyUtil.genUID());
        dest.copyFrom((BusinessEntity)source);
        Assert.assertFalse((boolean)source.getWikittyId().equals(dest.getWikittyId()));
        Assert.assertEquals((Object)source.getWikittyVersion(), (Object)dest.getWikittyVersion());
        Assert.assertEquals((Object)source.getLabels(), (Object)dest.getLabels());
    }

    @Test
    public void testClone() throws Exception {
        WikittyLabelImpl source = new WikittyLabelImpl();
        source.setWikittyVersion("1.0");
        source.addLabels("toto");
        source.addLabels("titi");
        Wikitty labelWikitty = WikittyUtil.getWikitty(null, null, (BusinessEntity)source);
        Wikitty cloned = WikittyUtil.clone((Wikitty)labelWikitty, (boolean)false);
        WikittyLabelImpl labelCloned = new WikittyLabelImpl(cloned);
        Assert.assertTrue((boolean)labelWikitty.getId().equals(cloned.getId()));
        Assert.assertEquals((Object)labelWikitty.getVersion(), (Object)cloned.getVersion());
        Assert.assertTrue((boolean)source.getWikittyId().equals(labelCloned.getWikittyId()));
        Assert.assertEquals((Object)source.getWikittyVersion(), (Object)labelCloned.getWikittyVersion());
        Assert.assertEquals((Object)source.getLabels(), (Object)labelCloned.getLabels());
        source = new WikittyLabelImpl();
        source.setWikittyVersion("1.0");
        source.addLabels("toto");
        source.addLabels("titi");
        labelWikitty = WikittyUtil.getWikitty(null, null, (BusinessEntity)source);
        cloned = WikittyUtil.clone((Wikitty)labelWikitty, (boolean)true);
        labelCloned = new WikittyLabelImpl(cloned);
        Assert.assertFalse((boolean)labelWikitty.getId().equals(cloned.getId()));
        Assert.assertNotSame((Object)labelWikitty.getVersion(), (Object)cloned.getVersion());
        Assert.assertFalse((boolean)source.getWikittyId().equals(labelCloned.getWikittyId()));
        Assert.assertNotSame((Object)source.getWikittyVersion(), (Object)labelCloned.getWikittyVersion());
        Assert.assertEquals((Object)source.getLabels(), (Object)labelCloned.getLabels());
    }

    public static class LabelDTO
    implements WikittyLabel {
        protected String wikittyId;
        protected String wikittyVersion = "0.0";
        @WikittyField(fqn="WikittyLabel.labels")
        protected Set<String> labels = new LinkedHashSet<String>();

        public LabelDTO(String wikittyId) {
            this.wikittyId = wikittyId;
        }

        public String getWikittyId() {
            return this.wikittyId;
        }

        public String getWikittyVersion() {
            return this.wikittyVersion;
        }

        public void setWikittyVersion(String version) {
            this.wikittyVersion = version;
        }

        public Set<String> getLabels() {
            return this.labels;
        }

        public void setLabels(Set<String> labels) {
            this.labels = new LinkedHashSet<String>(labels);
        }

        public void addAllLabels(Set<String> labels) {
            this.labels.addAll(labels);
        }

        public void addLabels(String element) {
            this.labels.add(element);
        }

        public void removeLabels(String element) {
            this.labels.remove(element);
        }

        public void clearLabels() {
            this.labels.clear();
        }

        public void copyFrom(BusinessEntity source) {
            try {
                BeanUtils.copyProperties((Object)this, (Object)source);
            }
            catch (Exception eee) {
                throw new WikittyException(String.format("Can't copy source object %s", source), (Throwable)eee);
            }
        }

        public Collection<String> getExtensionFields(String ext) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Collection<String> getExtensionNames() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object getField(String ext, String fieldName) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setField(String ext, String fieldName, Object value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    static class MonLabel
    extends WikittyLabelImpl {
        MonLabel() {
        }
    }
}

