/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;


public  class WikittyHookHelper {

    /**
     * WikittyHookHelper :
     * utility class all provided methods are accessible the static way
     */

    private WikittyHookHelper() {// empty
}

    /**
     * getName :
     * @param wikitty 
     * @return String 
     */

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_NAME);
        return value;
}

    /**
     * setName :
     * @param wikitty 
     * @param name 
     * @return String 
     */

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_NAME, name);
        return oldValue;
}

    /**
     * getActionToHook :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getActionToHook(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK, String.class);
        return result;
}

    /**
     * setActionToHook :
     * @param wikitty 
     * @param actionToHook 
     */

    public static void setActionToHook(Wikitty wikitty, Set<String> actionToHook) {
        wikitty.setField(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK, actionToHook);
}

    /**
     * addAllActionToHook :
     * @param wikitty 
     * @param actionToHook 
     */

    public static void addAllActionToHook(Wikitty wikitty, Set<String> actionToHook) {
        if(actionToHook != null){
            for (String id:actionToHook){
                addActionToHook(wikitty, id);
            }
        }
}

    /**
     * addActionToHook :
     * @param wikitty 
     * @param element 
     */

    public static void addActionToHook(Wikitty wikitty, String element) {
        wikitty.addToField(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK, element);
}

    /**
     * removeActionToHook :
     * @param wikitty 
     * @param element 
     */

    public static void removeActionToHook(Wikitty wikitty, String element) {
        wikitty.removeFromField(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK, element);
}

    /**
     * clearActionToHook :
     * @param wikitty 
     */

    public static void clearActionToHook(Wikitty wikitty) {
        wikitty.clearField(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK);
}

    /**
     * getScript :
     * @param wikitty 
     * @return String 
     */

    public static String getScript(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_SCRIPT);
        return value;
}

    /**
     * setScript :
     * @param wikitty 
     * @param script 
     * @return String 
     */

    public static String setScript(Wikitty wikitty, String script) {
        String oldValue = getScript(wikitty);
        wikitty.setField(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_SCRIPT, script);
        return oldValue;
}

    /**
     * getMimetype :
     * @param wikitty 
     * @return String 
     */

    public static String getMimetype(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_MIMETYPE);
        return value;
}

    /**
     * setMimetype :
     * @param wikitty 
     * @param mimetype 
     * @return String 
     */

    public static String setMimetype(Wikitty wikitty, String mimetype) {
        String oldValue = getMimetype(wikitty);
        wikitty.setField(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_MIMETYPE, mimetype);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_NAME);
            Object f2 = w2.getFieldAsObject(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK);
            Object f2 = w2.getFieldAsObject(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_SCRIPT);
            Object f2 = w2.getFieldAsObject(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_SCRIPT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_MIMETYPE);
            Object f2 = w2.getFieldAsObject(WikittyHook.EXT_WIKITTYHOOK, WikittyHook.FIELD_WIKITTYHOOK_MIMETYPE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WikittyHook.EXT_WIKITTYHOOK);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyHookAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //WikittyHookHelper
