/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.TimeTrace;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.TreeNodeResult;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittySecurityUtil;
import org.nuiton.wikitty.services.WikittyServiceEnhanced;

public class WikittyProxy {
    private static Log log = LogFactory.getLog(WikittyProxy.class);
    protected static TimeTrace timeTrace = new TimeTrace();
    protected WikittyServiceEnhanced wikittyService;
    protected String securityToken;

    public WikittyProxy() {
    }

    public WikittyProxy(ApplicationConfig config) {
        if (config != null) {
            long timeToLogInfo = config.getOptionAsInt(WikittyConfig.WikittyOption.WIKITTY_PROXY_TIME_TO_LOG_INFO.getKey());
            long timeToLogWarn = config.getOptionAsInt(WikittyConfig.WikittyOption.WIKITTY_PROXY_TIME_TO_LOG_WARN.getKey());
            timeTrace.setTimeToLogInfo(timeToLogInfo);
            timeTrace.setTimeToLogWarn(timeToLogWarn);
        }
    }

    public WikittyProxy(WikittyService wikittyService) {
        this();
        this.setWikittyService(wikittyService);
    }

    public WikittyProxy(ApplicationConfig config, WikittyService wikittyService) {
        this(config);
        this.setWikittyService(wikittyService);
    }

    public static TimeTrace getTimeTrace() {
        return timeTrace;
    }

    public static Map<String, TimeTrace.CallStat> getCallCount() {
        return timeTrace.getCallCount();
    }

    public void login(String login, String password) {
        long start = TimeTrace.getTime();
        String result = this.wikittyService.login(login, password);
        this.setSecurityToken(result);
        timeTrace.add(start, "login");
    }

    public void logout() {
        long start = TimeTrace.getTime();
        this.wikittyService.logout(this.securityToken);
        timeTrace.add(start, "logout");
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public WikittyService getWikittyService() {
        return this.wikittyService.getDelegate();
    }

    public void setWikittyService(WikittyService wikittyService) {
        this.wikittyService = new WikittyServiceEnhanced(wikittyService);
    }

    public <E extends BusinessEntity> E cast(BusinessEntity source, Class<E> target) {
        long start = TimeTrace.getTime();
        E result = WikittyUtil.newInstance(this.securityToken, this.wikittyService, target, ((BusinessEntityImpl)source).getWikitty());
        timeTrace.add(start, "cast");
        return result;
    }

    public <E extends BusinessEntity> E store(E e) {
        Wikitty w = ((BusinessEntityImpl)e).getWikitty();
        w = this.store(w);
        return e;
    }

    public Wikitty store(Wikitty w) {
        long start = TimeTrace.getTime();
        WikittyEvent resp = this.wikittyService.store(this.securityToken, w);
        resp.update(w);
        timeTrace.add(start, "store");
        return w;
    }

    public <E extends BusinessEntity> List<E> store(List<E> objets) {
        long start = TimeTrace.getTime();
        ArrayList<Wikitty> wikitties = new ArrayList<Wikitty>(objets.size());
        for (BusinessEntity e : objets) {
            Wikitty w = ((BusinessEntityImpl)e).getWikitty();
            wikitties.add(w);
        }
        WikittyEvent resp = this.wikittyService.store(this.securityToken, wikitties);
        for (Wikitty w : wikitties) {
            resp.update(w);
        }
        timeTrace.add(start, "store<list>");
        return objets;
    }

    public List<Wikitty> storeWikitty(List<Wikitty> wikitties) {
        long start = TimeTrace.getTime();
        WikittyEvent resp = this.wikittyService.store(this.securityToken, wikitties);
        for (Wikitty w : wikitties) {
            resp.update(w);
        }
        timeTrace.add(start, "storeWikitty<list>");
        return wikitties;
    }

    public <E extends BusinessEntity> E restore(Class<E> clazz, String id, boolean checkExtension) {
        try {
            long start = TimeTrace.getTime();
            Object result = null;
            if (id != null) {
                HashSet<String> extNames = null;
                Wikitty wikitty = this.wikittyService.restore(this.securityToken, id);
                if (wikitty != null) {
                    if (checkExtension) {
                        extNames = new HashSet<String>(wikitty.getExtensionNames());
                    }
                    result = WikittyUtil.newInstance(this.securityToken, this.wikittyService, clazz, wikitty);
                    if (checkExtension) {
                        BusinessEntityImpl b = result;
                        Collection<WikittyExtension> BusinessEntityStaticExtensions = b.getStaticExtensions();
                        for (WikittyExtension ext : BusinessEntityStaticExtensions) {
                            String extensionName = ext.getName();
                            if (extNames.contains(extensionName)) continue;
                            result = null;
                            break;
                        }
                    }
                }
            }
            timeTrace.add(start, "restore<Business>");
            return result;
        }
        catch (SecurityException eee) {
            throw eee;
        }
        catch (Exception eee) {
            throw new WikittyException("Can't restore wikitty", eee);
        }
    }

    public Wikitty restore(String id) {
        long start = TimeTrace.getTime();
        Wikitty result = null;
        if (id != null) {
            result = this.wikittyService.restore(this.securityToken, id);
        }
        timeTrace.add(start, "restore");
        return result;
    }

    public <E extends BusinessEntity> E restore(Class<E> clazz, String id) {
        E result = this.restore(clazz, id, false);
        return result;
    }

    public List<Wikitty> restore(List<String> id) {
        long start = TimeTrace.getTime();
        List<Wikitty> result = this.wikittyService.restore(this.securityToken, id);
        timeTrace.add(start, "restoreWikitty<list>");
        return result;
    }

    public <E extends BusinessEntity> List<E> restore(Class<E> clazz, List<String> id, boolean checkExtension) {
        long start = TimeTrace.getTime();
        List<Wikitty> wikitties = this.wikittyService.restore(this.securityToken, id);
        ArrayList<E> result = new ArrayList<E>();
        for (Wikitty w : wikitties) {
            HashSet<String> extNames = null;
            if (checkExtension) {
                extNames = new HashSet<String>(w.getExtensionNames());
            }
            E dto = WikittyUtil.newInstance(this.securityToken, this.wikittyService, clazz, w);
            if (checkExtension) {
                BusinessEntityImpl b = (BusinessEntityImpl)dto;
                for (WikittyExtension ext : b.getStaticExtensions()) {
                    if (extNames.contains(ext.getName())) continue;
                    result = null;
                    break;
                }
                if (result == null) break;
            }
            result.add(dto);
        }
        timeTrace.add(start, "restore<list>");
        return result;
    }

    public <E extends BusinessEntity> List<E> restore(Class<E> clazz, List<String> id) {
        List<E> result = this.restore(clazz, id, false);
        return result;
    }

    public void delete(String id) {
        long start = TimeTrace.getTime();
        this.wikittyService.delete(this.securityToken, id);
        timeTrace.add(start, "delete");
    }

    public void delete(Collection<String> ids) {
        long start = TimeTrace.getTime();
        this.wikittyService.delete(this.securityToken, ids);
        timeTrace.add(start, "delete<list>");
    }

    public <E extends BusinessEntityImpl> PagedResult<E> findAllByExample(E e, int firstIndex, int endIndex, String ... fieldFacet) {
        long start = TimeTrace.getTime();
        Criteria criteria = Search.query(e.getWikitty()).criteria().setFirstIndex(firstIndex).setEndIndex(endIndex).setFacetField(fieldFacet);
        PagedResult<String> pagedResult = this.wikittyService.findAllByCriteria(this.securityToken, criteria);
        PagedResult<?> result = pagedResult.cast(this, e.getClass(), true);
        timeTrace.add(start, "findAllByExample<limit>");
        return result;
    }

    public <E extends BusinessEntityImpl> E findByExample(E e) {
        long start = TimeTrace.getTime();
        Criteria criteria = Search.query(e.getWikitty()).criteria();
        String id = this.wikittyService.findByCriteria(this.securityToken, criteria);
        BusinessEntityImpl result = null;
        if (id != null) {
            Wikitty w = this.wikittyService.restore(this.securityToken, id);
            result = (BusinessEntityImpl)WikittyUtil.newInstance(this.securityToken, this.wikittyService, e.getClass(), w);
        }
        timeTrace.add(start, "findByExample");
        return (E)result;
    }

    public <E extends BusinessEntity> PagedResult<E> findAllByCriteria(Class<E> clazz, Criteria criteria) {
        Criteria serviceCriteria;
        Search search;
        long start = TimeTrace.getTime();
        BusinessEntityImpl sample = (BusinessEntityImpl)WikittyUtil.newInstance(clazz);
        Wikitty wikitty = sample.getWikitty();
        Collection<String> extensions = wikitty.getExtensionNames();
        if (criteria == null) {
            search = Search.query();
            search = search.eq(Element.ELT_EXTENSION, extensions);
            serviceCriteria = search.criteria();
        } else {
            List<String> sortDescending;
            List<String> sortAscending;
            List<Criteria> facetCriteria;
            search = Search.query(criteria);
            search = search.eq(Element.ELT_EXTENSION, extensions);
            serviceCriteria = search.criteria(criteria.getName());
            serviceCriteria.setFirstIndex(criteria.getFirstIndex());
            serviceCriteria.setEndIndex(criteria.getEndIndex());
            List<String> facetField = criteria.getFacetField();
            if (facetField != null) {
                String[] facetFieldTab = new String[facetField.size()];
                serviceCriteria.setFacetField(facetField.toArray(facetFieldTab));
            }
            if ((facetCriteria = criteria.getFacetCriteria()) != null) {
                Criteria[] facetCriteriaTab = new Criteria[facetCriteria.size()];
                serviceCriteria.setFacetCriteria(facetCriteria.toArray(facetCriteriaTab));
            }
            if ((sortAscending = criteria.getSortAscending()) != null) {
                String[] sortAscendingTab = new String[sortAscending.size()];
                serviceCriteria.setSortAscending(sortAscending.toArray(sortAscendingTab));
            }
            if ((sortDescending = criteria.getSortDescending()) != null) {
                String[] sortDescendingTab = new String[sortDescending.size()];
                serviceCriteria.setSortDescending(sortDescending.toArray(sortDescendingTab));
            }
        }
        PagedResult<String> pagedResult = this.wikittyService.findAllByCriteria(this.securityToken, serviceCriteria);
        PagedResult<?> result = pagedResult.cast(this, sample.getClass(), true);
        timeTrace.add(start, "findAllByCriteria<Business>");
        return result;
    }

    public PagedResult<Wikitty> findAllByCriteria(Criteria criteria) {
        long start = TimeTrace.getTime();
        PagedResult<String> resultId = this.wikittyService.findAllByCriteria(this.securityToken, criteria);
        PagedResult<Wikitty> result = resultId.cast(this.securityToken, this.wikittyService);
        timeTrace.add(start, "findAllByCriteria");
        return result;
    }

    public PagedResult<String> findAllIdByCriteria(Criteria criteria) {
        long start = TimeTrace.getTime();
        PagedResult<String> result = this.wikittyService.findAllByCriteria(this.securityToken, criteria);
        timeTrace.add(start, "findAllByCriteria");
        return result;
    }

    public TreeNodeResult<Wikitty> findTreeNode(String wikittyId, int depth, boolean count, Criteria filter) {
        long start = TimeTrace.getTime();
        TreeNodeResult<String> resultId = this.wikittyService.findTreeNode(this.securityToken, wikittyId, depth, count, filter);
        RetrieveIdVisitor retrieveIdVisitor = new RetrieveIdVisitor();
        resultId.acceptVisitor(retrieveIdVisitor);
        List<String> ids = retrieveIdVisitor.getIds();
        List<Wikitty> wikitties = this.restore(ids);
        IdToObjectConverter<Wikitty> converter = new IdToObjectConverter<Wikitty>(ids, wikitties);
        ConvertTreeVisitor convertVisitor = new ConvertTreeVisitor(converter);
        resultId.acceptVisitor(convertVisitor);
        TreeNodeResult<Wikitty> result = convertVisitor.getTree();
        timeTrace.add(start, "findTreeNode<Wikitty>");
        return result;
    }

    public <E extends BusinessEntity> TreeNodeResult<E> findTreeNode(Class<E> clazz, String wikittyId, int depth, boolean count, Criteria filter) {
        long start = TimeTrace.getTime();
        TreeNodeResult<String> resultId = this.wikittyService.findTreeNode(this.securityToken, wikittyId, depth, count, filter);
        RetrieveIdVisitor retrieveIdVisitor = new RetrieveIdVisitor();
        resultId.acceptVisitor(retrieveIdVisitor);
        List<String> ids = retrieveIdVisitor.getIds();
        List<E> wikitties = this.restore(clazz, ids);
        IdToObjectConverter<E> converter = new IdToObjectConverter<E>(ids, wikitties);
        ConvertTreeVisitor convertVisitor = new ConvertTreeVisitor(converter);
        resultId.acceptVisitor(convertVisitor);
        TreeNodeResult result = convertVisitor.getTree();
        timeTrace.add(start, "findTreeNode");
        return result;
    }

    public TreeNodeResult<String> findAllIdTreeNode(String wikittyId, int depth, boolean count, Criteria filter) {
        long start = TimeTrace.getTime();
        TreeNodeResult<String> result = this.wikittyService.findTreeNode(this.securityToken, wikittyId, depth, count, filter);
        timeTrace.add(start, "findAllIdTreeNode");
        return result;
    }

    public <E extends BusinessEntity> E findByCriteria(Class<E> clazz, Criteria criteria) {
        long start = TimeTrace.getTime();
        BusinessEntityImpl sample = (BusinessEntityImpl)WikittyUtil.newInstance(clazz);
        Wikitty wikitty = sample.getWikitty();
        Collection<String> extensions = wikitty.getExtensionNames();
        Search search = Search.query(criteria);
        search = search.eq(Element.ELT_EXTENSION, extensions);
        criteria = search.criteria(criteria.getName());
        String id = this.wikittyService.findByCriteria(this.securityToken, criteria);
        Wikitty w = this.wikittyService.restore(this.securityToken, id);
        E result = WikittyUtil.newInstance(this.securityToken, this.wikittyService, clazz, w);
        timeTrace.add(start, "findByCriteria<Business>");
        return result;
    }

    public Wikitty findByCriteria(Criteria criteria) {
        long start = TimeTrace.getTime();
        String id = this.wikittyService.findByCriteria(this.securityToken, criteria);
        Wikitty wikitty = this.wikittyService.restore(this.securityToken, id);
        timeTrace.add(start, "findByCriteria");
        return wikitty;
    }

    public WikittyEvent deleteTree(String treeNodeId) {
        long start = TimeTrace.getTime();
        WikittyEvent result = this.wikittyService.deleteTree(this.securityToken, treeNodeId);
        timeTrace.add(start, "deleteTree");
        return result;
    }

    @Deprecated
    public <E extends BusinessEntity> Map.Entry<E, Integer> restoreNode(Class<E> clazz, String wikittyId, Criteria filter) {
        long start = TimeTrace.getTime();
        TreeNodeResult<E> tree = this.findTreeNode(clazz, wikittyId, 0, true, filter);
        AbstractMap.SimpleEntry<E, Integer> result = new AbstractMap.SimpleEntry<E, Integer>(tree.getObject(), tree.getAttCount());
        timeTrace.add(start, "restoreNode");
        return result;
    }

    @Deprecated
    public <E extends BusinessEntity> Map.Entry<E, Integer> restoreNode(Class<E> clazz, String wikittyId, Criteria filter, boolean checkExtension) {
        Map.Entry<E, Integer> result = this.restoreNode(clazz, wikittyId, filter);
        return result;
    }

    @Deprecated
    public <E extends BusinessEntity> Map<E, Integer> findTreeNode(Class<E> clazz, String wikittyId, Criteria filter) {
        long start = TimeTrace.getTime();
        TreeNodeResult<E> tree = this.findTreeNode(clazz, wikittyId, 1, true, filter);
        LinkedHashMap<E, Integer> result = new LinkedHashMap<E, Integer>();
        for (TreeNodeResult<E> child : tree.getChildren()) {
            result.put(child.getObject(), child.getAttCount());
        }
        timeTrace.add(start, "findTreeNode");
        return result;
    }

    @Deprecated
    public <E extends BusinessEntity> Map<E, Integer> findTreeNode(Class<E> clazz, String wikittyId, Criteria filter, boolean checkExtension) {
        Map<E, Integer> result = this.findTreeNode(clazz, wikittyId, filter);
        return result;
    }

    public Wikitty restoreVersion(String wikittyId, String version) {
        long start = TimeTrace.getTime();
        Wikitty result = this.wikittyService.restoreVersion(this.securityToken, wikittyId, version);
        timeTrace.add(start, "restoreVersion");
        return result;
    }

    public <E extends BusinessEntity> boolean hasType(Class<E> clazz, String wikittyId) {
        try {
            long start = TimeTrace.getTime();
            boolean result = true;
            Wikitty wikitty = this.wikittyService.restore(this.securityToken, wikittyId);
            if (wikitty == null) {
                result = false;
            } else {
                HashSet<String> extNames = new HashSet<String>(wikitty.getExtensionNames());
                E businessObject = WikittyUtil.newInstance(this.securityToken, this.wikittyService, clazz, wikitty);
                BusinessEntityImpl b = (BusinessEntityImpl)businessObject;
                for (WikittyExtension ext : b.getStaticExtensions()) {
                    if (extNames.contains(ext.getName())) continue;
                    result = false;
                    break;
                }
            }
            timeTrace.add(start, "hasType");
            return result;
        }
        catch (SecurityException eee) {
            throw eee;
        }
        catch (Exception eee) {
            throw new WikittyException("Can't retrieve wikitty needed for hasType test", eee);
        }
    }

    public WikittyEvent storeExtension(WikittyExtension ext) {
        long start = TimeTrace.getTime();
        WikittyEvent response = this.wikittyService.storeExtension(this.securityToken, ext);
        timeTrace.add(start, "storeExtension");
        return response;
    }

    public WikittyEvent storeExtension(Collection<WikittyExtension> exts) {
        long start = TimeTrace.getTime();
        WikittyEvent response = this.wikittyService.storeExtension(this.securityToken, exts);
        timeTrace.add(start, "storeExtension<list>");
        return response;
    }

    public WikittyExtension restoreExtension(String extensionId) {
        long start = TimeTrace.getTime();
        WikittyExtension extension = this.wikittyService.restoreExtension(this.securityToken, extensionId);
        timeTrace.add(start, "restoreExtension");
        return extension;
    }

    public WikittyExtension restoreExtensionLastVersion(String extensionName) {
        long start = TimeTrace.getTime();
        WikittyExtension extension = this.wikittyService.restoreExtensionLastVersion(this.securityToken, extensionName);
        timeTrace.add(start, "restoreExtensionLastVersion");
        return extension;
    }

    public void deleteExtension(String extName) {
        long start = TimeTrace.getTime();
        this.wikittyService.deleteExtension(this.securityToken, extName);
        timeTrace.add(start, "deleteExtension");
    }

    public void deleteExtension(Collection<String> extNames) {
        long start = TimeTrace.getTime();
        this.wikittyService.deleteExtension(this.securityToken, extNames);
        timeTrace.add(start, "deleteExtension<list>");
    }

    public List<String> getAllExtensionIds() {
        long start = TimeTrace.getTime();
        List<String> result = this.wikittyService.getAllExtensionIds(this.securityToken);
        timeTrace.add(start, "getAllExtensionIds");
        return result;
    }

    public List<String> getAllExtensionsRequires(String extensionName) {
        long start = TimeTrace.getTime();
        List<String> result = this.wikittyService.getAllExtensionsRequires(this.securityToken, extensionName);
        timeTrace.add(start, "getAllExtensionsRequires");
        return result;
    }

    public WikittyEvent clear() {
        long start = TimeTrace.getTime();
        WikittyEvent result = this.wikittyService.clear(this.securityToken);
        timeTrace.add(start, "clear");
        return result;
    }

    public void syncSearchEngine() {
        long start = TimeTrace.getTime();
        this.wikittyService.syncSearchEngine(this.securityToken);
        timeTrace.add(start, "syncSearchEngine");
    }

    public Wikitty getWikitty(BusinessEntity entity) {
        long start = TimeTrace.getTime();
        Wikitty result = WikittyUtil.getWikitty(this.wikittyService, this.securityToken, entity);
        timeTrace.add(start, "getWikitty");
        return result;
    }

    public boolean isMember(String groupName) {
        long start = TimeTrace.getTime();
        boolean result = false;
        WikittyUser user = this.getLoggedInUser();
        Search search = Search.query().eq(Element.ELT_EXTENSION, "WikittyGroup").eq("WikittyGroup.name", groupName);
        Criteria criteria = search.criteria();
        Wikitty group = this.findByCriteria(criteria);
        if (group != null) {
            result = WikittySecurityUtil.isMember(this.wikittyService, this.securityToken, user.getWikittyId(), group.getId());
        }
        timeTrace.add(start, "isMember");
        return result;
    }

    public WikittyUser getLoggedInUser() {
        long start = TimeTrace.getTime();
        String userId = WikittySecurityUtil.getUserForToken(this.wikittyService, this.securityToken);
        WikittyUser user = this.restore(WikittyUser.class, userId);
        timeTrace.add(start, "getLoggedInUser");
        return user;
    }

    private static class ConvertTreeVisitor<TARGET>
    implements TreeNodeResult.Visitor<String> {
        protected Converter<String, TARGET> converter;
        protected TreeNodeResult<TARGET> tree = null;
        protected LinkedList<TreeNodeResult<TARGET>> stack = new LinkedList();

        public ConvertTreeVisitor(Converter<String, TARGET> converter) {
            this.converter = converter;
            if (converter == null) {
                throw new IllegalArgumentException("Converter can't be null");
            }
        }

        public TreeNodeResult<TARGET> getTree() {
            return this.tree;
        }

        @Override
        public boolean visitEnter(TreeNodeResult<String> node) {
            String id = node.getObject();
            int count = node.getAttCount();
            TARGET object = this.converter.convert(id);
            TreeNodeResult<TARGET> newNode = new TreeNodeResult<TARGET>(object, count);
            TreeNodeResult<TARGET> parent = this.stack.peekLast();
            if (parent == null) {
                this.tree = newNode;
            } else {
                parent.add(newNode);
            }
            this.stack.offerLast(newNode);
            return true;
        }

        @Override
        public boolean visitLeave(TreeNodeResult<String> node) {
            this.stack.pollLast();
            return true;
        }

        private static interface Converter<SOURCE, TARGET> {
            public TARGET convert(SOURCE var1);
        }
    }

    private static class IdToObjectConverter<T>
    implements ConvertTreeVisitor.Converter<String, T> {
        protected Map<String, T> objects = new HashMap<String, T>();
        protected String securityToken;
        protected WikittyService wikittyService;

        public IdToObjectConverter(List<String> ids, List<T> objectList) {
            for (int i = 0; i < ids.size(); ++i) {
                this.objects.put(ids.get(i), objectList.get(i));
            }
        }

        @Override
        public T convert(String id) {
            T result = this.objects.get(id);
            return result;
        }
    }

    private static class RetrieveIdVisitor
    implements TreeNodeResult.Visitor<String> {
        protected List<String> ids = new ArrayList<String>();

        private RetrieveIdVisitor() {
        }

        public List<String> getIds() {
            return this.ids;
        }

        @Override
        public boolean visitEnter(TreeNodeResult<String> node) {
            String id = node.getObject();
            this.ids.add(id);
            return true;
        }

        @Override
        public boolean visitLeave(TreeNodeResult<String> node) {
            return true;
        }
    }
}

