/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.conform;

import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.conform.AbstractTestConformance;
import org.nuiton.wikitty.entities.ExtensionFactory;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;

public class SearchTest
extends AbstractTestConformance {
    private static final Log log = LogFactory.getLog(AbstractTestConformance.class);
    private ApplicationConfig config = null;

    @Override
    public ApplicationConfig getConfig() {
        if (this.config == null) {
            this.config = new WikittyConfig();
        }
        return this.config;
    }

    @Before
    public void clearStorage() throws Exception {
        this.getProxy().clear();
    }

    public void testSearch() throws Exception {
        String value = "";
        Criteria criteria = Search.query().eq("element", value).gt("element2", value).or().lt("element3", value).criteria();
    }

    @Test
    public void testSearch2() throws Exception {
        WikittyExtension ext = ExtensionFactory.create((String)"testExt", (String)"1").addField("name", FieldType.TYPE.STRING).addField("age", FieldType.TYPE.NUMERIC).addField("birth", FieldType.TYPE.DATE).extension();
        List<Object> wikitties = new LinkedList<WikittyImpl>();
        WikittyImpl w = new WikittyImpl();
        w.addExtension(ext);
        w.setField(ext.getName(), "name", (Object)"Guillaume");
        w.setField(ext.getName(), "age", (Object)"27");
        w.setField(ext.getName(), "birth", (Object)"19/04/1968");
        wikitties.add(w);
        w = new WikittyImpl();
        w.addExtension(ext);
        w.setField(ext.getName(), "name", (Object)"Toto");
        w.setField(ext.getName(), "age", (Object)"125");
        w.setField(ext.getName(), "birth", (Object)"19/04/1968 15:12");
        wikitties.add(w);
        wikitties = this.getProxy().storeWikitty(wikitties);
        Criteria criteria = Search.query().gt("testExt.birth", "19/04/1968 15:00").criteria();
        PagedResult result = this.getProxy().findAllIdByCriteria(criteria);
        List found = result.getAll();
        Assert.assertEquals((int)1, (int)found.size());
        Wikitty wikittyFound = this.getProxy().restore((String)found.get(0));
        log.info((Object)wikittyFound.getFieldAsString(ext.getName(), "birth"));
        criteria = Search.query().ge("testExt.birth", "19/04/1968").criteria();
        result = this.getProxy().findAllIdByCriteria(criteria);
        found = result.getAll();
        Assert.assertEquals((int)2, (int)found.size());
        wikittyFound = this.getProxy().restore((String)found.get(0));
        log.info((Object)wikittyFound.getFieldAsString(ext.getName(), "birth"));
        criteria = Search.query().eq("testExt.name", "Guillaume").criteria();
        result = this.getProxy().findAllIdByCriteria(criteria);
        found = result.getAll();
        Assert.assertEquals((int)1, (int)found.size());
        wikittyFound = this.getProxy().restore((String)found.get(0));
        log.info((Object)wikittyFound.getFieldAsString(ext.getName(), "name"));
        criteria = Search.query().eq("testExt.age", "125").criteria();
        result = this.getProxy().findAllIdByCriteria(criteria);
        found = result.getAll();
        Assert.assertEquals((int)1, (int)found.size());
        wikittyFound = this.getProxy().restore((String)found.get(0));
        log.info((Object)wikittyFound.getFieldAsString(ext.getName(), "name"));
        criteria = Search.query().gt("testExt.age", "10").criteria();
        result = this.getProxy().findAllIdByCriteria(criteria);
        found = result.getAll();
        Assert.assertEquals((int)2, (int)found.size());
        wikittyFound = this.getProxy().restore((String)found.get(0));
        log.info((Object)wikittyFound.getFieldAsString(ext.getName(), "name"));
        wikittyFound = this.getProxy().restore((String)found.get(1));
        log.info((Object)wikittyFound.getFieldAsString(ext.getName(), "name"));
        WikittyImpl exemple = new WikittyImpl();
        exemple.addExtension(ext);
        exemple.setField(ext.getName(), "name", (Object)"Guillaume");
        exemple.setField(ext.getName(), "age", (Object)"27");
        result = this.getProxy().findAllIdByCriteria(Search.query((Wikitty)exemple).criteria());
        found = result.getAll();
        Assert.assertEquals((int)1, (int)found.size());
        wikittyFound = this.getProxy().restore((String)found.get(0));
        log.info((Object)wikittyFound.getFieldAsString(ext.getName(), "name"));
        exemple = new WikittyImpl();
        exemple.addExtension(ext);
        exemple.setField(ext.getName(), "name", (Object)"Guillaume");
        exemple.setField(ext.getName(), "age", (Object)"125");
        result = this.getProxy().findAllIdByCriteria(Search.query((Wikitty)exemple).criteria());
        found = result.getAll();
        Assert.assertEquals((int)0, (int)found.size());
    }
}

