/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.UpdateResponse;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyExtensionStorage;
import org.nuiton.wikitty.WikittyObsoleteException;
import org.nuiton.wikitty.WikittySearchEngin;
import org.nuiton.wikitty.WikittyServiceImpl;
import org.nuiton.wikitty.WikittyStorage;
import org.nuiton.wikitty.WikittyTransaction;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.search.And;
import org.nuiton.wikitty.search.BinaryOperator;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Restriction;

public class WikittyServiceInMemory
extends WikittyServiceImpl {
    private static Log log = LogFactory.getLog(WikittyServiceInMemory.class);
    protected File persitenceFile = null;

    public WikittyServiceInMemory() {
        super(new WikittyExtensionStorageInMemory(), new WikittyStorageInMemory(), null);
        this.searchEngin = new WikittySearchEnginInMemory((WikittyStorageInMemory)this.wikittyStorage);
    }

    public WikittyServiceInMemory(File persitenceFile) {
        this();
        this.persitenceFile = persitenceFile;
        if (persitenceFile != null && persitenceFile.exists()) {
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(persitenceFile));
                ((WikittyExtensionStorageInMemory)this.extensionStorage).extensions = (Map)in.readObject();
                ((WikittyStorageInMemory)this.wikittyStorage).wikitties = (Map)in.readObject();
                in.close();
            }
            catch (Exception eee) {
                log.error((Object)("Can't read data file " + persitenceFile), (Throwable)eee);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.saveToPersistenceFile();
        super.finalize();
    }

    public void saveToPersistenceFile() {
        if (this.persitenceFile != null) {
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.persitenceFile));
                out.writeObject(((WikittyExtensionStorageInMemory)this.extensionStorage).extensions);
                out.writeObject(((WikittyStorageInMemory)this.wikittyStorage).wikitties);
                out.close();
            }
            catch (IOException eee) {
                log.error((Object)("Can't write data file " + this.persitenceFile), (Throwable)eee);
            }
        }
    }

    public static class WikittySearchEnginInMemory
    implements WikittySearchEngin {
        WikittyStorageInMemory wikittyStorage;

        public WikittySearchEnginInMemory(WikittyStorageInMemory wikittyStorage) {
            this.wikittyStorage = wikittyStorage;
        }

        @Override
        public void clear(WikittyTransaction transaction) {
        }

        @Override
        public UpdateResponse store(WikittyTransaction transaction, Collection<Wikitty> wikitties) {
            return new UpdateResponse();
        }

        @Override
        public UpdateResponse delete(WikittyTransaction transaction, Collection<String> idList) throws WikittyException {
            return new UpdateResponse();
        }

        @Override
        public void delete(Collection<String> idList) throws WikittyException {
        }

        public boolean checkRestriction(Restriction restriction, Wikitty w) {
            if (restriction instanceof BinaryOperator) {
                BinaryOperator binOp = (BinaryOperator)restriction;
                if (binOp.getElement().getName().equals(Element.ELT_EXTENSION)) {
                    return w.hasExtension(binOp.getValue());
                }
                String fqfieldName = binOp.getElement().getName();
                if (Element.ELT_EXTENSION.equals(fqfieldName)) {
                    return true;
                }
                if (Element.ELT_ID.equals(fqfieldName)) {
                    return w.getId().equals(binOp.getValue());
                }
                String[] extName = fqfieldName.split("\\.");
                if (!w.hasField(extName[0], extName[1])) {
                    return false;
                }
                Object o = w.getFqField(fqfieldName);
                FieldType t = w.getFieldType(fqfieldName);
                Object value = t.getValidValue(binOp.getValue());
                boolean checked = false;
                switch (restriction.getName()) {
                    case EQUALS: {
                        checked = value.equals(o);
                        break;
                    }
                    case LESS: {
                        checked = ((Comparable)o).compareTo(value) < 0;
                        break;
                    }
                    case LESS_OR_EQUAL: {
                        checked = ((Comparable)o).compareTo(value) <= 0;
                        break;
                    }
                    case GREATER: {
                        checked = ((Comparable)o).compareTo(value) > 0;
                        break;
                    }
                    case GREATER_OR_EQUAL: {
                        checked = ((Comparable)o).compareTo(value) >= 0;
                        break;
                    }
                    case NOT_EQUALS: {
                        checked = !value.equals(o);
                        break;
                    }
                    case ENDS_WITH: {
                        if (t.getType() != FieldType.TYPE.STRING) {
                            throw new WikittyException("Can't search for contents that 'ends with' on attribute type different of String. Attribute " + fqfieldName + " is " + t.getType().name());
                        }
                        checked = ((String)o).endsWith((String)value);
                        break;
                    }
                    case STARTS_WITH: {
                        if (t.getType() != FieldType.TYPE.STRING) {
                            throw new WikittyException("Can't search for contents that 'starts with' on attribute type different of String. Attribute " + fqfieldName + " is " + t.getType().name());
                        }
                        checked = ((String)o).startsWith((String)value);
                    }
                }
                return checked;
            }
            if (restriction instanceof And) {
                And and = (And)restriction;
                for (Restriction sub : and.getRestrictions()) {
                    if (this.checkRestriction(sub, w)) continue;
                    return false;
                }
                return true;
            }
            throw new UnsupportedOperationException((Object)((Object)restriction.getName()) + " Search Not yet implemented");
        }

        @Override
        public PagedResult<String> findAllByCriteria(WikittyTransaction transaction, Criteria criteria) {
            int firstIndex = criteria.getFirstIndex();
            int endIndex = criteria.getEndIndex();
            LinkedList<String> ids = new LinkedList<String>();
            int currentIndex = 0;
            for (Map.Entry<String, Wikitty> entry : this.wikittyStorage.wikitties.entrySet()) {
                Wikitty w = entry.getValue();
                String id = entry.getKey();
                Restriction dto = criteria.getRestriction();
                if (w.isDeleted() || !this.checkRestriction(dto, w)) continue;
                if (++currentIndex > firstIndex) {
                    ids.add(id);
                }
                if (endIndex < 0 || currentIndex < endIndex) continue;
                break;
            }
            return new PagedResult<String>(firstIndex, ids.size(), criteria.getRestriction().toString(), null, ids);
        }

        @Override
        public Integer findNodeCount(WikittyTransaction transaction, Wikitty w, Criteria filter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Map<String, Integer> findAllChildrenCount(WikittyTransaction transaction, Wikitty w, Criteria filter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class WikittyExtensionStorageInMemory
    implements WikittyExtensionStorage {
        protected Map<String, WikittyExtension> extensions = new HashMap<String, WikittyExtension>();

        @Override
        public UpdateResponse store(WikittyTransaction transaction, Collection<WikittyExtension> exts) throws WikittyException {
            for (WikittyExtension ext : exts) {
                this.extensions.put(ext.getId(), ext);
            }
            UpdateResponse result = new UpdateResponse();
            return result;
        }

        @Override
        public boolean exists(WikittyTransaction transaction, String id) {
            boolean result = this.extensions.containsKey(id);
            return result;
        }

        @Override
        public List<String> getAllExtensionIds(WikittyTransaction transaction) {
            ArrayList<String> result = new ArrayList<String>(this.extensions.keySet());
            return result;
        }

        @Override
        public List<String> getAllExtensionsRequires(WikittyTransaction transaction, String extensionName) {
            ArrayList<String> ids = new ArrayList<String>();
            Collection<WikittyExtension> values = this.extensions.values();
            if (values != null) {
                for (WikittyExtension extension : values) {
                    if (!extensionName.equals(extension.getRequires())) continue;
                    ids.add(extension.getId());
                }
            }
            return ids;
        }

        @Override
        public String getLastVersion(WikittyTransaction transaction, String extName) {
            String result = null;
            Set<String> extensionIds = this.extensions.keySet();
            for (String extensionId : extensionIds) {
                String extensionVersion = WikittyExtension.computeVersion(extensionId);
                if (!extensionId.startsWith(extName) || result != null && !WikittyUtil.versionGreaterThan(extensionVersion, result)) continue;
                result = extensionVersion;
            }
            return result;
        }

        @Override
        public WikittyExtension restore(WikittyTransaction transaction, String name, String version) throws WikittyException {
            String id = WikittyExtension.computeId(name, version);
            WikittyExtension result = this.extensions.get(id);
            if (result == null) {
                throw new WikittyException(String.format("No extension with id '%s'", id));
            }
            return result;
        }

        @Override
        public void clear(WikittyTransaction transaction) {
            this.extensions = new HashMap<String, WikittyExtension>();
        }
    }

    public static class WikittyStorageInMemory
    implements WikittyStorage {
        protected Map<String, Wikitty> wikitties = new LinkedHashMap<String, Wikitty>();

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public UpdateResponse store(WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean force) {
            UpdateResponse result = new UpdateResponse();
            for (Wikitty wikitty : wikitties) {
                block11: {
                    String actualVersion = null;
                    Wikitty inMemoryWikitty = this.wikitties.get(wikitty.getId());
                    if (inMemoryWikitty != null) {
                        actualVersion = inMemoryWikitty.getVersion();
                    }
                    String requestedVersion = wikitty.getVersion();
                    String newVersion = null;
                    if (force) {
                        if (actualVersion == null) {
                            newVersion = requestedVersion == null ? "0.0" : requestedVersion;
                        } else if (requestedVersion == null || requestedVersion.startsWith("0.")) {
                            newVersion = WikittyUtil.incrementMajorRevision(actualVersion);
                        } else {
                            if (WikittyUtil.versionEquals(actualVersion, requestedVersion)) continue;
                            if (!WikittyUtil.versionGreaterThan(requestedVersion, actualVersion)) throw new WikittyObsoleteException(String.format("Your wikitty '%s' is obsolete (saving: '%s'; existing: '%s')", wikitty.getId(), requestedVersion, actualVersion));
                            newVersion = requestedVersion;
                        }
                    } else {
                        if (WikittyUtil.versionEquals(actualVersion, requestedVersion)) continue;
                        if (WikittyUtil.versionGreaterThan(actualVersion, requestedVersion)) {
                            throw new WikittyObsoleteException(String.format("Your wikitty '%s' is obsolete", wikitty.getId()));
                        }
                        newVersion = WikittyUtil.incrementMajorRevision(actualVersion);
                    }
                    wikitty.setVersion(newVersion);
                    wikitty.clearDirty();
                    try {
                        this.wikitties.put(wikitty.getId(), wikitty.clone());
                    }
                    catch (CloneNotSupportedException ex) {
                        if (!log.isErrorEnabled()) break block11;
                        log.error((Object)"Can't clone ?", (Throwable)ex);
                    }
                }
                result.addVersionUpdate(wikitty.getId(), wikitty.getVersion());
            }
            return result;
        }

        @Override
        public UpdateResponse delete(WikittyTransaction transaction, Collection<String> idList) throws WikittyException {
            UpdateResponse result = new UpdateResponse();
            Date now = new Date();
            for (String id : idList) {
                Wikitty w = this.restore(transaction, id, new String[0]);
                w.setDeleteDate(now);
                result.addDeletionDateUpdate(id, now);
            }
            return result;
        }

        @Override
        public boolean exists(WikittyTransaction transaction, String id) {
            boolean result = this.wikitties.containsKey(id);
            return result;
        }

        @Override
        public boolean isDeleted(WikittyTransaction transaction, String id) {
            boolean result = false;
            Wikitty w = this.wikitties.get(id);
            if (w == null) {
                throw new WikittyException(String.format("No wikitty with id '%s'", id));
            }
            result = w.isDeleted();
            return result;
        }

        @Override
        public Wikitty restore(WikittyTransaction transaction, String id, String ... fqFieldName) throws WikittyException {
            Wikitty result = this.wikitties.get(id);
            if (result.isDeleted()) {
                result = null;
            }
            if (result == null) {
                throw new WikittyException(String.format("No wikitty with id '%s'", id));
            }
            return result;
        }

        @Override
        public void scanWikitties(WikittyTransaction transaction, WikittyStorage.Scanner scanner) {
            Collection<Wikitty> all = this.wikitties.values();
            for (Wikitty wikitty : all) {
                scanner.scan(wikitty.getId());
            }
        }

        @Override
        public void clear(WikittyTransaction transaction) {
            this.wikitties = new LinkedHashMap<String, Wikitty>();
        }
    }
}

