/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.notification;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;
import org.nuiton.wikitty.WikittyServiceNotifier;

public class WikittyServiceNotificationTest {
    private static Log log = LogFactory.getLog(WikittyServiceNotificationTest.class);
    protected WikittyServiceEvent.WikittyEventType lastEvent = null;
    protected int nbEvent = 0;

    @Test
    public void testEvent() throws Exception {
        WikittyServiceNotifier wsn = new WikittyServiceNotifier(null);
        Listener l = new Listener();
        wsn.addWikittyServiceListener((WikittyServiceListener)l, WikittyService.ServiceListenerType.ALL);
        this.sendEvent(wsn, true);
        wsn.removeWikittyServiceListener((WikittyServiceListener)l, WikittyService.ServiceListenerType.ALL);
        this.sendEvent(wsn, false);
        Assert.assertEquals((long)6L, (long)this.nbEvent);
    }

    protected void sendEvent(WikittyServiceNotifier wsn, boolean hasListener) throws Exception {
        WikittyServiceEvent event = new WikittyServiceEvent((Object)"test", WikittyServiceEvent.WikittyEventType.PUT_WIKITTY);
        wsn.processRemoteEvent(event);
        wsn.getEventThread().waitFor(event.getTime());
        if (hasListener) {
            Assert.assertEquals((Object)WikittyServiceEvent.WikittyEventType.PUT_WIKITTY, (Object)this.lastEvent);
        } else {
            Assert.assertEquals(null, (Object)this.lastEvent);
        }
        this.lastEvent = null;
        event = new WikittyServiceEvent((Object)"test", WikittyServiceEvent.WikittyEventType.REMOVE_WIKITTY);
        wsn.processRemoteEvent(event);
        wsn.getEventThread().waitFor(event.getTime());
        if (hasListener) {
            Assert.assertEquals((Object)WikittyServiceEvent.WikittyEventType.REMOVE_WIKITTY, (Object)this.lastEvent);
        } else {
            Assert.assertEquals(null, (Object)this.lastEvent);
        }
        this.lastEvent = null;
        event = new WikittyServiceEvent((Object)"test", WikittyServiceEvent.WikittyEventType.CLEAR_WIKITTY);
        wsn.processRemoteEvent(event);
        wsn.getEventThread().waitFor(event.getTime());
        if (hasListener) {
            Assert.assertEquals((Object)WikittyServiceEvent.WikittyEventType.CLEAR_WIKITTY, (Object)this.lastEvent);
        } else {
            Assert.assertEquals(null, (Object)this.lastEvent);
        }
        this.lastEvent = null;
        event = new WikittyServiceEvent((Object)"test", WikittyServiceEvent.WikittyEventType.PUT_EXTENSION);
        wsn.processRemoteEvent(event);
        wsn.getEventThread().waitFor(event.getTime());
        if (hasListener) {
            Assert.assertEquals((Object)WikittyServiceEvent.WikittyEventType.PUT_EXTENSION, (Object)this.lastEvent);
        } else {
            Assert.assertEquals(null, (Object)this.lastEvent);
        }
        this.lastEvent = null;
        event = new WikittyServiceEvent((Object)"test", WikittyServiceEvent.WikittyEventType.REMOVE_EXTENSION);
        wsn.processRemoteEvent(event);
        wsn.getEventThread().waitFor(event.getTime());
        if (hasListener) {
            Assert.assertEquals((Object)WikittyServiceEvent.WikittyEventType.REMOVE_EXTENSION, (Object)this.lastEvent);
        } else {
            Assert.assertEquals(null, (Object)this.lastEvent);
        }
        this.lastEvent = null;
        event = new WikittyServiceEvent((Object)"test", WikittyServiceEvent.WikittyEventType.CLEAR_EXTENSION);
        wsn.processRemoteEvent(event);
        wsn.getEventThread().waitFor(event.getTime());
        if (hasListener) {
            Assert.assertEquals((Object)WikittyServiceEvent.WikittyEventType.CLEAR_EXTENSION, (Object)this.lastEvent);
        } else {
            Assert.assertEquals(null, (Object)this.lastEvent);
        }
        this.lastEvent = null;
    }

    class Listener
    implements WikittyServiceListener {
        Listener() {
        }

        public void putWikitty(WikittyServiceEvent event) {
            ++WikittyServiceNotificationTest.this.nbEvent;
            Assert.assertEquals((Object)WikittyServiceEvent.WikittyEventType.PUT_WIKITTY, (Object)event.getType());
            WikittyServiceNotificationTest.this.lastEvent = event.getType();
        }

        public void removeWikitty(WikittyServiceEvent event) {
            ++WikittyServiceNotificationTest.this.nbEvent;
            Assert.assertEquals((Object)WikittyServiceEvent.WikittyEventType.REMOVE_WIKITTY, (Object)event.getType());
            WikittyServiceNotificationTest.this.lastEvent = event.getType();
        }

        public void clearWikitty(WikittyServiceEvent event) {
            ++WikittyServiceNotificationTest.this.nbEvent;
            Assert.assertEquals((Object)WikittyServiceEvent.WikittyEventType.CLEAR_WIKITTY, (Object)event.getType());
            WikittyServiceNotificationTest.this.lastEvent = event.getType();
        }

        public void putExtension(WikittyServiceEvent event) {
            ++WikittyServiceNotificationTest.this.nbEvent;
            Assert.assertEquals((Object)WikittyServiceEvent.WikittyEventType.PUT_EXTENSION, (Object)event.getType());
            WikittyServiceNotificationTest.this.lastEvent = event.getType();
        }

        public void removeExtension(WikittyServiceEvent event) {
            ++WikittyServiceNotificationTest.this.nbEvent;
            Assert.assertEquals((Object)WikittyServiceEvent.WikittyEventType.REMOVE_EXTENSION, (Object)event.getType());
            WikittyServiceNotificationTest.this.lastEvent = event.getType();
        }

        public void clearExtension(WikittyServiceEvent event) {
            ++WikittyServiceNotificationTest.this.nbEvent;
            Assert.assertEquals((Object)WikittyServiceEvent.WikittyEventType.CLEAR_EXTENSION, (Object)event.getType());
            WikittyServiceNotificationTest.this.lastEvent = event.getType();
        }
    }
}

