/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyI18n;
import org.nuiton.wikitty.WikittyI18nImpl;
import org.nuiton.wikitty.WikittyI18nUtil;
import org.nuiton.wikitty.WikittyLabelImpl;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceInMemory;

public class WikittyI18nTest {
    private static Log log = LogFactory.getLog(WikittyI18nTest.class);

    @Test
    public void testI18n() throws Exception {
        WikittyServiceInMemory ws = new WikittyServiceInMemory();
        WikittyProxy proxy = new WikittyProxy((WikittyService)ws);
        WikittyLabelImpl label = new WikittyLabelImpl();
        WikittyExtension ext = label.getWikitty().getExtension("WikittyLabel");
        WikittyI18n i18n = WikittyI18nUtil.getI18n((WikittyProxy)proxy, (WikittyExtension)ext);
        i18n.setTranslation("fr", "labels", "\u00e9tiquette");
        proxy.store((BusinessEntity)i18n);
        String trad = i18n.getTranslation("fr", "labels");
        Assert.assertEquals((Object)"\u00e9tiquette", (Object)trad);
        Assert.assertEquals((long)1L, (long)i18n.getLang().size());
        Assert.assertEquals((Object)"fr", i18n.getLang().iterator().next());
        Assert.assertEquals((Object)"[fr:\"labels\"=\"\u00e9tiquette\"]", (Object)i18n.getTranslations());
        i18n.setTranslation("es", "labels", "etiqueta");
        Assert.assertEquals((long)2L, (long)i18n.getLang().size());
        ((WikittyI18nImpl)i18n).translationsCache = null;
        trad = i18n.getTranslation("fr", "labels");
        Assert.assertEquals((Object)"\u00e9tiquette", (Object)trad);
    }
}

