/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty;


import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.search.Search;

/**
 * Util method to manage Label (add and find)
 *
 * @author poussin
 * @version $Revision$
 *
 * Last update: $Date$
 * by : $Author$
 */
public class WikittyLabelUtil {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(WikittyLabelUtil.class);

    /**
     * Add new lable to the wikitty object.
     *
     * @param proxy
     * @param wikittyId object'id
     * @param label label to add
     */
    static public void addLabel(WikittyProxy proxy, String wikittyId, String label) {
        Wikitty w = proxy.restore(wikittyId);
        WikittyLabelImpl l = new WikittyLabelImpl(w);
        l.addLabels(label);
        proxy.store(l);
    }

    /**
     * Recherche tous les objets qui ont ce label
     *
     * @param proxy
     * @param label
     * @param firstIndex
     * @param endIndex
     * @return
     */
    static public PagedResult<Wikitty> findAllByLabel(WikittyProxy proxy,
            String label, int firstIndex, int endIndex) {
        WikittyLabelImpl l = new WikittyLabelImpl();
        l.addLabels(label);

        Criteria criteria = Search.query(l.getWikitty()).criteria()
                .setFirstIndex(firstIndex).setEndIndex(endIndex);
        PagedResult<Wikitty> result = proxy.findAllByCriteria(criteria);

        return result;
    }

    /**
     * Recherche le premier objet qui a ce label
     * @param proxy
     * @param label
     * @return
     */
    static public Wikitty findByLabel(WikittyProxy proxy, String label) {
        WikittyLabelImpl l = new WikittyLabelImpl();
        l.addLabels(label);
        Criteria criteria = Search.query(l.getWikitty()).criteria();
        Wikitty result = proxy.findByCriteria(criteria);

        return result;
    }

    /**
     * Retrieve all labels applied on a wikitty object.
     *
     * @param proxy
     * @param wikittyId
     * @return set of label
     */
    static public Set<String> findAllAppliedLabels(WikittyProxy proxy, String wikittyId) {
        Wikitty w = proxy.restore(wikittyId);
        Set<String> result = WikittyLabelHelper.getLabels(w);

        return result;
    }

}
