/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.wikitty.ExtensionFactory;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyImpl;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceCached;
import org.nuiton.wikitty.WikittyServiceInMemory;

public class WikittyServiceCachedTest {
    protected WikittyService service;
    protected static final String EXT_NAME = "myextension";
    protected static final String FIELD_NAME = "myfield";
    protected WikittyExtension extension;
    protected Wikitty aWikitty;
    protected String token;

    @Before
    public void setUp() throws Exception {
        this.extension = ExtensionFactory.create((String)EXT_NAME, (String)"1").addField(FIELD_NAME, FieldType.TYPE.STRING).extension();
        this.aWikitty = new WikittyImpl();
        this.aWikitty.addExtension(this.extension);
        this.aWikitty.setField(EXT_NAME, FIELD_NAME, (Object)"myvalue");
        this.service = new WikittyServiceCached((WikittyService)new WikittyServiceInMemory());
        this.token = this.service.login(null, null);
        this.service.store(this.token, this.aWikitty);
    }

    @Test
    public void testRestore() throws Exception {
        Wikitty anotherWikitty = this.service.restore(this.token, this.aWikitty.getId());
        anotherWikitty.setField(EXT_NAME, FIELD_NAME, (Object)"myothervalue");
        anotherWikitty = this.service.restore(this.token, anotherWikitty.getId());
        Assert.assertEquals((Object)"myvalue", (Object)anotherWikitty.getFieldAsString(EXT_NAME, FIELD_NAME));
    }

    @Test
    public void testRestoreMultipleIds() throws Exception {
        ArrayList<String> idsToRestore = new ArrayList<String>();
        idsToRestore.add(this.aWikitty.getId());
        List otherWikitties = this.service.restore(this.token, idsToRestore);
        Wikitty anotherWikitty = (Wikitty)otherWikitties.get(0);
        anotherWikitty.setField(EXT_NAME, FIELD_NAME, (Object)"myothervalue");
        otherWikitties = this.service.restore(this.token, idsToRestore);
        anotherWikitty = (Wikitty)otherWikitties.get(0);
        Assert.assertEquals((Object)"myvalue", (Object)anotherWikitty.getFieldAsString(EXT_NAME, FIELD_NAME));
    }

    @Test
    public void testRestoreAllwaysCopyPolicy() throws Exception {
        Properties props = new Properties();
        props.setProperty("wikitty.service.cache.allwaysRestoreCopies", "true");
        this.service = new WikittyServiceCached((WikittyService)new WikittyServiceInMemory(), props);
        this.token = this.service.login(null, null);
        this.service.store(this.token, this.aWikitty);
        Wikitty anotherWikitty = this.service.restore(this.token, this.aWikitty.getId());
        Wikitty yetAnotherWikitty = this.service.restore(this.token, anotherWikitty.getId());
        Assert.assertEquals((Object)anotherWikitty, (Object)yetAnotherWikitty);
        Assert.assertNotSame((Object)anotherWikitty, (Object)yetAnotherWikitty);
    }
}

