package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class WikittyUserHelper extends WikittyUserImpl {

    private static final long serialVersionUID = 556665287L;


    /**
     * This class is not instanciable, it's just helper
     */
    private WikittyUserHelper() {
    }


    static public void setLogin(Wikitty w, String login) {
        w.setField(EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_LOGIN, login);
    }

    static public String getLogin(Wikitty w) {
        String result = w.getFieldAsString(EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_LOGIN);
        return result;
    }


    static public void setPassword(Wikitty w, String password) {
        w.setField(EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_PASSWORD, password);
    }

    static public String getPassword(Wikitty w) {
        String result = w.getFieldAsString(EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_PASSWORD);
        return result;
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_WIKITTYUSER);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_LOGIN);
            Object f2 = w2.getFieldAsObject(EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_LOGIN);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_PASSWORD);
            Object f2 = w2.getFieldAsObject(EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_PASSWORD);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //WikittyUserHelper
