/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.tapestry5.components;

import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.Inject;

@IncludeStylesheet(value={"feedback.css"})
public class FeedBack {
    @Parameter(defaultPrefix="literal", value="true")
    private boolean autoClear;
    private List<String> errorMessages = new ArrayList<String>();
    private List<String> infoMessages = new ArrayList<String>();
    private boolean errors;
    @Inject
    private ComponentResources resources;
    private boolean reload;

    void beginRender(MarkupWriter writer) {
        if (!this.errorMessages.isEmpty()) {
            this.errors = true;
            writer.element("div", new Object[]{"class", "fb-error"});
            for (String message : this.errorMessages) {
                writer.write(message);
                writer.element("br", new Object[0]);
                writer.end();
            }
            writer.end();
        }
        if (this.autoClear) {
            this.errorMessages.clear();
        }
        if (!this.infoMessages.isEmpty()) {
            writer.element("div", new Object[]{"class", "fb-info"});
            for (String message : this.infoMessages) {
                writer.write(message);
                writer.element("br", new Object[0]);
                writer.end();
            }
            writer.end();
        }
        this.infoMessages.clear();
        this.resources.renderInformalParameters(writer);
    }

    void afterRender(MarkupWriter writer) {
    }

    public void addInfo(String message) {
        if (!this.infoMessages.contains(message)) {
            this.infoMessages.add(message);
        }
    }

    public void addError(String message) {
        if (!this.errorMessages.contains(message)) {
            this.errorMessages.add(message);
        }
    }

    public boolean hasErrors() {
        return this.errors;
    }

    @Log
    public void reload() {
        this.reload = true;
    }

    public boolean hasBeeanReloaded() {
        return this.reload;
    }

    public void clearErrors() {
        this.errorMessages.clear();
        this.reload = false;
    }
}

