/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration.kernel;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Subclass;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;
import org.nuiton.topia.migration.common.ProxyClass;
import org.nuiton.topia.migration.common.SimpleProxyClass;

@Deprecated
public class DependenciesHelper {
    protected SessionFactory sessionFactory;
    protected Configuration configuration;
    private Log logger = LogFactory.getLog(DependenciesHelper.class);
    protected Map<ProxyClass, List<ProxyClass>> mDependencies;
    protected Map<ProxyClass, List<ProxyClass>> mInvertDependencies;

    public DependenciesHelper(SessionFactory sessionFactory, Configuration configuration) {
        this.configuration = configuration;
        this.sessionFactory = sessionFactory;
        this.calculateDependencies();
        if (this.logger.isDebugEnabled()) {
            for (ProxyClass clazz : this.mDependencies.keySet()) {
                this.logger.debug((Object)("Dep. for class : " + clazz.getCanonicalName() + "=" + this.mDependencies.get(clazz)));
            }
            for (ProxyClass clazz : this.mInvertDependencies.keySet()) {
                this.logger.debug((Object)("Rev Dep. for class : " + clazz.getCanonicalName() + "=" + this.mInvertDependencies.get(clazz)));
            }
        }
    }

    protected void calculateDependencies() {
        this.mDependencies = new Hashtable<ProxyClass, List<ProxyClass>>();
        this.mInvertDependencies = new Hashtable<ProxyClass, List<ProxyClass>>();
        SessionFactoryImplementor sfi = (SessionFactoryImplementor)this.sessionFactory;
        Iterator im = this.configuration.getClassMappings();
        while (im.hasNext()) {
            PersistentClass clazz;
            PersistentClass m = (PersistentClass)im.next();
            String currentClass = m.getEntityName();
            SimpleProxyClass pcCurrentClass = new SimpleProxyClass(currentClass);
            LinkedList<ProxyClass> lDependencies = new LinkedList<ProxyClass>();
            List<ProxyClass> lOldDependencies = this.mDependencies.get(pcCurrentClass);
            if (lOldDependencies != null) {
                lDependencies.addAll(lOldDependencies);
            }
            this.mDependencies.put(pcCurrentClass, lDependencies);
            if (this.mInvertDependencies.get(pcCurrentClass) == null) {
                this.mInvertDependencies.put(pcCurrentClass, new LinkedList());
            }
            if ((clazz = this.configuration.getClassMapping(currentClass)) instanceof Subclass) {
                List<ProxyClass> lOldDependents;
                Subclass usb = (Subclass)clazz;
                String superClassName = usb.getSuperclass().getEntityName();
                SimpleProxyClass pcDependentClass = new SimpleProxyClass(superClassName);
                if (!lDependencies.contains(pcDependentClass)) {
                    lDependencies.add(pcDependentClass);
                }
                if ((lOldDependents = this.mInvertDependencies.get(pcDependentClass)) == null) {
                    lOldDependents = new LinkedList<ProxyClass>();
                    this.mInvertDependencies.put(pcDependentClass, lOldDependents);
                }
                if (!lOldDependents.contains(pcCurrentClass)) {
                    lOldDependents.add(pcCurrentClass);
                }
            }
            Iterator i = clazz.getPropertyIterator();
            while (i.hasNext()) {
                List<ProxyClass> lOldDependents;
                Property p = (Property)i.next();
                Type propertyType = p.getType();
                if (!propertyType.isAssociationType()) continue;
                AssociationType a = (AssociationType)propertyType;
                Joinable j = a.getAssociatedJoinable(sfi);
                String s = a.getAssociatedEntityName(sfi);
                String dependentClassName = null;
                if (propertyType.isCollectionType()) {
                    CollectionType collectionType = (CollectionType)propertyType;
                    dependentClassName = collectionType.getAssociatedEntityName(sfi);
                } else if (!p.getCascadeStyle().equals(CascadeStyle.NONE)) {
                    dependentClassName = propertyType.getName();
                }
                if (dependentClassName == null) continue;
                SimpleProxyClass pcDependentClass = new SimpleProxyClass(dependentClassName);
                if (!lDependencies.contains(pcDependentClass)) {
                    lDependencies.add(pcDependentClass);
                }
                if ((lOldDependents = this.mInvertDependencies.get(pcDependentClass)) == null) {
                    lOldDependents = new LinkedList<ProxyClass>();
                    this.mInvertDependencies.put(pcDependentClass, lOldDependents);
                }
                if (lOldDependents.contains(pcCurrentClass)) continue;
                lOldDependents.add(pcCurrentClass);
            }
        }
    }

    public Set<ProxyClass> getDependencies(ProxyClass pc) {
        if (this.mDependencies.get(pc) == null) {
            return null;
        }
        HashSet lRecursiveDependencies = new HashSet(this.mDependencies.get(pc));
        HashSet<ProxyClass> result = new HashSet<ProxyClass>(lRecursiveDependencies);
        for (ProxyClass dependency : lRecursiveDependencies) {
            if (this.mInvertDependencies.get(dependency) != null) continue;
            result.addAll(this.getDependencies(dependency));
        }
        return result;
    }

    public Set<ProxyClass> getInvertDependencies(ProxyClass pc) {
        if (this.mInvertDependencies.get(pc) == null) {
            return null;
        }
        return new HashSet<ProxyClass>((Collection)this.mInvertDependencies.get(pc));
    }
}

