/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.nuiton.topia.migration.DatabaseManager;
import org.nuiton.topia.migration.MigrationService;
import org.nuiton.topia.migration.MigrationServiceException;
import org.nuiton.topia.migration.callback.MigrationCallbackHandler;
import org.nuiton.topia.migration.kernel.ConfigurationAdapter;
import org.nuiton.topia.migration.kernel.ConfigurationHelper;
import org.nuiton.topia.migration.kernel.Transformer;
import org.nuiton.util.Resource;
import org.nuiton.util.Version;

@Deprecated
public class MigrationServiceImpl
implements MigrationService {
    protected String currentHibernateConfigurationFile = null;
    protected Configuration currentApplicationConfiguration = null;
    protected String mappingsDirectory;
    protected Version currentApplicationVersion;
    protected List<MigrationCallbackHandler> migrationCallBackHandlers = new LinkedList<MigrationCallbackHandler>();
    private static Log logger = LogFactory.getLog(MigrationServiceImpl.class);

    @Override
    public String getConfigurationFile() {
        return this.currentHibernateConfigurationFile;
    }

    @Override
    public void setConfigurationFile(String hibernateConfigurationFile) {
        this.currentHibernateConfigurationFile = hibernateConfigurationFile;
    }

    @Override
    public Configuration getConfiguration() {
        return this.currentApplicationConfiguration;
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.currentApplicationConfiguration = configuration;
    }

    @Override
    public String getMappingsDirectory() {
        return this.mappingsDirectory;
    }

    @Override
    public void setMappingsDirectory(String mappingsDirectory) {
        this.mappingsDirectory = mappingsDirectory;
    }

    @Override
    public void setApplicationVersion(String version) {
        this.currentApplicationVersion = new Version(version);
    }

    @Override
    public void addMigrationCallbackHandler(MigrationCallbackHandler callbackHandler) {
        this.migrationCallBackHandlers.add(callbackHandler);
    }

    protected void loadApplicationConfiguration() {
        if (this.currentApplicationConfiguration == null) {
            this.currentApplicationConfiguration = new Configuration();
            if (this.currentHibernateConfigurationFile != null) {
                logger.debug((Object)("Loading configuration file : " + this.currentHibernateConfigurationFile));
                this.currentApplicationConfiguration.configure(this.currentHibernateConfigurationFile);
            } else {
                logger.debug((Object)"Loading configuration file : default hibernate configuration file");
                this.currentApplicationConfiguration.configure();
            }
        } else {
            logger.debug((Object)"Configuration given, nothing to load");
        }
    }

    protected void checkInformation() throws MigrationServiceException {
        if (this.currentApplicationVersion == null) {
            throw new MigrationServiceException("No version set");
        }
        if (this.mappingsDirectory == null) {
            throw new MigrationServiceException("No old mapping directory set");
        }
    }

    @Override
    public boolean migrateSchema() throws MigrationServiceException {
        logger.info((Object)"Starting Topia Migration Service");
        this.checkInformation();
        this.loadApplicationConfiguration();
        DatabaseManager dbManager = new DatabaseManager(this.currentApplicationConfiguration.getProperties());
        Version vdbVersion = dbManager.getDataBaseVersion();
        if (vdbVersion == null) {
            vdbVersion = Version.VZERO;
            logger.info((Object)"Database version not found, so database schema is considered as V0");
        }
        logger.info((Object)("Application version : " + this.currentApplicationVersion.getVersion() + ", database version : " + vdbVersion.getVersion()));
        boolean bMigrationNeeded = false;
        MigrationCallbackHandler.MigrationChoice bMigrationWanted = MigrationCallbackHandler.MigrationChoice.NO_MIGRATION;
        Configuration vdbConfiguration = this.getSingleConfiguration(vdbVersion);
        vdbConfiguration.setProperties(this.currentApplicationConfiguration.getProperties());
        bMigrationNeeded = dbManager.isSchemaExist(vdbConfiguration);
        if (logger.isDebugEnabled()) {
            if (bMigrationNeeded) {
                logger.debug((Object)("Schema for version " + vdbVersion.getVersion() + " found. Can do migration."));
            } else {
                logger.debug((Object)("Schema for version " + vdbVersion.getVersion() + " not found. No migration needed."));
            }
        }
        if (bMigrationNeeded && vdbVersion.compareTo(this.currentApplicationVersion) < 0) {
            logger.info((Object)"Database need update");
            bMigrationNeeded = true;
            bMigrationWanted = this.askHandlerForMigration(dbManager, vdbVersion.getVersion(), this.currentApplicationVersion.getVersion());
            logger.info((Object)("Handler choose : " + (Object)((Object)bMigrationWanted)));
        } else {
            bMigrationNeeded = false;
            logger.info((Object)"Database is up to date, no migration needed.");
        }
        if (bMigrationNeeded && bMigrationWanted.equals((Object)MigrationCallbackHandler.MigrationChoice.MIGRATION)) {
            logger.info((Object)"Beginning database migration");
            Map<Version, Configuration> mVersionAndConfigurationMap = this.loadIntermediateConfigurations(vdbVersion);
            mVersionAndConfigurationMap.put(vdbVersion, vdbConfiguration);
            TreeMap<Version, ConfigurationAdapter> smVersionAndConfigurationAdapterMap = new TreeMap<Version, ConfigurationAdapter>();
            logger.debug((Object)"Set old database for old mappings");
            for (Map.Entry<Version, Configuration> entry : mVersionAndConfigurationMap.entrySet()) {
                Version vVersion = entry.getKey();
                Configuration cConfiguration = entry.getValue();
                if (!vdbVersion.equals((Object)vVersion)) {
                    cConfiguration.setProperties(this.currentApplicationConfiguration.getProperties());
                    cConfiguration = dbManager.setRenamedTableSchema(cConfiguration, vVersion);
                    logger.debug((Object)("Creating schema for version : " + vVersion.getVersion()));
                    dbManager.setApplicationSchemaInDatabase(cConfiguration);
                }
                ConfigurationAdapter cfgAdpater = new ConfigurationAdapter(cConfiguration, vVersion);
                smVersionAndConfigurationAdapterMap.put(vVersion, cfgAdpater);
            }
            this.currentApplicationConfiguration = dbManager.setRenamedTableSchema(this.currentApplicationConfiguration, this.currentApplicationVersion);
            logger.debug((Object)"Creating current application schema");
            dbManager.setApplicationSchemaInDatabase(this.currentApplicationConfiguration);
            ConfigurationAdapter appCfgAdpater = new ConfigurationAdapter(this.currentApplicationConfiguration, this.currentApplicationVersion);
            smVersionAndConfigurationAdapterMap.put(this.currentApplicationVersion, appCfgAdpater);
            logger.info((Object)"Data migration");
            Transformer trans = new Transformer(smVersionAndConfigurationAdapterMap);
            trans.execute();
            logger.info((Object)"Data migrated");
            logger.debug((Object)"Deleting old database");
            for (Configuration cfg : mVersionAndConfigurationMap.values()) {
                dbManager.removeTablesFromOldMapping(cfg);
            }
            dbManager.renameTables(this.currentApplicationConfiguration, this.currentApplicationVersion);
            logger.info((Object)"All done, migration complete");
            dbManager.disconnect();
        } else {
            dbManager.disconnect();
        }
        if (bMigrationNeeded && (bMigrationWanted.equals((Object)MigrationCallbackHandler.MigrationChoice.MIGRATION) || bMigrationWanted.equals((Object)MigrationCallbackHandler.MigrationChoice.CUSTOM_MIGRATION))) {
            logger.info((Object)("Set application version in database to " + this.currentApplicationVersion));
            this.putVersionInDatabase(this.currentApplicationConfiguration.getProperties(), this.currentApplicationVersion, vdbVersion.equals((Object)Version.VZERO));
        }
        return !bMigrationNeeded || bMigrationNeeded && (bMigrationWanted.equals((Object)MigrationCallbackHandler.MigrationChoice.MIGRATION) || bMigrationWanted.equals((Object)MigrationCallbackHandler.MigrationChoice.CUSTOM_MIGRATION));
    }

    protected void putVersionInDatabase(Properties properties, Version version, boolean createTable) {
        DatabaseManager dbManager = new DatabaseManager(properties);
        if (createTable) {
            dbManager.createVersionTable();
        }
        dbManager.putVersionInDatabase(version);
        dbManager.disconnect();
    }

    protected MigrationCallbackHandler.MigrationChoice askHandlerForMigration(DatabaseManager dbManager, String databaseVersion, String applicationVersion) {
        MigrationCallbackHandler.MigrationChoice result = MigrationCallbackHandler.MigrationChoice.MIGRATION;
        for (MigrationCallbackHandler callback : this.migrationCallBackHandlers) {
            MigrationCallbackHandler.MigrationChoice thiscallbackResult = callback.doMigration(dbManager, databaseVersion, applicationVersion);
            if (thiscallbackResult == MigrationCallbackHandler.MigrationChoice.NO_MIGRATION) {
                if (result.equals((Object)MigrationCallbackHandler.MigrationChoice.CUSTOM_MIGRATION)) continue;
                result = MigrationCallbackHandler.MigrationChoice.NO_MIGRATION;
                continue;
            }
            if (thiscallbackResult == MigrationCallbackHandler.MigrationChoice.CUSTOM_MIGRATION) {
                result = MigrationCallbackHandler.MigrationChoice.CUSTOM_MIGRATION;
                continue;
            }
            if (thiscallbackResult != MigrationCallbackHandler.MigrationChoice.MIGRATION || result.equals((Object)MigrationCallbackHandler.MigrationChoice.CUSTOM_MIGRATION)) continue;
            result = MigrationCallbackHandler.MigrationChoice.MIGRATION;
        }
        return result;
    }

    protected Map<Version, Configuration> loadIntermediateConfigurations(Version vdbVersion) {
        Pattern pattern = Pattern.compile(this.mappingsDirectory + File.separator + "([0-9]+(\\.[0-9]+)*)");
        HashMap<Version, Configuration> mVersionAndConfigurationMap = null;
        List urls = null;
        urls = Resource.getURLs((String)(".*" + this.mappingsDirectory + "/.*"), (URLClassLoader)((URLClassLoader)MigrationServiceImpl.class.getClassLoader()));
        if (urls != null && urls.size() > 0) {
            mVersionAndConfigurationMap = new HashMap<Version, Configuration>();
            TreeSet<Version> tsEnsembleVersionACharger = new TreeSet<Version>();
            for (URL url : urls) {
                Matcher matcher = pattern.matcher(url.getFile());
                if (!matcher.find()) continue;
                String sVersion = matcher.group(1);
                tsEnsembleVersionACharger.add(new Version(sVersion));
            }
            for (Version v : tsEnsembleVersionACharger) {
                if (v.compareTo(vdbVersion) <= 0) {
                    logger.debug((Object)("No load needed for version " + v.getVersion()));
                    continue;
                }
                logger.debug((Object)("Loading mapping for version " + v.getVersion()));
                Configuration cfgForVersion = this.getSingleConfiguration(v);
                mVersionAndConfigurationMap.put(v, cfgForVersion);
            }
        } else {
            logger.error((Object)("No mapping found in classpath '" + this.mappingsDirectory + "'; can't load old mappings"));
        }
        return mVersionAndConfigurationMap;
    }

    protected Configuration getSingleConfiguration(Version version) {
        String mappingVersionDir = this.mappingsDirectory + "/" + version.getVersion();
        ConfigurationHelper cfgHelper = ConfigurationHelper.getInstance();
        Configuration cfgForVersion = cfgHelper.getConfigurationInDirectory(mappingVersionDir);
        return cfgForVersion;
    }
}

