/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.jdbc.Work;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.util.StringUtil;
import org.nuiton.util.Version;

public abstract class ManualMigrationCallback {
    private static Log log = LogFactory.getLog(ManualMigrationCallback.class);

    public abstract boolean askUser(Version var1, Version var2, List<Version> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MigrationChoice doMigration(TopiaContext ctxt, Version dbVersion, Version applicationVersion, boolean showSql, boolean showProgression, List<Version> versions) {
        MigrationChoice result = MigrationChoice.NO_MIGRATION;
        boolean doMigrate = this.askUser(dbVersion, applicationVersion, versions);
        if (doMigrate) {
            for (Version v : versions) {
                try {
                    TopiaContextImplementor tx = (TopiaContextImplementor)ctxt.beginTransaction();
                    try {
                        Method m;
                        String methodName = "migrateTo_" + v.getValidName();
                        try {
                            m = this.getClass().getMethod(methodName, TopiaContextImplementor.class, Boolean.TYPE, Boolean.TYPE);
                            m.setAccessible(true);
                            log.info((Object)I18n._((String)"topia.migration.start.migrate", (Object[])new Object[]{v}));
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("launch method " + methodName));
                            }
                            m.invoke((Object)this, tx, showSql, showProgression);
                        }
                        catch (NoSuchMethodException e) {
                            m = this.getClass().getMethod(methodName, TopiaContextImplementor.class);
                            m.setAccessible(true);
                            log.info((Object)I18n._((String)"topia.migration.start.migrate", (Object[])new Object[]{v}));
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("launch method " + methodName));
                            }
                            m.invoke((Object)this, tx);
                        }
                        tx.commitTransaction();
                        result = MigrationChoice.CUSTOM_MIGRATION;
                    }
                    catch (Exception eee) {
                        log.error((Object)"Migration impossible de la base", (Throwable)eee);
                        tx.rollbackTransaction();
                    }
                    finally {
                        if (tx == null) continue;
                        tx.closeContext();
                    }
                }
                catch (Exception eee) {
                    log.error((Object)"Error lors de la tentative de migration", (Throwable)eee);
                }
            }
        }
        return result;
    }

    public void executeSQL(TopiaContextImplementor tx, String ... sqls) throws TopiaException {
        this.executeSQL(tx, false, false, sqls);
    }

    public void executeSQL(TopiaContextImplementor tx, final boolean showSql, final boolean showProgression, final String ... sqls) throws TopiaException {
        if (log.isInfoEnabled()) {
            log.info((Object)I18n._((String)"topia.migration.start.sqls", (Object[])new Object[]{sqls.length}));
        }
        if (showSql) {
            StringBuilder buffer = new StringBuilder();
            for (String s : sqls) {
                buffer.append(s).append("\n");
            }
            log.info((Object)("SQL TO EXECUTE :\n--------------------------------------------------------------------------------\n--------------------------------------------------------------------------------\n" + buffer.toString() + "--------------------------------------------------------------------------------\n" + "--------------------------------------------------------------------------------\n"));
        }
        tx.getHibernate().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                int index = 0;
                int max = sqls.length;
                for (String sql : sqls) {
                    long t0 = System.nanoTime();
                    if (log.isInfoEnabled()) {
                        String message = "";
                        if (showProgression) {
                            message = I18n._((String)"topia.migration.start.sql", (Object[])new Object[]{++index, max});
                        }
                        if (showSql) {
                            message = message + "\n" + sql;
                        }
                        if (showProgression || showSql) {
                            log.info((Object)message);
                        }
                    }
                    PreparedStatement sta = connection.prepareStatement(sql);
                    sta.executeUpdate();
                    sta.close();
                    if (!log.isDebugEnabled()) continue;
                    String message = I18n._((String)"topia.migration.end.sql", (Object[])new Object[]{++index, max, StringUtil.convertTime((long)(System.nanoTime() - t0))});
                    log.debug((Object)message);
                }
            }
        });
    }

    public static enum MigrationChoice {
        NO_MIGRATION,
        MIGRATION,
        CUSTOM_MIGRATION;

    }
}

