/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.index;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.util.Version;
import org.hibernate.HibernateException;
import org.hibernate.metadata.ClassMetadata;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.index.IndexEntry;
import org.nuiton.topia.index.TopiaIndexImplementor;
import org.nuiton.topia.persistence.TopiaId;

public class LuceneIndexer
implements TopiaIndexImplementor {
    private static Log log = LogFactory.getLog(LuceneIndexer.class);
    private static final String TOPIA_ID = "topiaId";
    protected File directory = null;
    protected TopiaContextImplementor context;
    protected Map<Object, Object[]> indexationMap = new HashMap<Object, Object[]>();

    public String getServiceName() {
        return "index";
    }

    public Class<?>[] getPersistenceClasses() {
        return null;
    }

    @Override
    public void recordForIndexation(Object id, Object[] fields) {
        if (id == null) {
            log.warn((Object)"Id must not be null, this object will be not indexed");
        } else {
            this.indexationMap.put(id, fields);
        }
    }

    public boolean preInit(TopiaContextImplementor context) {
        return true;
    }

    public boolean postInit(TopiaContextImplementor context) {
        this.context = context;
        Properties prop = context.getConfig();
        String dirname = prop.getProperty("topia.index.lucene.directory");
        this.directory = new File(dirname);
        this.directory.mkdirs();
        return true;
    }

    @Override
    public void clearLastRecordedIndexation() {
        this.indexationMap.clear();
    }

    @Override
    public void doIndexation() {
        block9: {
            try {
                String id;
                NIOFSDirectory indexDirectory = new NIOFSDirectory(this.directory);
                SimpleAnalyzer analyzer = new SimpleAnalyzer();
                boolean create = false;
                if (!IndexReader.indexExists((Directory)indexDirectory)) {
                    create = true;
                } else {
                    IndexReader reader = IndexReader.open((Directory)indexDirectory);
                    for (Map.Entry<Object, Object[]> e : this.indexationMap.entrySet()) {
                        id = e.getKey().toString();
                        this.removeIndex(reader, id);
                    }
                    reader.close();
                }
                IndexWriter writer = new IndexWriter((Directory)indexDirectory, (Analyzer)analyzer, create, IndexWriter.MaxFieldLength.LIMITED);
                for (Map.Entry<Object, Object[]> e : this.indexationMap.entrySet()) {
                    id = e.getKey().toString();
                    Object[] fields = e.getValue();
                    if (fields == null) continue;
                    try {
                        this.index(writer, id, fields);
                    }
                    catch (HibernateException eee) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)("Can't index: " + id));
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"StackTrace", (Throwable)eee);
                    }
                    catch (TopiaNotFoundException eee) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)("Can't index: " + id));
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"StackTrace", (Throwable)eee);
                    }
                }
                writer.close();
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block9;
                log.warn((Object)"Can't index");
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)"StackTrace", (Throwable)eee);
            }
        }
    }

    private void index(IndexWriter writer, String id, Object[] fields) throws IOException, HibernateException, TopiaNotFoundException {
        String classname = TopiaId.getClassNameAsString((String)id);
        ClassMetadata cm = this.context.getHibernateFactory().getClassMetadata(classname + "Impl");
        String[] names = cm.getPropertyNames();
        Document doc = new Document();
        doc.add((Fieldable)new Field("class", classname, Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field(TOPIA_ID, id, Field.Store.YES, Field.Index.ANALYZED));
        StringBuffer all = new StringBuffer();
        for (int i = 0; i < fields.length; ++i) {
            String name = names[i];
            Object o = fields[i];
            if (o == null) continue;
            String val = String.valueOf(o);
            doc.add((Fieldable)new Field(name, val, Field.Store.YES, Field.Index.ANALYZED));
            all.append(val);
            all.append(" ");
        }
        if (all.length() > 0) {
            doc.add((Fieldable)new Field("__all__", all.toString(), Field.Store.NO, Field.Index.ANALYZED));
        }
        writer.addDocument(doc);
    }

    private void removeIndex(IndexReader reader, String id) throws IOException {
        Term term = new Term(TOPIA_ID, id);
        reader.deleteDocuments(term);
    }

    @Override
    public SortedSet<IndexEntry> search(String queryText) {
        IndexSearcher searcher;
        TopDocs topDocs;
        block14: {
            topDocs = null;
            searcher = null;
            try {
                NIOFSDirectory indexDirectory = new NIOFSDirectory(this.directory);
                SimpleAnalyzer analyzer = new SimpleAnalyzer();
                if (IndexReader.indexExists((Directory)indexDirectory)) {
                    searcher = new IndexSearcher((Directory)indexDirectory);
                    if (queryText.equals("") || queryText.length() == 0) {
                        log.debug((Object)"requete vide, pas de resultat a renvoyer.");
                    } else {
                        QueryParser parser = new QueryParser(Version.LUCENE_30, "__all__", (Analyzer)analyzer);
                        Query luceneQuery = parser.parse(queryText);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Recherche du terme : " + luceneQuery.toString()));
                        }
                        topDocs = searcher.search(luceneQuery, null, 100);
                        searcher.close();
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Index inexistant, pas de resultats \u00e0 renvoyer !");
                }
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)ioe.getMessage(), (Throwable)ioe);
                }
            }
            catch (ParseException pe) {
                if (!log.isDebugEnabled()) break block14;
                log.debug((Object)pe.getMessage(), (Throwable)pe);
            }
        }
        TreeSet<IndexEntry> result = new TreeSet<IndexEntry>();
        if (searcher != null && topDocs != null) {
            ScoreDoc[] scoreDocs;
            for (ScoreDoc scoreDoc : scoreDocs = topDocs.scoreDocs) {
                try {
                    Document doc = searcher.doc(scoreDoc.doc);
                    String topiaId = doc.get(TOPIA_ID);
                    IndexEntry ie = new IndexEntry(scoreDoc.score, topiaId);
                    result.add(ie);
                }
                catch (IOException eee) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)"Can't get result");
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"StackTrace is", (Throwable)eee);
                }
            }
        }
        return result;
    }

    @Override
    public SortedSet<IndexEntry> search(Map query) {
        SortedSet<IndexEntry> result = null;
        String queryText = "";
        for (String key : query.keySet()) {
            String value = (String)query.get(key);
            if (value == null) continue;
            String[] st = value.split("\\s");
            for (int i = 0; i < st.length; ++i) {
                String token = st[i];
                if (token == null || token.equals("")) continue;
                queryText = queryText + key + ":" + st[i] + " ";
            }
        }
        result = this.search(queryText);
        return result;
    }
}

