/* *##% ToPIA - History service
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

/* *
 * TopiaHistoryService.java
 *
 * Created: 14 oct. 06 00:58:13
 *
 * @author poussin
 * @version $Revision: 1459 $
 *
 * Last update: $Date: 2009-05-16 09:56:47 +0200 (Sat, 16 May 2009) $
 * by : $Author: tchemit $
 */

package org.nuiton.topia.history;

import java.io.Writer;
import java.util.Date;
import java.util.List;

import org.nuiton.topia.framework.TopiaService;


/**
 * @author poussin
 */
public interface TopiaHistoryService extends TopiaService {

    public static final String SERVICE_NAME = "history";
    
    /**
     * Supprime tout l'historique jusqu'a la date passé en parametre
     * @param toDate la derniere date effacé inclue
     * @throws Exception if any pb
     */
    public void clear(Date toDate) throws Exception;
    
    /**
     * Ne garde dans l'historique que les number dernier elements
     * @param number le nombre d'element a conserver dans l'historique
     * @throws Exception if any pb
     */
    public void keep(int number) throws Exception;

    /**
     * Permet de stocker l'historique dans un writer (par exemple un fichier)
     * 
     * @param toDate l'historique est sauve jusqu'a cette date incluse
     * @param out le flux sur lequel il faut ecrire l'historique
     * @throws Exception if any pb
     */
    public void store(Date toDate, Writer out) throws Exception;
    
    /**
     * Search TopiaId targeted by action and user. Results are ordered by
     * date last is oldest 
     * 
     * @param limit maximum number of result, -1 for all
     * @param user TopiaId of user, can be null for all user
     * @param type type of target search (fqn class) can be null for all object
     * @param action action as int that we want to search, can be an sum of 
     * action wanted LOAD + UPDATE + DELETE + CREATE for all action
     * @return TopiaId of target object
     * @throws Exception if any pb
     */
    public List<String> findLastAction(int limit, String user, String type, Integer ... action) throws Exception;
    
}


