package org.nuiton.topia.persistence;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaConfigurationConstants.java 3147 2014-06-03 19:45:39Z bleny $
 * $HeadURL: https://svn.nuiton.org/topia/tags/topia-3.0-beta-6/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaConfigurationConstants.java $
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.hibernate.cfg.Environment;

/**
 * This class lists the configuration variables that ToPIA expects
 * <p/>
 * Created on 12/20/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 3.0
 */
public interface TopiaConfigurationConstants {

    String CONFIG_DEFAULT_SCHEMA = Environment.DEFAULT_SCHEMA;

    String CONFIG_USER = Environment.USER;

    String CONFIG_PASS = Environment.PASS;

    String CONFIG_DRIVER = Environment.DRIVER;

    String CONFIG_DIALECT = Environment.DIALECT;

    String CONFIG_CONNECTION_PROVIDER = Environment.CONNECTION_PROVIDER;

    String CONFIG_BYTECODE_PROVIDER = Environment.BYTECODE_PROVIDER;

    String CONFIG_CURRENT_SESSION_CONTEXT_CLASS = Environment.CURRENT_SESSION_CONTEXT_CLASS;

    String CONFIG_GENERATE_STATISTICS = Environment.GENERATE_STATISTICS;

    String CONFIG_FORMAT_SQL = Environment.FORMAT_SQL;

    String CONFIG_HBM2DDL_AUTO = Environment.HBM2DDL_AUTO;

    String CONFIG_POOL_SIZE = Environment.POOL_SIZE;

    String CONFIG_SHOW_SQL = Environment.SHOW_SQL;

    String CONFIG_URL = Environment.URL;

    @Deprecated
    String CONFIG_PERSISTENCE_DIRECTORIES = "topia.persistence.directories";

    String CONFIG_PERSISTENCE_CLASSES = "topia.persistence.classes";

    String CONFIG_PERSISTENCE_PROPERTIES_FILE = "topia.persistence.properties.file";

    /**
     * Configuration directive to change topia Ids generation strategy.
     * <p/>
     * Expected value is an FQN to a class which implements {@link org.nuiton.topia.persistence.TopiaIdFactory}
     *
     * @since 3.0
     */
    String CONFIG_PERSISTENCE_TOPIA_ID_FACTORY_CLASS_NAME =
            "topia.persistence.topiaIdFactoryClassName";

    /**
     * You can set it to false if you don't want Topia to deal with the schema (you keep it
     * up to date with your own sql file).
     *
     * @since 3.0
     */
    String CONFIG_PERSISTENCE_INIT_SCHEMA =
            "topia.persistence.initSchema";
}
