package org.nuiton.topia;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaTransaction.java 2790 2013-08-05 08:49:05Z athimel $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-3.1/topia-persistence/src/main/java/org/nuiton/topia/TopiaTransaction.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/**
 * This API provides methods to manipulate transaction
 *
 * @author Arnaud Thimel <thimel@codelutin.com>
 * @since 3.0
 */
public interface TopiaTransaction {

    /**
     * Applies all the modifications made to this context on the persistence
     * device. Once commit is done, a new transaction is started.
     */
    void commitTransaction();

    /**
     * Cancels all the modifications made to this context, coming back to the
     * state on the last beginTransaction. Once rollback is done, a new
     * transaction is started.
     */
    void rollbackTransaction();

    /**
     * Closes the context. All the children contexts will be closed in the same
     * time.
     */
    void closeContext();

    /**
     * Tells if the context is closed
     *
     * @return {@code true} if the context is closed, {@code false} otherwise
     */
    boolean isClosed();

}
