/*
 * #%L
 * ToPIA :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topia.test.entities;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class PetDTO implements Serializable {

    protected String topiaId;

    public String name;

    public String type;

    public PersonDTO person;

    public RaceDTO race;

    protected final PropertyChangeSupport p = new PropertyChangeSupport(this);

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }

    public void setName(String value) {
        java.lang.String oldValue = this.name;
        this.name = value;
        p.firePropertyChange("name", oldValue, value);
    }

    public String getName() {
        return name;
    }

    public void setType(String value) {
        java.lang.String oldValue = this.type;
        this.type = value;
        p.firePropertyChange("type", oldValue, value);
    }

    public String getType() {
        return type;
    }

    public void setPerson(PersonDTO value) {
        org.nuiton.topia.test.entities.PersonDTO oldValue = this.person;
        this.person = value;
        p.firePropertyChange("person", oldValue, value);
    }

    public PersonDTO getPerson() {
        return person;
    }

    public void setRace(RaceDTO value) {
        org.nuiton.topia.test.entities.RaceDTO oldValue = this.race;
        this.race = value;
        p.firePropertyChange("race", oldValue, value);
    }

    public RaceDTO getRace() {
        return race;
    }

    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("type", this.type).
            append("race", this.race).
         toString();
        return result;
}

} //PetDTO
