/*
 * #%L
 * ToPIA :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topia;

import java.util.HashMap;
import java.util.Map;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.test.ano1882.FrenchCompany;
import org.nuiton.topia.test.ano1882.SIREN;
import org.nuiton.topia.test.ano1882.SIRET;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.Pet;
import org.nuiton.topia.test.entities.Race;
import org.nuiton.topiatest.Address;
import org.nuiton.topiatest.Bill;
import org.nuiton.topiatest.Company;
import org.nuiton.topiatest.Department;
import org.nuiton.topiatest.Employe;
import org.nuiton.topiatest.ExtraDAOEntity;
import org.nuiton.topiatest.GeneralizedNaturalizedEntity;
import org.nuiton.topiatest.NaturalizedEntity;
import org.nuiton.topiatest.Personne;
import org.nuiton.topiatest.Product;
import org.nuiton.topiatest.QueriedEntity;
import org.nuiton.topiatest.Store;
import org.nuiton.topiatest.Type;
import org.nuiton.topiatest.deletetest.Contact2;
import org.nuiton.topiatest.deletetest.Party2;
import org.nuiton.topiatest.deletetest.Telephone2;

public class TopiaTestQueryHelper {
    public static abstract class EntityProperty<E> {

            protected String alias;

            protected Map<String, String> propertiesCache;

            public EntityProperty()         {
            propertiesCache = new HashMap<String, String>();
            }

            protected void setAlias(String alias)         {
            this.alias = alias;
            }

            public String $alias()         {
            return alias;
            }

            public String $property(String propertyName)         {
            String result = propertiesCache.get(propertyName);
            if (result == null) {
                result = TopiaQuery.getProperty(alias, propertyName);
                propertiesCache.put(propertyName, result);
            }
            return result;
            }

            public String topiaCreateDate()         {
            return $property(TopiaEntity.TOPIA_CREATE_DATE);
            }

            public String topiaId()         {
            return $property(TopiaEntity.TOPIA_ID);
            }

            public String topiaVersion()         {
            return $property(TopiaEntity.TOPIA_VERSION);
            }

            public abstract Class<E> getEntityClass();

            public abstract String defaultAlias();

        } //EntityProperty<E>
        public static class FrenchCompanyProperty extends EntityProperty<FrenchCompany> {

                protected FrenchCompanyProperty()             {
                }

                @Override
                public Class<FrenchCompany> getEntityClass()             {
            return FrenchCompany.class;
                }

                @Override
                public String defaultAlias()             {
            return ALIAS_FRENCH_COMPANY;
                }

                public String sIREN()             {
            return $property(FrenchCompany.PROPERTY_S_IREN);
                }

                public SIRENProperty sIRENProperty()             {
            return newSIRENProperty(sIREN());
                }

                public String sIRET()             {
            return $property(FrenchCompany.PROPERTY_S_IRET);
                }

                public String SIREN2()             {
            return $property(FrenchCompany.PROPERTY_SIREN2);
                }

                public SIRENProperty SIREN2Property()             {
            return newSIRENProperty(SIREN2());
                }

                public String SIRET2()             {
            return $property(FrenchCompany.PROPERTY_SIRET2);
                }

            } //FrenchCompanyProperty
            public static class CompanyProperty extends EntityProperty<Company> {

                    protected CompanyProperty()                 {
                    }

                    @Override
                    public Class<Company> getEntityClass()                 {
            return Company.class;
                    }

                    @Override
                    public String defaultAlias()                 {
            return ALIAS_COMPANY;
                    }

                    public String name()                 {
            return $property(Company.PROPERTY_NAME);
                    }

                    public String siret()                 {
            return $property(Company.PROPERTY_SIRET);
                    }

                    public String employe()                 {
            return $property(Company.PROPERTY_EMPLOYE);
                    }

                    public String storeBill()                 {
            return $property(Company.PROPERTY_STORE_BILL);
                    }

                    public BillProperty storeBillProperty()                 {
            return newBillProperty(storeBill());
                    }

                    public String department()                 {
            return $property(Company.PROPERTY_DEPARTMENT);
                    }

                } //CompanyProperty
                public static class TypeProperty extends EntityProperty<Type> {

                        protected TypeProperty()                     {
                        }

                        @Override
                        public Class<Type> getEntityClass()                     {
            return Type.class;
                        }

                        @Override
                        public String defaultAlias()                     {
            return ALIAS_TYPE;
                        }

                        public String name()                     {
            return $property(Type.PROPERTY_NAME);
                        }

                    } //TypeProperty
                    public static class Telephone2Property extends EntityProperty<Telephone2> {

                            protected Telephone2Property()                         {
                            }

                            @Override
                            public Class<Telephone2> getEntityClass()                         {
            return Telephone2.class;
                            }

                            @Override
                            public String defaultAlias()                         {
            return ALIAS_TELEPHONE2;
                            }

                            public String prefix()                         {
            return $property(Telephone2.PROPERTY_PREFIX);
                            }

                            public String country()                         {
            return $property(Telephone2.PROPERTY_COUNTRY);
                            }

                        } //Telephone2Property
                        public static class PersonneProperty extends EntityProperty<Personne> {

                                protected PersonneProperty()                             {
                                }

                                @Override
                                public Class<Personne> getEntityClass()                             {
            return Personne.class;
                                }

                                @Override
                                public String defaultAlias()                             {
            return ALIAS_PERSONNE;
                                }

                                public String name()                             {
            return $property(Personne.PROPERTY_NAME);
                                }

                                public String otherNames()                             {
            return $property(Personne.PROPERTY_OTHER_NAMES);
                                }

                                public String gender()                             {
            return $property(Personne.PROPERTY_GENDER);
                                }

                                public String otherGender()                             {
            return $property(Personne.PROPERTY_OTHER_GENDER);
                                }

                                public String address()                             {
            return $property(Personne.PROPERTY_ADDRESS);
                                }

                                public AddressProperty addressProperty()                             {
            return newAddressProperty(address());
                                }

                                public String title()                             {
            return $property(Personne.PROPERTY_TITLE);
                                }

                            } //PersonneProperty
                            public static class BillProperty extends EntityProperty<Bill> {

                                    protected BillProperty()                                 {
                                    }

                                    @Override
                                    public Class<Bill> getEntityClass()                                 {
            return Bill.class;
                                    }

                                    @Override
                                    public String defaultAlias()                                 {
            return ALIAS_BILL;
                                    }

                                    public String cost()                                 {
            return $property(Bill.PROPERTY_COST);
                                    }

                                    public String date()                                 {
            return $property(Bill.PROPERTY_DATE);
                                    }

                                    public String paid()                                 {
            return $property(Bill.PROPERTY_PAID);
                                    }

                                    public String store()                                 {
            return $property(Bill.PROPERTY_STORE);
                                    }

                                    public BillProperty storeBillProperty()                                 {
            return newBillProperty(store());
                                    }

                                    public String company()                                 {
            return $property(Bill.PROPERTY_COMPANY);
                                    }

                                    public BillProperty companyBillProperty()                                 {
            return newBillProperty(company());
                                    }

                                } //BillProperty
                                public static class EmployeProperty extends EntityProperty<Employe> {

                                        protected EmployeProperty()                                     {
                                        }

                                        @Override
                                        public Class<Employe> getEntityClass()                                     {
            return Employe.class;
                                        }

                                        @Override
                                        public String defaultAlias()                                     {
            return ALIAS_EMPLOYE;
                                        }

                                        public String salary()                                     {
            return $property(Employe.PROPERTY_SALARY);
                                        }

                                    } //EmployeProperty
                                    public static class NaturalizedEntityProperty extends EntityProperty<NaturalizedEntity> {

                                            protected NaturalizedEntityProperty()                                         {
                                            }

                                            @Override
                                            public Class<NaturalizedEntity> getEntityClass()                                         {
            return NaturalizedEntity.class;
                                            }

                                            @Override
                                            public String defaultAlias()                                         {
            return ALIAS_NATURALIZED_ENTITY;
                                            }

                                            public String naturalIdNotNull()                                         {
            return $property(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL);
                                            }

                                            public String naturalIdNull()                                         {
            return $property(NaturalizedEntity.PROPERTY_NATURAL_ID_NULL);
                                            }

                                        } //NaturalizedEntityProperty
                                        public static class PetProperty extends EntityProperty<Pet> {

                                                protected PetProperty()                                             {
                                                }

                                                @Override
                                                public Class<Pet> getEntityClass()                                             {
            return Pet.class;
                                                }

                                                @Override
                                                public String defaultAlias()                                             {
            return ALIAS_PET;
                                                }

                                                public String name()                                             {
            return $property(Pet.PROPERTY_NAME);
                                                }

                                                public String type()                                             {
            return $property(Pet.PROPERTY_TYPE);
                                                }

                                                public String person()                                             {
            return $property(Pet.PROPERTY_PERSON);
                                                }

                                                public PersonProperty personProperty()                                             {
            return newPersonProperty(person());
                                                }

                                                public String race()                                             {
            return $property(Pet.PROPERTY_RACE);
                                                }

                                                public RaceProperty raceProperty()                                             {
            return newRaceProperty(race());
                                                }

                                            } //PetProperty
                                            public static class Contact2Property extends EntityProperty<Contact2> {

                                                    protected Contact2Property()                                                 {
                                                    }

                                                    @Override
                                                    public Class<Contact2> getEntityClass()                                                 {
            return Contact2.class;
                                                    }

                                                    @Override
                                                    public String defaultAlias()                                                 {
            return ALIAS_CONTACT2;
                                                    }

                                                    public String contactValue()                                                 {
            return $property(Contact2.PROPERTY_CONTACT_VALUE);
                                                    }

                                                    public String type()                                                 {
            return $property(Contact2.PROPERTY_TYPE);
                                                    }

                                                    public String party2()                                                 {
            return $property(Contact2.PROPERTY_PARTY2);
                                                    }

                                                } //Contact2Property
                                                public static class RaceProperty extends EntityProperty<Race> {

                                                        protected RaceProperty()                                                     {
                                                        }

                                                        @Override
                                                        public Class<Race> getEntityClass()                                                     {
            return Race.class;
                                                        }

                                                        @Override
                                                        public String defaultAlias()                                                     {
            return ALIAS_RACE;
                                                        }

                                                        public String name()                                                     {
            return $property(Race.PROPERTY_NAME);
                                                        }

                                                    } //RaceProperty
                                                    public static class DepartmentProperty extends EntityProperty<Department> {

                                                            protected DepartmentProperty()                                                         {
                                                            }

                                                            @Override
                                                            public Class<Department> getEntityClass()                                                         {
            return Department.class;
                                                            }

                                                            @Override
                                                            public String defaultAlias()                                                         {
            return ALIAS_DEPARTMENT;
                                                            }

                                                            public String name()                                                         {
            return $property(Department.PROPERTY_NAME);
                                                            }

                                                            public String leader()                                                         {
            return $property(Department.PROPERTY_LEADER);
                                                            }

                                                            public EmployeProperty leaderProperty()                                                         {
            return newEmployeProperty(leader());
                                                            }

                                                            public String company()                                                         {
            return $property(Department.PROPERTY_COMPANY);
                                                            }

                                                            public CompanyProperty companyProperty()                                                         {
            return newCompanyProperty(company());
                                                            }

                                                            public String product()                                                         {
            return $property(Department.PROPERTY_PRODUCT);
                                                            }

                                                        } //DepartmentProperty
                                                        public static class ProductProperty extends EntityProperty<Product> {

                                                                protected ProductProperty()                                                             {
                                                                }

                                                                @Override
                                                                public Class<Product> getEntityClass()                                                             {
            return Product.class;
                                                                }

                                                                @Override
                                                                public String defaultAlias()                                                             {
            return ALIAS_PRODUCT;
                                                                }

                                                                public String name()                                                             {
            return $property(Product.PROPERTY_NAME);
                                                                }

                                                                public String type()                                                             {
            return $property(Product.PROPERTY_TYPE);
                                                                }

                                                                public TypeProperty typeProperty()                                                             {
            return newTypeProperty(type());
                                                                }

                                                            } //ProductProperty
                                                            public static class QueriedEntityProperty extends EntityProperty<QueriedEntity> {

                                                                    protected QueriedEntityProperty()                                                                 {
                                                                    }

                                                                    @Override
                                                                    public Class<QueriedEntity> getEntityClass()                                                                 {
            return QueriedEntity.class;
                                                                    }

                                                                    @Override
                                                                    public String defaultAlias()                                                                 {
            return ALIAS_QUERIED_ENTITY;
                                                                    }

                                                                    public String testAdd()                                                                 {
            return $property(QueriedEntity.PROPERTY_TEST_ADD);
                                                                    }

                                                                } //QueriedEntityProperty
                                                                public static class Party2Property extends EntityProperty<Party2> {

                                                                        protected Party2Property()                                                                     {
                                                                        }

                                                                        @Override
                                                                        public Class<Party2> getEntityClass()                                                                     {
            return Party2.class;
                                                                        }

                                                                        @Override
                                                                        public String defaultAlias()                                                                     {
            return ALIAS_PARTY2;
                                                                        }

                                                                        public String contacts()                                                                     {
            return $property(Party2.PROPERTY_CONTACTS);
                                                                        }

                                                                    } //Party2Property
                                                                    public static class AddressProperty extends EntityProperty<Address> {

                                                                            protected AddressProperty()                                                                         {
                                                                            }

                                                                            @Override
                                                                            public Class<Address> getEntityClass()                                                                         {
            return Address.class;
                                                                            }

                                                                            @Override
                                                                            public String defaultAlias()                                                                         {
            return ALIAS_ADDRESS;
                                                                            }

                                                                            public String city()                                                                         {
            return $property(Address.PROPERTY_CITY);
                                                                            }

                                                                            public String adress()                                                                         {
            return $property(Address.PROPERTY_ADRESS);
                                                                            }

                                                                        } //AddressProperty
                                                                        public static class SIRETProperty extends EntityProperty<SIRET> {

                                                                                protected SIRETProperty()                                                                             {
                                                                                }

                                                                                @Override
                                                                                public Class<SIRET> getEntityClass()                                                                             {
            return SIRET.class;
                                                                                }

                                                                                @Override
                                                                                public String defaultAlias()                                                                             {
            return ALIAS_SIRET;
                                                                                }

                                                                            } //SIRETProperty
                                                                            public static class SIRENProperty extends EntityProperty<SIREN> {

                                                                                    protected SIRENProperty()                                                                                 {
                                                                                    }

                                                                                    @Override
                                                                                    public Class<SIREN> getEntityClass()                                                                                 {
            return SIREN.class;
                                                                                    }

                                                                                    @Override
                                                                                    public String defaultAlias()                                                                                 {
            return ALIAS_SIREN;
                                                                                    }

                                                                                } //SIRENProperty
                                                                                public static class PersonProperty extends EntityProperty<Person> {

                                                                                        protected PersonProperty()                                                                                     {
                                                                                        }

                                                                                        @Override
                                                                                        public Class<Person> getEntityClass()                                                                                     {
            return Person.class;
                                                                                        }

                                                                                        @Override
                                                                                        public String defaultAlias()                                                                                     {
            return ALIAS_PERSON;
                                                                                        }

                                                                                        public String name()                                                                                     {
            return $property(Person.PROPERTY_NAME);
                                                                                        }

                                                                                        public String firstname()                                                                                     {
            return $property(Person.PROPERTY_FIRSTNAME);
                                                                                        }

                                                                                        public String pet()                                                                                     {
            return $property(Person.PROPERTY_PET);
                                                                                        }

                                                                                    } //PersonProperty
                                                                                    public static class ExtraDAOEntityProperty extends EntityProperty<ExtraDAOEntity> {

                                                                                            protected ExtraDAOEntityProperty()                                                                                         {
                                                                                            }

                                                                                            @Override
                                                                                            public Class<ExtraDAOEntity> getEntityClass()                                                                                         {
            return ExtraDAOEntity.class;
                                                                                            }

                                                                                            @Override
                                                                                            public String defaultAlias()                                                                                         {
            return ALIAS_EXTRA_DAOENTITY;
                                                                                            }

                                                                                            public String attr1()                                                                                         {
            return $property(ExtraDAOEntity.PROPERTY_ATTR1);
                                                                                            }

                                                                                        } //ExtraDAOEntityProperty
                                                                                        public static class GeneralizedNaturalizedEntityProperty extends EntityProperty<GeneralizedNaturalizedEntity> {

                                                                                                protected GeneralizedNaturalizedEntityProperty()                                                                                             {
                                                                                                }

                                                                                                @Override
                                                                                                public Class<GeneralizedNaturalizedEntity> getEntityClass()                                                                                             {
            return GeneralizedNaturalizedEntity.class;
                                                                                                }

                                                                                                @Override
                                                                                                public String defaultAlias()                                                                                             {
            return ALIAS_GENERALIZED_NATURALIZED_ENTITY;
                                                                                                }

                                                                                            } //GeneralizedNaturalizedEntityProperty
                                                                                            public static class StoreProperty extends EntityProperty<Store> {

                                                                                                    protected StoreProperty()                                                                                                 {
                                                                                                    }

                                                                                                    @Override
                                                                                                    public Class<Store> getEntityClass()                                                                                                 {
            return Store.class;
                                                                                                    }

                                                                                                    @Override
                                                                                                    public String defaultAlias()                                                                                                 {
            return ALIAS_STORE;
                                                                                                    }

                                                                                                    public String name()                                                                                                 {
            return $property(Store.PROPERTY_NAME);
                                                                                                    }

                                                                                                } //StoreProperty

    public static final String ALIAS_FRENCH_COMPANY = "FC";

    public static final String ALIAS_COMPANY = "C";

    public static final String ALIAS_TYPE = "T";

    public static final String ALIAS_TELEPHONE2 = "TE";

    public static final String ALIAS_PERSONNE = "P";

    public static final String ALIAS_BILL = "B";

    public static final String ALIAS_EMPLOYE = "E";

    public static final String ALIAS_NATURALIZED_ENTITY = "NE";

    public static final String ALIAS_PET = "PE";

    public static final String ALIAS_CONTACT2 = "CO";

    public static final String ALIAS_RACE = "R";

    public static final String ALIAS_DEPARTMENT = "D";

    public static final String ALIAS_PRODUCT = "PR";

    public static final String ALIAS_QUERIED_ENTITY = "QE";

    public static final String ALIAS_PARTY2 = "PA";

    public static final String ALIAS_ADDRESS = "A";

    public static final String ALIAS_SIRET = "S";

    public static final String ALIAS_SIREN = "SI";

    public static final String ALIAS_PERSON = "PER";

    public static final String ALIAS_EXTRA_DAOENTITY = "ED";

    public static final String ALIAS_GENERALIZED_NATURALIZED_ENTITY = "GNE";

    public static final String ALIAS_STORE = "ST";

    public static TopiaQuery createQuery(EntityProperty property) {
        return new TopiaQuery((Class<? extends TopiaEntity>)property.getEntityClass(), property.$alias());
    }

    public static String format(String statement, String... propertyNames) {
        for (int i = 1; i <= propertyNames.length; i++) {
           statement = statement.replace("$" + i, propertyNames[i-1]);
        }
        return statement;
    }

    private static <P extends EntityProperty> P newEntityProperty(Class<P> propertyClass) {
        return newEntityProperty(propertyClass, null);
    }

    private static <P extends EntityProperty> P newEntityProperty(Class<P> propertyClass, String alias) {
        try {
            P property = propertyClass.newInstance();
            if (alias == null) {
                alias = property.defaultAlias();
            }
            property.setAlias(alias);
            return property;
        } catch (Exception eee) {
    
            throw new Error("Error instantiate " + propertyClass.getName(), eee);
    
        }
    }

    public static FrenchCompanyProperty newFrenchCompanyProperty() {
        return newFrenchCompanyProperty(null);
    }

    public static FrenchCompanyProperty newFrenchCompanyProperty(String alias) {
        return newEntityProperty(FrenchCompanyProperty.class, alias);
    }

    public static CompanyProperty newCompanyProperty() {
        return newCompanyProperty(null);
    }

    public static CompanyProperty newCompanyProperty(String alias) {
        return newEntityProperty(CompanyProperty.class, alias);
    }

    public static TypeProperty newTypeProperty() {
        return newTypeProperty(null);
    }

    public static TypeProperty newTypeProperty(String alias) {
        return newEntityProperty(TypeProperty.class, alias);
    }

    public static Telephone2Property newTelephone2Property() {
        return newTelephone2Property(null);
    }

    public static Telephone2Property newTelephone2Property(String alias) {
        return newEntityProperty(Telephone2Property.class, alias);
    }

    public static PersonneProperty newPersonneProperty() {
        return newPersonneProperty(null);
    }

    public static PersonneProperty newPersonneProperty(String alias) {
        return newEntityProperty(PersonneProperty.class, alias);
    }

    public static BillProperty newBillProperty() {
        return newBillProperty(null);
    }

    public static BillProperty newBillProperty(String alias) {
        return newEntityProperty(BillProperty.class, alias);
    }

    public static EmployeProperty newEmployeProperty() {
        return newEmployeProperty(null);
    }

    public static EmployeProperty newEmployeProperty(String alias) {
        return newEntityProperty(EmployeProperty.class, alias);
    }

    public static NaturalizedEntityProperty newNaturalizedEntityProperty() {
        return newNaturalizedEntityProperty(null);
    }

    public static NaturalizedEntityProperty newNaturalizedEntityProperty(String alias) {
        return newEntityProperty(NaturalizedEntityProperty.class, alias);
    }

    public static PetProperty newPetProperty() {
        return newPetProperty(null);
    }

    public static PetProperty newPetProperty(String alias) {
        return newEntityProperty(PetProperty.class, alias);
    }

    public static Contact2Property newContact2Property() {
        return newContact2Property(null);
    }

    public static Contact2Property newContact2Property(String alias) {
        return newEntityProperty(Contact2Property.class, alias);
    }

    public static RaceProperty newRaceProperty() {
        return newRaceProperty(null);
    }

    public static RaceProperty newRaceProperty(String alias) {
        return newEntityProperty(RaceProperty.class, alias);
    }

    public static DepartmentProperty newDepartmentProperty() {
        return newDepartmentProperty(null);
    }

    public static DepartmentProperty newDepartmentProperty(String alias) {
        return newEntityProperty(DepartmentProperty.class, alias);
    }

    public static ProductProperty newProductProperty() {
        return newProductProperty(null);
    }

    public static ProductProperty newProductProperty(String alias) {
        return newEntityProperty(ProductProperty.class, alias);
    }

    public static QueriedEntityProperty newQueriedEntityProperty() {
        return newQueriedEntityProperty(null);
    }

    public static QueriedEntityProperty newQueriedEntityProperty(String alias) {
        return newEntityProperty(QueriedEntityProperty.class, alias);
    }

    public static Party2Property newParty2Property() {
        return newParty2Property(null);
    }

    public static Party2Property newParty2Property(String alias) {
        return newEntityProperty(Party2Property.class, alias);
    }

    public static AddressProperty newAddressProperty() {
        return newAddressProperty(null);
    }

    public static AddressProperty newAddressProperty(String alias) {
        return newEntityProperty(AddressProperty.class, alias);
    }

    public static SIRETProperty newSIRETProperty() {
        return newSIRETProperty(null);
    }

    public static SIRETProperty newSIRETProperty(String alias) {
        return newEntityProperty(SIRETProperty.class, alias);
    }

    public static SIRENProperty newSIRENProperty() {
        return newSIRENProperty(null);
    }

    public static SIRENProperty newSIRENProperty(String alias) {
        return newEntityProperty(SIRENProperty.class, alias);
    }

    public static PersonProperty newPersonProperty() {
        return newPersonProperty(null);
    }

    public static PersonProperty newPersonProperty(String alias) {
        return newEntityProperty(PersonProperty.class, alias);
    }

    public static ExtraDAOEntityProperty newExtraDAOEntityProperty() {
        return newExtraDAOEntityProperty(null);
    }

    public static ExtraDAOEntityProperty newExtraDAOEntityProperty(String alias) {
        return newEntityProperty(ExtraDAOEntityProperty.class, alias);
    }

    public static GeneralizedNaturalizedEntityProperty newGeneralizedNaturalizedEntityProperty() {
        return newGeneralizedNaturalizedEntityProperty(null);
    }

    public static GeneralizedNaturalizedEntityProperty newGeneralizedNaturalizedEntityProperty(String alias) {
        return newEntityProperty(GeneralizedNaturalizedEntityProperty.class, alias);
    }

    public static StoreProperty newStoreProperty() {
        return newStoreProperty(null);
    }

    public static StoreProperty newStoreProperty(String alias) {
        return newEntityProperty(StoreProperty.class, alias);
    }

} //TopiaTestQueryHelper
