/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelDependency;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.topia.generator.TopiaGeneratorUtil;
import org.nuiton.topia.persistence.TopiaEntity;

public class BeanTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(BeanTransformer.class);

    public void transformFromClass(ObjectModelClass clazz) {
        Iterator j;
        ObjectModelClass resultClass;
        if (!clazz.hasStereotype("bean") && !clazz.hasStereotype("dto")) {
            return;
        }
        boolean isSuperClassSet = false;
        if (clazz.hasStereotype("bean")) {
            boolean hasOperations;
            resultClass = this.createAbstractClass(clazz.getName(), clazz.getPackageName());
            String implQualifiedName = clazz.getQualifiedName() + "Impl";
            String resourceName = "/" + implQualifiedName.replaceAll("\\.", "/");
            boolean bl = hasOperations = !clazz.getAllOtherOperations(true).isEmpty() || !clazz.getOperations().isEmpty();
            if (((Object)((Object)this)).getClass().getResource(resourceName) == null && !hasOperations) {
                String implName = clazz.getName() + "Impl";
                ObjectModelClass resultClassImpl = this.createClass(implName, clazz.getPackageName());
                this.setSuperClass(resultClassImpl, resultClass.getQualifiedName());
                isSuperClassSet = true;
            }
        } else {
            resultClass = this.createClass(clazz.getName(), clazz.getPackageName());
        }
        List attributes = (List)clazz.getAttributes();
        this.createForDTO(resultClass, clazz, attributes);
        if (!isSuperClassSet && (j = clazz.getSuperclasses().iterator()).hasNext()) {
            ObjectModelClass p = (ObjectModelClass)j.next();
            String qualifiedName = p.getQualifiedName();
            if (clazz.hasStereotype("bean")) {
                qualifiedName = p.getQualifiedName() + "Impl";
            }
            this.setSuperClass(resultClass, qualifiedName);
        }
        for (ObjectModelInterface parentInterface : clazz.getInterfaces()) {
            this.addInterface((ObjectModelClassifier)resultClass, parentInterface.getQualifiedName());
        }
        ObjectModelOperation constructor = this.addConstructor(resultClass, ObjectModelModifier.PUBLIC);
        this.createListeners(resultClass, clazz);
        boolean hasEntity = false;
        boolean hasMultipleAttribute = false;
        String toStringAppend = "";
        String initTabs = "";
        for (ObjectModelAttribute attr : attributes) {
            if (!attr.isNavigable() && !attr.hasAssociationClass()) continue;
            String attrType = attr.getType();
            String simpleType = GeneratorUtil.getSimpleName((String)attrType);
            String attrName = attr.getName();
            String attrNameCapitalized = StringUtils.capitalize((String)attrName);
            if (attr.hasStereotype("array")) {
                int maxSize = attr.getMaxMultiplicity();
                int maxSizeMoinsUn = maxSize - 1;
                initTabs = initTabs + "\n\tthis." + attrName + " = new " + attrType + "[" + maxSize + "];";
                ObjectModelOperation setValue = this.addOperation((ObjectModelClassifier)resultClass, "set" + attrNameCapitalized, "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(setValue, "int", "index");
                this.addParameter(setValue, attrType, "value");
                this.addException(setValue, "java.lang.ArrayIndexOutOfBoundsException");
                this.setOperationBody(setValue, "\n                                if (index >= " + maxSize + " || index < 0) {\n" + "                                    throw new ArrayIndexOutOfBoundsException(\"Wrong index [\" + index + \"] for array " + attrName + ",\" +\n" + "                                            \"index must be between 0 and " + maxSizeMoinsUn + "\");\n" + "                                }\n" + "                                " + simpleType + "[] oldValue = get" + attrNameCapitalized + "();\n" + "                                this." + attrName + "[index] = value;\n" + "                                firePropertyChange(\"" + attrName + "\", oldValue, this." + attrName + ");\n" + "                            ");
                ObjectModelOperation getValue = this.addOperation((ObjectModelClassifier)resultClass, "get" + attrNameCapitalized, attrType, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(getValue, "int", "index");
                this.addException(setValue, "java.lang.ArrayIndexOutOfBoundsException");
                this.setOperationBody(getValue, "\n                                if (index >= " + maxSize + " || index < 0) {\n" + "                                    throw new ArrayIndexOutOfBoundsException(\"Wrong index [\" + index + \"] for array " + attrName + ",\" +\n" + "                                            \"index must be between 0 and " + maxSizeMoinsUn + "\");\n" + "                                }\n" + "                                return this." + attrName + "[index];\n" + "                            ");
                attrType = attrType + "[]";
                simpleType = GeneratorUtil.getSimpleName((String)attrType);
            } else if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                boolean isEntity;
                hasMultipleAttribute = true;
                ObjectModelOperation getChild = this.addOperation((ObjectModelClassifier)resultClass, "get" + attrNameCapitalized, attrType, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(getChild, "int", "index");
                this.setOperationBody(getChild, "\n                                " + simpleType + " o = getChild(" + attrName + ", index);\n" + "                                return o;\n" + "                            ");
                ObjectModelClass attrEntity = null;
                if (((ObjectModel)this.getModel()).hasClass(attr.getType())) {
                    attrEntity = ((ObjectModel)this.getModel()).getClass(attr.getType());
                }
                boolean bl = isEntity = attrEntity != null && attrEntity.hasStereotype("entity");
                if (isEntity) {
                    hasEntity = true;
                    ObjectModelOperation getChildEntity = this.addOperation((ObjectModelClassifier)resultClass, "get" + attrNameCapitalized, attrType, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                    this.addParameter(getChildEntity, String.class.getName(), "topiaId");
                    this.setOperationBody(getChildEntity, "\n                                    " + simpleType + " o = getEntity(" + attrName + ", topiaId);\n" + "                                    return o;\n" + "                                ");
                }
                ObjectModelOperation addChild = this.addOperation((ObjectModelClassifier)resultClass, "add" + attrNameCapitalized, attrType, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(addChild, attrType, attrName);
                this.setOperationBody(addChild, "\n                                get" + attrNameCapitalized + "().add(" + attrName + ");\n" + "                                firePropertyChange(\"" + attrName + "\", null, " + attrName + ");\n" + "                                return " + attrName + ";\n" + "                            ");
                ObjectModelOperation removeChild = this.addOperation((ObjectModelClassifier)resultClass, "remove" + attrNameCapitalized, "boolean", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(removeChild, attrType, attrName);
                this.setOperationBody(removeChild, "\n                                boolean  removed = get" + attrNameCapitalized + "().remove(" + attrName + ");\n" + "                                if (removed) {\n" + "                                    firePropertyChange(\"" + attrName + "\", " + attrName + ", null);\n" + "                                }\n" + "                                return removed;\n" + "                            ");
                attrType = attr.isOrdered() ? List.class.getName() + "<" + attrType + ">" : Collection.class.getName() + "<" + attrType + ">";
                simpleType = GeneratorUtil.getSimpleName((String)attrType);
            }
            if (attr.hasAssociationClass()) {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                attrName = GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
                attrType = attr.getAssociationClass().getName();
            }
            String visibility = attr.getVisibility();
            this.addAttribute((ObjectModelClassifier)resultClass, attrName, attrType, "", new ObjectModelModifier[]{ObjectModelModifier.toValue((String)visibility)});
            ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)resultClass, "get" + attrNameCapitalized, attrType, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
            this.setOperationBody(getter, "\n                            return this." + attrName + ";\n" + "                        ");
            ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)resultClass, "set" + attrNameCapitalized, "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
            this.addParameter(setter, attrType, "newValue");
            this.setOperationBody(setter, "\n                            " + simpleType + " oldValue = get" + attrNameCapitalized + "();\n" + "                            this." + attrName + " = newValue;\n" + "                            firePropertyChange(\"" + attrName + "\", oldValue, newValue);\n" + "                        ");
            toStringAppend = toStringAppend + "\n\t\t.append(\"" + attrName + "\", this." + attrName + ")";
        }
        if (hasMultipleAttribute) {
            ObjectModelOperation getChild = this.addOperation((ObjectModelClassifier)resultClass, "getChild", "<T> T", new ObjectModelModifier[]{ObjectModelModifier.PROTECTED});
            this.addParameter(getChild, "java.util.Collection<T>", "childs");
            this.addParameter(getChild, "int", "index");
            this.setOperationBody(getChild, "\n                        if (childs != null) {\n                            int i = 0;\n                            for (T o : childs) {\n                                if (index == i) {\n                                    return o;\n                                }\n                                i++;\n                            }\n                        }\n                        return null;\n                    ");
        }
        if (hasEntity) {
            this.addImport((ObjectModelClassifier)resultClass, TopiaEntity.class);
            ObjectModelOperation getEntity = this.addOperation((ObjectModelClassifier)resultClass, "getEntity", "<T extends org.nuiton.topia.persistence.TopiaEntity> T", new ObjectModelModifier[]{ObjectModelModifier.PROTECTED});
            this.addParameter(getEntity, "java.util.Collection<T>", "childs");
            this.addParameter(getEntity, "java.lang.String", "topiaId");
            this.setOperationBody(getEntity, "\n                        if (childs != null) {\n                            for (T o : childs) {\n                                if (topiaId.equals(o.getTopiaId())) {\n                                    return o;\n                                }\n                            }\n                        }\n                        return null;\n                    ");
        }
        this.setOperationBody(constructor, "\n                    pcs = new PropertyChangeSupport(this);" + initTabs + "\n" + "                ");
        for (ObjectModelOperation op : clazz.getOperations()) {
            String visibility = op.getVisibility();
            ObjectModelOperation resultOperation = this.addOperation((ObjectModelClassifier)resultClass, op.getName(), op.getReturnType(), new ObjectModelModifier[]{ObjectModelModifier.toValue((String)visibility), ObjectModelModifier.ABSTRACT});
            for (ObjectModelParameter param : op.getParameters()) {
                this.addParameter(resultOperation, param.getType(), param.getName());
            }
            for (String exception : op.getExceptions()) {
                this.addException(resultOperation, exception);
            }
        }
        ObjectModelOperation toString = this.addOperation((ObjectModelClassifier)resultClass, "toString", "java.lang.String", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addImport((ObjectModelClassifier)resultClass, "org.apache.commons.lang.builder.ToStringBuilder");
        this.setOperationBody(toString, "\n                    String result = new ToStringBuilder(this)" + toStringAppend + ".\n" + "                            toString();\n" + "                    return result;\n" + "                ");
    }

    private void createForDTO(ObjectModelClass resultClass, ObjectModelClass inputClass, List<ObjectModelAttribute> attributes) {
        if (!inputClass.hasStereotype("dto")) {
            return;
        }
        this.addInterface((ObjectModelClassifier)resultClass, "java.io.Serializable");
        String svUID = TopiaGeneratorUtil.findTagValue((String)"dto-serialVersionUID", (ObjectModelElement)inputClass, (Model)this.getModel());
        if (svUID != null) {
            this.addConstant((ObjectModelClassifier)resultClass, "serialVersionUID", "long", svUID, ObjectModelModifier.PUBLIC);
        }
        for (ObjectModelDependency dependency : inputClass.getDependencies()) {
            ObjectModelClass supplier = (ObjectModelClass)dependency.getSupplier();
            if (!supplier.hasStereotype("entity")) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create primitive and date fields in DTO from Entity : " + supplier.getQualifiedName()));
            }
            for (ObjectModelAttribute attr : supplier.getAttributes()) {
                if (!TopiaGeneratorUtil.isPrimitiveType(attr) && !TopiaGeneratorUtil.isDateType(attr)) continue;
                attributes.add(attr);
            }
        }
    }

    protected void createListeners(ObjectModelClass resultClass, ObjectModelClass inputClass) {
        this.addAttribute((ObjectModelClassifier)resultClass, "pcs", "java.beans.PropertyChangeSupport", "", new ObjectModelModifier[]{ObjectModelModifier.PROTECTED, ObjectModelModifier.FINAL});
        String propType = "java.beans.PropertyChangeListener";
        String strType = String.class.getName();
        String objectType = Object.class.getName();
        ObjectModelOperation addPropertyChangeListener = this.addOperation((ObjectModelClassifier)resultClass, "addPropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addParameter(addPropertyChangeListener, propType, "listener");
        this.setOperationBody(addPropertyChangeListener, "\n                    pcs.addPropertyChangeListener(listener);\n                ");
        ObjectModelOperation addPropertyChangeListenerPlus = this.addOperation((ObjectModelClassifier)resultClass, "addPropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addParameter(addPropertyChangeListenerPlus, strType, "propertyName");
        this.addParameter(addPropertyChangeListenerPlus, propType, "listener");
        this.setOperationBody(addPropertyChangeListenerPlus, "\n                    pcs.addPropertyChangeListener(propertyName, listener);\n                ");
        ObjectModelOperation removePropertyChangeListener = this.addOperation((ObjectModelClassifier)resultClass, "removePropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addParameter(removePropertyChangeListener, propType, "listener");
        this.setOperationBody(removePropertyChangeListener, "\n                    pcs.removePropertyChangeListener(listener);\n                ");
        ObjectModelOperation removePropertyChangeListenerPlus = this.addOperation((ObjectModelClassifier)resultClass, "removePropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addParameter(removePropertyChangeListenerPlus, strType, "propertyName");
        this.addParameter(removePropertyChangeListenerPlus, propType, "listener");
        this.setOperationBody(removePropertyChangeListenerPlus, "\n                    pcs.removePropertyChangeListener(propertyName, listener);\n                ");
        ObjectModelOperation firePropertyChange = this.addOperation((ObjectModelClassifier)resultClass, "firePropertyChange", "void", new ObjectModelModifier[]{ObjectModelModifier.PROTECTED});
        this.addParameter(firePropertyChange, strType, "propertyName");
        this.addParameter(firePropertyChange, objectType, "oldValue");
        this.addParameter(firePropertyChange, objectType, "newValue");
        this.setOperationBody(firePropertyChange, "\n                    pcs.firePropertyChange(propertyName, oldValue, newValue);\n                ");
    }
}

