package org.nuiton.topiatest.deletetest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class Telephone2Abstract extends Contact2Impl implements Telephone2 {

    protected String prefix;
    protected String country;
    /**
     * getPrefix :
     * @return String 
     */

    public String getPrefix() {
        fireOnPreRead(PREFIX, prefix);
        java.lang.String result = this.prefix;
        fireOnPostRead(PREFIX, prefix);
        return result;
}

    /**
     * getCountry :
     * @return String 
     */

    public String getCountry() {
        fireOnPreRead(COUNTRY, country);
        java.lang.String result = this.country;
        fireOnPostRead(COUNTRY, country);
        return result;
}

    /**
     * update :
     * @deprecated since 2.3.4, use the DAO api instead.
     * @throws TopiaException
     */

    @Deprecated
    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Telephone2.class).update(this);
}

    /**
     * delete :
     * @deprecated since 2.3.4, use the DAO api instead.
     * @throws TopiaException
     */

    @Deprecated
    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Telephone2.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PREFIX, String.class, prefix);
        visitor.visit(this, COUNTRY, String.class, country);
        visitor.end(this);
}

    /**
     * getAggregate :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

    /**
     * setPrefix :
     * @param value 
     */

    public void setPrefix(String value) {
        String _oldValue = this.prefix;
        fireOnPreWrite(PREFIX, _oldValue, value);
        this.prefix = value;
        fireOnPostWrite(PREFIX, _oldValue, value);
}

    /**
     * setCountry :
     * @param value 
     */

    public void setCountry(String value) {
        String _oldValue = this.country;
        fireOnPreWrite(COUNTRY, _oldValue, value);
        this.country = value;
        fireOnPostWrite(COUNTRY, _oldValue, value);
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PREFIX, this.prefix).
            append(COUNTRY, this.country).
         toString();
        return result;
}

static {
    
    org.nuiton.i18n.I18n.n_("topia.test.common.telephone2");
    org.nuiton.i18n.I18n.n_("topia.test.common.prefix");
    org.nuiton.i18n.I18n.n_("topia.test.common.country");
    }

} //Telephone2Abstract
