/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: InterfaceTransformer.java 2010 2010-06-13 18:18:35Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.4/topia-persistence/src/main/java/org/nuiton/topia/generator/InterfaceTransformer.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.generator;

import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;

/**
 * InterfaceTransformer
 *
 * Created: 7 nov. 2009
 *
 * @author fdesbois <fdesbois@codelutin.com>
 * @version $Id: InterfaceTransformer.java 2010 2010-06-13 18:18:35Z tchemit $
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.InterfaceTransformer"
 * @deprecated since 2.3.4 use {@link org.nuiton.eugene.java.JavaInterfaceTransformer} instead
 */
@Deprecated
public class InterfaceTransformer extends ObjectModelTransformerToJava {

    private static final Log log = LogFactory.getLog(InterfaceTransformer.class);

    @Override
    public void transformFromInterface(ObjectModelInterface interfacez) {
        if (!interfacez.getStereotypes().isEmpty()) {
            // can only generate an interface with there is no other stereotypes
            return;
        }

        ObjectModelInterface resultInterface = createInterface(interfacez.getName(), interfacez.getPackageName());

        if (log.isDebugEnabled()) {
            log.debug("will create model for "+resultInterface.getQualifiedName());
        }


        // extend interface
        Iterator<ObjectModelInterface> it = interfacez.getInterfaces().iterator();
        if (it.hasNext()) {
            ObjectModelInterface extend = it.next();
            addInterface(resultInterface, extend.getQualifiedName());
        }

        // constant attributes
        for (ObjectModelAttribute attr : interfacez.getAttributes()) {
            if (!attr.isStatic() && StringUtils.isNotEmpty(attr.getDefaultValue())) { // only static attribut with value
                addConstant(resultInterface, attr.getName(), attr.getType(), attr.getDefaultValue(), ObjectModelModifier.PUBLIC);
            }
        }

        // interface operations
        for (ObjectModelOperation op : interfacez.getOperations()) {
            ObjectModelOperation resultOp = addOperation(resultInterface, op.getName(), op.getReturnType());
            for (ObjectModelParameter param : op.getParameters()) {
                addParameter(resultOp, param.getType(), param.getName());
            }
            for (String exception : op.getExceptions()) {
                addException(resultOp, exception);
            }
        }
    }
}
