package org.nuiton.topiatest.beangen;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang.builder.ToStringBuilder;


public class PersonneDTO implements Serializable {

    protected final PropertyChangeSupport pcs;
    public String name;
    public Collection<String> otherNames;
    /**
     * PersonneDTO :
     */

    public PersonneDTO() {
        pcs = new PropertyChangeSupport(this);
    }

    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    /**
     * addPropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    /**
     * removePropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    /**
     * firePropertyChange :
     * @param propertyName 
     * @param oldValue 
     * @param newValue 
     */

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        return this.name;
    }

    /**
     * setName :
     * @param newValue 
     */

    public void setName(String newValue) {
        String oldValue = getName();
        this.name = newValue;
        firePropertyChange("name", oldValue, newValue);
    }

    /**
     * getOtherNames :
     * @param index 
     * @return String 
     */

    public String getOtherNames(int index) {
        String o = getChild(otherNames, index);
        return o;
    }

    /**
     * addOtherNames :
     * @param otherNames 
     * @return String 
     */

    public String addOtherNames(String otherNames) {
        getOtherNames().add(otherNames);
        firePropertyChange("otherNames", null, otherNames);
        return otherNames;
    }

    /**
     * removeOtherNames :
     * @param otherNames 
     * @return boolean 
     */

    public boolean removeOtherNames(String otherNames) {
        boolean  removed = getOtherNames().remove(otherNames);
        if (removed) {
            firePropertyChange("otherNames", otherNames, null);
        }
        return removed;
    }

    /**
     * getOtherNames :
     * @return Collection<String> 
     */

    public Collection<String> getOtherNames() {
        return this.otherNames;
    }

    /**
     * setOtherNames :
     * @param newValue 
     */

    public void setOtherNames(Collection<String> newValue) {
        Collection<String> oldValue = getOtherNames();
        this.otherNames = newValue;
        firePropertyChange("otherNames", oldValue, newValue);
    }

    /**
     * getChild :
     * @param childs 
     * @param index 
     * @return <T> T 
     */

    protected <T> T getChild(Collection<T> childs, int index) {
        if (childs != null) {
            int i = 0;
            for (T o : childs) {
                if (index == i) {
                    return o;
                }
                i++;
            }
        }
        return null;
    }

    /**
     * toString :
     * @return String 
     */

    public String toString() {
        String result = new ToStringBuilder(this)
		.append("name", this.name)
		.append("otherNames", this.otherNames).
                toString();
        return result;
    }


} //PersonneDTO
