/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.topia.generator.TopiaGeneratorUtil;

public class EntityDTOTransformer
extends ObjectModelTransformerToJava {
    public boolean isEntity(String type) {
        ObjectModelClassifier clazz = ((ObjectModel)this.model).getClassifier(type);
        return clazz != null && clazz.hasStereotype("entity");
    }

    public void transformFromClass(ObjectModelClass clazz) {
        if (!clazz.hasStereotype("entity")) {
            return;
        }
        String clazzName = clazz.getName();
        ObjectModelClass result = this.createClass(clazzName + "DTO", clazz.getPackageName());
        this.addImport((ObjectModelClassifier)result, ToStringBuilder.class);
        this.addImport((ObjectModelClassifier)result, PropertyChangeListener.class);
        this.setDocumentation((ObjectModelElement)result, "Implantation DTO pour l'entit\u00e9 " + StringUtils.capitalize((String)clazzName) + ".");
        String extendClass = "";
        Iterator i$ = clazz.getSuperclasses().iterator();
        if (i$.hasNext()) {
            ObjectModelClass parent = (ObjectModelClass)i$.next();
            extendClass = parent.getQualifiedName() + "DTO";
        }
        if (extendClass.length() > 0) {
            this.setSuperClass(result, extendClass);
        }
        this.addInterface((ObjectModelClassifier)result, Serializable.class);
        this.addAttributes(result, clazz);
        this.addOperations(result, clazz);
    }

    protected void addAttributes(ObjectModelClass result, ObjectModelClass clazz) {
        String attrName;
        String attrType;
        ObjectModelModifier modifier;
        String attrVisibility;
        String svUID = TopiaGeneratorUtil.findTagValue((String)"dto-serialVersionUID", (ObjectModelElement)clazz, (Model)this.model);
        if (svUID != null) {
            this.addAttribute((ObjectModelClassifier)result, "serialVersionUID", "long", svUID, new ObjectModelModifier[]{ObjectModelModifier.FINAL, ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        }
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute attr2;
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model) && !attr.hasAssociationClass()) continue;
            attrVisibility = attr.getVisibility();
            modifier = ObjectModelModifier.toValue((String)attrVisibility);
            if (!attr.hasAssociationClass()) {
                attrType = attr.getType();
                attrName = attr.getName();
                if (this.isEntity(attrType)) {
                    attrType = attrType + "DTO";
                }
                attr2 = !GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr) ? this.addAttribute((ObjectModelClassifier)result, attrName, attrType, null, new ObjectModelModifier[]{modifier}) : this.addAttribute((ObjectModelClassifier)result, attrName, attrType + "[]", null, new ObjectModelModifier[]{modifier});
            } else {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                attr2 = !GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr) ? this.addAttribute((ObjectModelClassifier)result, GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName), assocClassFQN + "DTO", null, new ObjectModelModifier[]{modifier}) : this.addAttribute((ObjectModelClassifier)result, GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName), assocClassFQN + "DTO[]", null, new ObjectModelModifier[]{modifier});
            }
            if (attr2 == null) continue;
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                this.setDocumentation((ObjectModelElement)attr2, attr.getDocumentation());
            }
            if (!attr.hasTagValue("annotation")) continue;
            String annotation = attr.getTagValue("annotation");
            this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)attr2, annotation);
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                attrVisibility = attr.getVisibility();
                modifier = ObjectModelModifier.toValue((String)attrVisibility);
                attrType = attr.getType();
                attrName = attr.getName();
                if (this.isEntity(attrType)) {
                    attrType = attrType + "DTO";
                }
                this.addAttribute((ObjectModelClassifier)result, GeneratorUtil.toLowerCaseFirstLetter((String)attrName), attrType, null, new ObjectModelModifier[]{modifier});
            }
        }
        this.addAttribute((ObjectModelClassifier)result, "p", PropertyChangeSupport.class, "new PropertyChangeSupport(this)", new ObjectModelModifier[]{ObjectModelModifier.PROTECTED, ObjectModelModifier.FINAL});
    }

    protected void addOperations(ObjectModelClass result, ObjectModelClass clazz) {
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "addPropertyChangeListener", "void", new ObjectModelModifier[0]);
        this.addParameter(op, PropertyChangeListener.class, "listener");
        this.setOperationBody(op, "\n        p.addPropertyChangeListener(listener);\n    ");
        op = this.addOperation((ObjectModelClassifier)result, "addPropertyChangeListener", "void", new ObjectModelModifier[0]);
        this.addParameter(op, String.class, "propertyName");
        this.addParameter(op, PropertyChangeListener.class, "listener");
        this.setOperationBody(op, "\n        p.addPropertyChangeListener(propertyName, listener);\n    ");
        op = this.addOperation((ObjectModelClassifier)result, "removePropertyChangeListener", "void", new ObjectModelModifier[0]);
        this.addParameter(op, PropertyChangeListener.class, "listener");
        this.setOperationBody(op, "\n        p.removePropertyChangeListener(listener);\n    ");
        op = this.addOperation((ObjectModelClassifier)result, "removePropertyChangeListener", "void", new ObjectModelModifier[0]);
        this.addParameter(op, String.class, "propertyName");
        this.addParameter(op, PropertyChangeListener.class, "listener");
        this.setOperationBody(op, "\n        p.removePropertyChangeListener(propertyName, listener);\n    ");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model)) continue;
            String attrName = attr.getName();
            if (!attr.hasAssociationClass()) {
                String attrType = attr.getType();
                if (this.isEntity(attrType)) {
                    attrType = attrType + "DTO";
                }
                String capitalizedAttrName = StringUtils.capitalize((String)attrName);
                if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    op = this.addOperation((ObjectModelClassifier)result, "set" + capitalizedAttrName, "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                    this.addParameter(op, attrType, "value");
                    this.setOperationBody(op, "\n        " + attrType + " oldValue = this." + attrName + ";\n" + "        this." + attrName + " = value;\n" + "        p.firePropertyChange(\"" + attrName + "\", oldValue, value);\n" + "    ");
                    op = this.addOperation((ObjectModelClassifier)result, "get" + capitalizedAttrName, attrType, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                    this.setOperationBody(op, "\n        return " + attrName + ";\n" + "    ");
                    continue;
                }
                op = this.addOperation((ObjectModelClassifier)result, "set" + capitalizedAttrName, "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, attrType + "[]", "values");
                this.setOperationBody(op, "\n        " + attrType + "[] oldValues = this." + attrName + ";\n" + "        this." + attrName + " = values;\n" + "        p.firePropertyChange(\"" + attrName + "\", oldValues, values);\n" + "    ");
                op = this.addOperation((ObjectModelClassifier)result, "get" + capitalizedAttrName, attrType + "[]", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.setOperationBody(op, "\n        return " + attrName + ";\n" + "    ");
                continue;
            }
            String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
            String propertyName = GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
            String assocClassFQN = attr.getAssociationClass().getQualifiedName();
            String capitaliedAttrName = StringUtils.capitalize((String)assocAttrName);
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                op = this.addOperation((ObjectModelClassifier)result, "set" + capitaliedAttrName, "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, assocClassFQN + "DTO", "association");
                this.setOperationBody(op, "\n        " + assocClassFQN + "DTO oldAssocation= this." + propertyName + ";\n" + "        this." + propertyName + " = association;\n" + "        p.firePropertyChange(\"" + attrName + "\", oldAssocation, assocation);\n" + "    ");
                op = this.addOperation((ObjectModelClassifier)result, "get" + capitaliedAttrName, assocClassFQN + "DTO", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.setOperationBody(op, "\n        return " + propertyName + ";\n" + "    ");
                continue;
            }
            op = this.addOperation((ObjectModelClassifier)result, "set" + capitaliedAttrName, "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
            this.addParameter(op, assocClassFQN + "DTO[]", "values");
            this.setOperationBody(op, "\n        " + assocClassFQN + "DTO[] oldValues = this." + propertyName + ";\n" + "        this." + propertyName + " = values;\n" + "        p.firePropertyChange(\"" + attrName + "\", oldValues, values);\n" + "    ");
            op = this.addOperation((ObjectModelClassifier)result, "get" + capitaliedAttrName, assocClassFQN + "DTO[]", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
            this.setOperationBody(op, "\n        return this." + propertyName + ";\n" + "    ");
        }
        op = this.addOperation((ObjectModelClassifier)result, "toString", String.class, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n        String result = new ToStringBuilder(this).\n");
        Iterator i$ = clazz.getAttributes().iterator();
        while (i$.hasNext()) {
            ObjectModelAttribute o;
            ObjectModelAttribute attr = o = (ObjectModelAttribute)i$.next();
            ObjectModelClass attrEntity = null;
            if (((ObjectModel)this.model).hasClass(attr.getType())) {
                attrEntity = ((ObjectModel)this.model).getClass(attr.getType());
            }
            boolean isEntity = attrEntity != null && attrEntity.hasStereotype("entity");
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if ((!isEntity || reverse != null && reverse.isNavigable() || attr.hasAssociationClass()) && isEntity) continue;
            String attrName = attr.getName();
            buffer.append("            append(\"" + attrName + "\", this." + attrName + ").\n" + "");
        }
        buffer.append("         toString();\n        return result;\n");
        this.setOperationBody(op, buffer.toString());
    }
}

