/**
 * *##% 
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.topia.persistence.util;

import org.nuiton.topia.persistence.TopiaEntity;

/**
 * A implementation of {@link BeanPropertyLoador} for {@link TopiaEntity}
 * <p/>
 * Some factory methods are defined to simplify the generic cast, prefer used them
 * instead of the (protected) constructor).
 *
 * @param <E> type of entity
 * @author chemit
 */
public class EntityLoador<E extends TopiaEntity> extends BeanPropertyLoador<E> {

    private static final long serialVersionUID = 1L;
    protected E empty;

    public static <E extends TopiaEntity> EntityLoador<E> newEntityLoador(Class<E> klass, E empty, String... properties) {
        return new EntityLoador<E>(klass, empty, properties);
    }

    public static <E extends TopiaEntity> EntityLoador<E> newEntityLoador(Class<E> klass, String... properties) {
        return newEntityLoador(klass, null, properties);
    }

    @Override
    public void load(E from, E dst, boolean tech) {
        if (from == null) {
            from = empty;
        }
        if (tech) {
            TopiaEntityHelper.bindTechnical(from, dst);
        }
        super.load(from, dst, tech);
    }

    protected EntityLoador(Class<E> klass, E empty, String... properties) {
        super(klass, properties);
        this.empty = empty;
        // check properties
        checkProperties();
    }
}
