/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.fife.ui.rsyntaxtextarea.RSTAView;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenOrientedView;

public class SyntaxView
extends View
implements TabExpander,
TokenOrientedView,
RSTAView {
    Font font;
    protected FontMetrics metrics;
    Element longLine;
    float longLineWidth;
    private int tabSize;
    protected int tabBase;
    private RSyntaxTextArea host;
    private int lineHeight = 0;
    private int ascent;
    private int clipStart;
    private int clipEnd;

    public SyntaxView(Element elem) {
        super(elem);
    }

    void calculateLongestLine() {
        Container c = this.getContainer();
        this.font = c.getFont();
        this.metrics = c.getFontMetrics(this.font);
        this.tabSize = this.getTabSize() * this.metrics.charWidth(' ');
        Element lines = this.getElement();
        int n = lines.getElementCount();
        for (int i = 0; i < n; ++i) {
            Element line = lines.getElement(i);
            float w = this.getLineWidth(i);
            if (!(w > this.longLineWidth)) continue;
            this.longLineWidth = w;
            this.longLine = line;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, a, f);
    }

    protected void damageLineRange(int line0, int line1, Shape a, Component host) {
        if (a != null) {
            Rectangle area0 = this.lineToRect(a, line0);
            Rectangle area1 = this.lineToRect(a, line1);
            if (area0 != null && area1 != null) {
                Rectangle dmg = area0.union(area1);
                host.repaint(dmg.x, dmg.y, dmg.width, dmg.height);
            } else {
                host.repaint();
            }
        }
    }

    public float drawLine(Token token, Graphics2D g, float x, float y) {
        float nextX = x;
        while (token != null && token.isPaintable() && nextX < (float)this.clipEnd) {
            nextX = token.paint(g, nextX, y, this.host, this, this.clipStart);
            token = token.getNextToken();
        }
        if (this.host.getEOLMarkersVisible()) {
            g.setColor(this.host.getForegroundForTokenType(16));
            g.setFont(this.host.getFontForTokenType(16));
            g.drawString("\u00b6", nextX, y);
        }
        return nextX;
    }

    private float getLineWidth(int lineNumber) {
        Token tokenList = ((RSyntaxDocument)this.getDocument()).getTokenListForLine(lineNumber);
        return RSyntaxUtilities.getTokenListWidth(tokenList, (RSyntaxTextArea)this.getContainer(), this);
    }

    @Override
    public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        return RSyntaxUtilities.getNextVisualPositionFrom(pos, b, a, direction, biasRet, this);
    }

    @Override
    public float getPreferredSpan(int axis) {
        this.updateMetrics();
        switch (axis) {
            case 0: {
                float span = this.longLineWidth + 10.0f;
                if (this.host.getEOLMarkersVisible()) {
                    span += (float)this.metrics.charWidth('\u00b6');
                }
                return span;
            }
            case 1: {
                this.lineHeight = this.host != null ? this.host.getLineHeight() : this.lineHeight;
                return this.getElement().getElementCount() * this.lineHeight;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    protected int getTabSize() {
        Integer i = (Integer)this.getDocument().getProperty("tabSize");
        int size = i != null ? i : 5;
        return size;
    }

    @Override
    public Token getTokenListForPhysicalLineAbove(int offset) {
        RSyntaxDocument document = (RSyntaxDocument)this.getDocument();
        Element map = document.getDefaultRootElement();
        int line = map.getElementIndex(offset) - 1;
        if (line >= 0) {
            return document.getTokenListForLine(line);
        }
        return null;
    }

    @Override
    public Token getTokenListForPhysicalLineBelow(int offset) {
        int lineCount;
        RSyntaxDocument document = (RSyntaxDocument)this.getDocument();
        Element map = document.getDefaultRootElement();
        int line = map.getElementIndex(offset);
        if (line < (lineCount = map.getElementCount()) - 1) {
            return document.getTokenListForLine(line + 1);
        }
        return null;
    }

    @Override
    public void insertUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, a, f);
    }

    protected Rectangle lineToRect(Shape a, int line) {
        Rectangle r = null;
        this.updateMetrics();
        if (this.metrics != null) {
            Rectangle alloc = a.getBounds();
            this.lineHeight = this.host != null ? this.host.getLineHeight() : this.lineHeight;
            r = new Rectangle(alloc.x, alloc.y + line * this.lineHeight, alloc.width, this.lineHeight);
        }
        return r;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Element map = this.getElement();
        RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
        int lineIndex = map.getElementIndex(pos);
        Rectangle lineArea = this.lineToRect(a, lineIndex);
        this.tabBase = lineArea.x;
        Token tokenList = doc.getTokenListForLine(lineIndex);
        lineArea = tokenList.listOffsetToView((RSyntaxTextArea)this.getContainer(), this, pos, this.tabBase, lineArea);
        return lineArea;
    }

    @Override
    public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
        Rectangle r1;
        Shape s1;
        Shape s0 = this.modelToView(p0, a, b0);
        if (p1 == this.getEndOffset()) {
            try {
                s1 = this.modelToView(p1, a, b1);
            }
            catch (BadLocationException ble) {
                s1 = null;
            }
            if (s1 == null) {
                Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                s1 = new Rectangle(alloc.x + alloc.width - 1, alloc.y, 1, alloc.height);
            }
        } else {
            s1 = this.modelToView(p1, a, b1);
        }
        Rectangle r0 = s0.getBounds();
        Rectangle rectangle = r1 = s1 instanceof Rectangle ? (Rectangle)s1 : s1.getBounds();
        if (r0.y != r1.y) {
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            r0.x = alloc.x;
            r0.width = alloc.width;
        }
        r0.add(r1);
        if (p1 > p0) {
            r0.width -= r1.width;
        }
        return r0;
    }

    @Override
    public float nextTabStop(float x, int tabOffset) {
        if (this.tabSize == 0) {
            return x;
        }
        int ntabs = ((int)x - this.tabBase) / this.tabSize;
        return this.tabBase + (ntabs + 1) * this.tabSize;
    }

    @Override
    public void paint(Graphics g, Shape a) {
        RSyntaxDocument document = (RSyntaxDocument)this.getDocument();
        Rectangle alloc = a.getBounds();
        this.tabBase = alloc.x;
        this.host = (RSyntaxTextArea)this.getContainer();
        Rectangle clip = g.getClipBounds();
        this.clipStart = clip.x;
        this.clipEnd = this.clipStart + clip.width;
        this.lineHeight = this.host.getLineHeight();
        this.ascent = this.host.getMaxAscent();
        int heightBelow = alloc.y + alloc.height - (clip.y + clip.height);
        int linesBelow = Math.max(0, heightBelow / this.lineHeight);
        int heightAbove = clip.y - alloc.y;
        int linesAbove = Math.max(0, heightAbove / this.lineHeight);
        int linesTotal = alloc.height / this.lineHeight;
        if (alloc.height % this.lineHeight != 0) {
            ++linesTotal;
        }
        Rectangle lineArea = this.lineToRect(a, linesAbove);
        int y = lineArea.y + this.ascent;
        int x = lineArea.x;
        Element map = this.getElement();
        int lineCount = map.getElementCount();
        int endLine = Math.min(lineCount, linesTotal - linesBelow);
        RSyntaxTextAreaHighlighter h = (RSyntaxTextAreaHighlighter)this.host.getHighlighter();
        Graphics2D g2d = (Graphics2D)g;
        for (int line = linesAbove; line < endLine; ++line) {
            Element lineElement = map.getElement(line);
            int startOffset = lineElement.getStartOffset();
            int endOffset = lineElement.getEndOffset() - 1;
            h.paintLayeredHighlights(g2d, startOffset, endOffset, a, this.host, this);
            Token token = document.getTokenListForLine(line);
            this.drawLine(token, g2d, x, y);
            y += this.lineHeight;
        }
    }

    protected boolean possiblyUpdateLongLine(Element line, int lineNumber) {
        float w = this.getLineWidth(lineNumber);
        if (w > this.longLineWidth) {
            this.longLineWidth = w;
            this.longLine = line;
            return true;
        }
        return false;
    }

    @Override
    public void removeUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, a, f);
    }

    @Override
    public void setSize(float width, float height) {
        super.setSize(width, height);
        this.updateMetrics();
    }

    protected void updateDamage(DocumentEvent changes, Shape a, ViewFactory f) {
        Element[] removed;
        Container host = this.getContainer();
        this.updateMetrics();
        Element elem = this.getElement();
        DocumentEvent.ElementChange ec = changes.getChange(elem);
        Element[] added = ec != null ? ec.getChildrenAdded() : null;
        Element[] elementArray = removed = ec != null ? ec.getChildrenRemoved() : null;
        if (added != null && added.length > 0 || removed != null && removed.length > 0) {
            if (added != null) {
                int addedAt = ec.getIndex();
                for (int i = 0; i < added.length; ++i) {
                    this.possiblyUpdateLongLine(added[i], addedAt + i);
                }
            }
            if (removed != null) {
                for (int i = 0; i < removed.length; ++i) {
                    if (removed[i] != this.longLine) continue;
                    this.longLineWidth = -1.0f;
                    this.calculateLongestLine();
                    break;
                }
            }
            this.preferenceChanged(null, true, true);
            host.repaint();
        } else if (changes.getType() == DocumentEvent.EventType.CHANGE) {
            int startLine = changes.getOffset();
            int endLine = changes.getLength();
            this.damageLineRange(startLine, endLine, a, host);
        } else {
            Element map = this.getElement();
            int line = map.getElementIndex(changes.getOffset());
            this.damageLineRange(line, line, a, host);
            if (changes.getType() == DocumentEvent.EventType.INSERT) {
                Element e = map.getElement(line);
                if (e == this.longLine) {
                    this.longLineWidth = this.getLineWidth(line);
                    this.preferenceChanged(null, true, false);
                } else if (this.possiblyUpdateLongLine(e, line)) {
                    this.preferenceChanged(null, true, false);
                }
            } else if (changes.getType() == DocumentEvent.EventType.REMOVE && map.getElement(line) == this.longLine) {
                this.longLineWidth = -1.0f;
                this.calculateLongestLine();
                this.preferenceChanged(null, true, false);
            }
        }
    }

    protected void updateMetrics() {
        this.host = (RSyntaxTextArea)this.getContainer();
        Font f = this.host.getFont();
        if (this.font != f) {
            this.calculateLongestLine();
        }
    }

    @Override
    public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
        bias[0] = Position.Bias.Forward;
        Rectangle alloc = a.getBounds();
        RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
        int x = (int)fx;
        int y = (int)fy;
        if (y < alloc.y) {
            return this.getStartOffset();
        }
        if (y > alloc.y + alloc.height) {
            return this.getEndOffset() - 1;
        }
        Element map = doc.getDefaultRootElement();
        int lineIndex = Math.abs((y - alloc.y) / this.lineHeight);
        if (lineIndex >= map.getElementCount()) {
            return this.getEndOffset() - 1;
        }
        Element line = map.getElement(lineIndex);
        if (x < alloc.x) {
            return line.getStartOffset();
        }
        if (x > alloc.x + alloc.width) {
            return line.getEndOffset() - 1;
        }
        int p0 = line.getStartOffset();
        Token tokenList = doc.getTokenListForLine(lineIndex);
        this.tabBase = alloc.x;
        int offs = tokenList.getListOffset((RSyntaxTextArea)this.getContainer(), this, this.tabBase, x);
        return offs != -1 ? offs : p0;
    }

    @Override
    public int yForLineContaining(Rectangle alloc, int offs) throws BadLocationException {
        Element map = this.getElement();
        int line = map.getElementIndex(offs);
        this.updateMetrics();
        if (this.metrics != null) {
            this.lineHeight = this.host != null ? this.host.getLineHeight() : this.lineHeight;
            return alloc.y + line * this.lineHeight;
        }
        return -1;
    }
}

