/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.uiweb.actions;

import java.io.File;
import java.text.Normalizer;
import javax.servlet.http.HttpSession;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.nuiton.scmwebeditor.api.ScmConnection;
import org.nuiton.scmwebeditor.api.ScmFileManager;
import org.nuiton.scmwebeditor.api.ScmProvider;
import org.nuiton.scmwebeditor.api.dto.CreateDirectoryDto;
import org.nuiton.scmwebeditor.api.dto.result.CreateDirectoryResultDto;
import org.nuiton.scmwebeditor.uiweb.ScmWebEditorConfig;
import org.nuiton.scmwebeditor.uiweb.actions.AbstractScmWebEditorAction;

public class CreateDirectoryAction
extends AbstractScmWebEditorAction
implements ServletRequestAware {
    private static final long serialVersionUID = 4244339447567114412L;
    public static final String REDIRECT = "redirect";
    protected String username;
    protected String pw;
    protected String address;
    protected String scmRoot;
    protected String directoryName;
    protected String parentDirectory;
    protected boolean badLogin;
    protected boolean error;
    protected String fileRoot;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPw() {
        return this.pw;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean isBadLogin() {
        return this.badLogin;
    }

    public boolean isError() {
        return this.error;
    }

    public String getScmRoot() {
        return this.scmRoot;
    }

    public void setScmRoot(String scmRoot) {
        this.scmRoot = scmRoot;
    }

    public void setBadLogin(boolean badLogin) {
        this.badLogin = badLogin;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public String getFileRoot() {
        return this.fileRoot;
    }

    public void setFileRoot(String fileRoot) {
        this.fileRoot = fileRoot;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public String getParentDirectory() {
        return this.parentDirectory;
    }

    public void setParentDirectory(String parentDirectory) {
        this.parentDirectory = parentDirectory;
    }

    public String execute() {
        String repositoryUUID;
        HttpSession session = this.request.getSession();
        String sessionId = session.getId();
        String pathToLocalRepos = ScmWebEditorConfig.getLocalRepositoriesPath() + File.separator + sessionId;
        ScmProvider provider = ScmWebEditorConfig.getProvider((String)this.scmType);
        ScmConnection scmConn = provider.getConnection(this.address, pathToLocalRepos);
        ScmFileManager scmFileManager = provider.getFileManager(scmConn);
        if (this.address.endsWith("/")) {
            this.address = this.address.substring(0, this.address.lastIndexOf(47));
        }
        if ((repositoryUUID = scmConn.getRepositoryId()) == null) {
            repositoryUUID = this.address.replace(' ', '_');
            repositoryUUID = Normalizer.normalize(repositoryUUID, Normalizer.Form.NFD).replaceAll("[\u0300-\u036f]", "");
        }
        String[] usernamePw = this.getUsernamePwFromSession(repositoryUUID, this.username, this.pw);
        this.username = usernamePw[0];
        this.pw = usernamePw[1];
        CreateDirectoryDto dto = new CreateDirectoryDto();
        dto.setUsername(this.username);
        dto.setPassword(this.pw);
        dto.setDirectoryName(this.directoryName);
        dto.setParentDirectory(this.parentDirectory);
        CreateDirectoryResultDto resultDto = scmFileManager.createDirectory(dto);
        if (resultDto.getScmRoot() != null) {
            this.scmRoot = resultDto.getScmRoot();
        }
        if (resultDto.getFileRoot() != null) {
            this.fileRoot = resultDto.getFileRoot();
        }
        if (this.username != null && this.pw != null && this.username.equals("") && this.pw.equals("")) {
            this.username = null;
            this.pw = null;
        }
        if (resultDto.getError() != null) {
            String errorMessage = resultDto.getError();
            this.error = true;
            if (errorMessage.equals("connection failed")) {
                this.getScmSession().delScmUser(scmConn.getRepositoryId());
                this.username = null;
                this.pw = null;
                return "error";
            }
            if (errorMessage.equals("auth error")) {
                this.badLogin = true;
                this.username = null;
                this.pw = null;
                this.getScmSession().delScmUser(scmConn.getRepositoryId());
                return "login";
            }
            if (errorMessage.equals(REDIRECT)) {
                this.error = false;
                return REDIRECT;
            }
            return "error";
        }
        return "success";
    }
}

