/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.uiweb.actions;

import java.io.File;
import java.io.IOException;
import java.text.Normalizer;
import javax.naming.AuthenticationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.scmwebeditor.api.ScmConnection;
import org.nuiton.scmwebeditor.api.ScmProvider;
import org.nuiton.scmwebeditor.uiweb.ScmWebEditorConfig;
import org.nuiton.scmwebeditor.uiweb.actions.AbstractScmWebEditorAction;

public class ResetAction
extends AbstractScmWebEditorAction {
    private static final long serialVersionUID = -1154924826535371319L;
    private static final Log log = LogFactory.getLog(ResetAction.class);
    protected String lastRevision;
    protected String numRevision;
    protected String address;
    protected String username;
    protected String pw;
    protected String error;

    public String getLastRevision() {
        return this.lastRevision;
    }

    public String getNumRevision() {
        return this.numRevision;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public String getError() {
        return this.error;
    }

    public String execute() {
        block5: {
            String sessionId = this.request.getSession().getId();
            String pathToLocalRepos = ScmWebEditorConfig.getLocalRepositoriesPath() + File.separator + sessionId;
            ScmProvider provider = ScmWebEditorConfig.getProvider((String)this.scmType);
            ScmConnection scmConn = provider.getConnection(this.address, pathToLocalRepos);
            String repositoryId = scmConn.getRepositoryId();
            if (repositoryId == null) {
                repositoryId = this.address.replace(' ', '_');
                repositoryId = Normalizer.normalize(repositoryId, Normalizer.Form.NFD).replaceAll("[\u0300-\u036f]", "");
            }
            String[] usernamePw = this.getUsernamePwFromSession(repositoryId, this.username, this.pw);
            this.username = usernamePw[0];
            this.pw = usernamePw[1];
            try {
                File originalFile = scmConn.getFileContent(this.address, this.username, this.pw);
                this.lastRevision = FileUtils.readFileToString((File)originalFile);
                this.numRevision = scmConn.getHeadRevisionNumber(this.address, this.username, this.pw);
            }
            catch (AuthenticationException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"AUTH FAIL");
                }
                this.error = "authError";
                return "authError";
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Can not read content file", (Throwable)e);
            }
        }
        return "success";
    }
}

