/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.uiweb.actions;

import java.io.File;
import java.text.Normalizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.nuiton.scmwebeditor.api.ScmConnection;
import org.nuiton.scmwebeditor.api.ScmProvider;
import org.nuiton.scmwebeditor.uiweb.ScmWebEditorConfig;
import org.nuiton.scmwebeditor.uiweb.actions.AbstractScmWebEditorAction;

public class LogoutAction
extends AbstractScmWebEditorAction
implements ServletRequestAware,
ServletResponseAware {
    private static final long serialVersionUID = 6937086747942656369L;
    private static final Log log = LogFactory.getLog(LogoutAction.class);
    protected String address;
    protected String projectUrl;
    protected transient HttpServletRequest request;
    protected transient HttpServletResponse response;

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }

    public String execute() {
        String sessionId = this.request.getSession().getId();
        String pathToLocalRepos = ScmWebEditorConfig.getLocalRepositoriesPath() + File.separator + sessionId;
        ScmProvider provider = ScmWebEditorConfig.getProvider((String)this.scmType);
        ScmConnection scmConn = provider.getConnection(this.address, pathToLocalRepos);
        String repositoryId = scmConn.getRepositoryId();
        if (repositoryId == null) {
            repositoryId = this.address.replace(' ', '_');
            repositoryId = Normalizer.normalize(repositoryId, Normalizer.Form.NFD).replaceAll("[\u0300-\u036f]", "");
        }
        for (Cookie c : this.request.getCookies()) {
            if (!c.getName().equals(repositoryId)) continue;
            c.setMaxAge(0);
            this.response.addCookie(c);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)"Cookie supprim\u00e9");
        }
        this.getScmSession().delScmUser(repositoryId);
        return "success";
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }
}

