/* *##% nuiton-processor - lib
 * Copyright (C) 2002 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%* */
/*******************************************************************************
 * DefaultFilter.java
 * 
 * Created: Wed Sep 4 2002
 * 
 * @author <poussin@codelutin.com>Copyright Code Lutin
 * 
 * @version $Revision: 255 $
 * 
 * Mise a jour: $Date: 2009-08-16 09:50:25 +0200 (dim., 16 août 2009) $ par : $Author: tchemit $
 */
package org.nuiton.processor.filters;

public abstract class DefaultFilter implements Filter { // DefaultFilter

    public static int NOT_FOUND = -1;
    protected StringBuffer cachedContent = new StringBuffer();

    public DefaultFilter() {
    }

    /** Type of states */
    protected static class State {

        /** Looking-for-header state */
        public final static State SEARCH_HEADER = new State();
        /** Looking-for-footer state */
        public final static State SEARCH_FOOTER = new State();
    }
    protected State currentState = State.SEARCH_HEADER;

    @Override
    public String parse(String input) {
        int matchingIndex;

        // add new input to current content
        cachedContent.append(input);
        String content = cachedContent.toString();

        if (currentState.equals(State.SEARCH_HEADER)) {
            // Looking for a header
            matchingIndex = getMatchIndexFor(content, getHeader());
            if (matchingIndex != NOT_FOUND) {
                // Header found, return "out" part of it + recursive process of remaining chars
                currentState = State.SEARCH_FOOTER;
                cachedContent.setLength(0);
                return performOutFilter(content.substring(0, matchingIndex)) + parse(content.substring(matchingIndex));
            }
            // No header found !
            return EMPTY_STRING;
        }

        if (currentState.equals(State.SEARCH_FOOTER)) {
            // Looking for a footer
            matchingIndex = getMatchIndexFor(content, getFooter());
            if (matchingIndex != NOT_FOUND) {
                // Footer found, return "in" part of it + recursive process of remaining chars
                currentState = State.SEARCH_HEADER;
                cachedContent.setLength(0);
                int matchingEndIndex = matchingIndex + getMatchLengthFor(getFooter());
                return performInFilter(performHeaderFooterFilter(content.substring(0, matchingEndIndex))) + parse(content.substring(matchingEndIndex));
            }
            // No footer found !
            return EMPTY_STRING;
        }

        return "INVALID STATE in DefaultFilter !";
    }

    public String performHeaderFooterFilter(String ch) {
        return ch.substring(getHeader().length(), ch.length() - getFooter().length());
    }

    public int getMatchIndexFor(String input, String sequence) {
        return input.indexOf(sequence);
    }

    public int getMatchLengthFor(String sequence) {
        return sequence.length();
    }

    @Override
    public boolean hasCachedData() {
        return (cachedContent.length() > 0);
    }

    @Override
    public String flush() {
        String line = cachedContent.toString();
        // Empty the cache,
        cachedContent.setLength(0);
        // and returns its content
        if (currentState.equals(State.SEARCH_HEADER)) {
            return performOutFilter(line);
        }
        return performInFilter(line);
    }

    /**
     * methode appele lorsqu'on a la chaine entiere entre le header et le
     * footer.
     *
     * @param ch
     *            la chaine trouve
     * @return ce qu'il faut ecrire dans le fichier de sortie
     */
    abstract protected String performInFilter(String ch);

    /**
     * methode appele lorsqu'on a la chaine entiere a l'exterieur du
     * header/footer
     *
     * @param ch
     *            la chaine trouve
     * @return ce qu'il faut ecrire dans le fichier de sortie
     */
    abstract protected String performOutFilter(String ch);

    /** @return la chaine du header */
    abstract protected String getHeader();

    /** @return la chaine du footer */
    abstract protected String getFooter();
} // DefaultFilter
