/* *##% nuiton-processor - lib
 * Copyright (C) 2002 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%* */

/* *
 * Processor.java
 *
 * Created: Wed Jan 14 2004
 *
 * @author  <poussin@codelutin.com>
 * Copyright Code Lutin
 * @version $Revision: 255 $
 *
 * Mise a jour: $Date: 2009-08-16 09:50:25 +0200 (dim., 16 août 2009) $
 * par : $Author: tchemit $
 */
package org.nuiton.processor;

import org.nuiton.processor.filters.*;
import org.nuiton.processor.filters.Filter;
import java.io.*;
import java.util.logging.Logger;

/*
 * This class is a generic sources processor
 * Given a reader class name and a writer class name
 */
public class Processor {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Logger log = Logger.getLogger("org.nuiton.processor.Processor");
    protected Filter[] inputFilter = new Filter[]{new NoActionFilter()};
    protected Filter outputFilter = new NoActionFilter();

    public Processor() {
    }

    public Processor(Filter[] filters) {
        setInputFilter(filters);
    }

    public void setInputFilter(Filter inFilter) {
        setInputFilter(new Filter[]{inFilter});
    }

    public void setInputFilter(Filter[] inFilter) {
        inputFilter = inFilter;
    }

    public void setOutputFilter(Filter outFilter) {
        outputFilter = outFilter;
    }

    protected BufferedReader getReader(Reader externalInput) {
        BufferedReader result = new BufferedReader(externalInput);
        for (int i = 0; i < inputFilter.length; i++) {
            result = new ProcessorReader(result, inputFilter[i]);
        }
        return result;
    }

    /** Process all available data
     * @param externalInput
     * @param externalOutput
     * @throws IOException if any pb
     */
    public void process(Reader externalInput, Writer externalOutput) throws IOException {
        log.finest("Debug du process");
        BufferedReader input = getReader(externalInput);
        ProcessorWriter output =
                new ProcessorWriter(new BufferedWriter(externalOutput), outputFilter);

        log.finest("input: " + input);
        log.finest("output: " + output);

        String line = input.readLine();
        while (line != null) {
            log.finest("Ligne lu: " + line);
            output.writeLine(line);
            line = input.readLine();
        }
        output.flush();
    }
}
