/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.nuiton.processor:maven-processor-plugin:1.0.3", 0);
        this.append(sb, "", 0);
        this.append(sb, "Nuiton Processor :: Maven plugin", 0);
        this.append(sb, "Efficient Universal Processor", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "processor:help", 0);
            this.append(sb, "Display help information on maven-processor-plugin.\nCall\n\u00a0\u00a0mvn\u00a0processor:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "process".equals(this.goal)) {
            this.append(sb, "processor:process", 0);
            this.append(sb, "Maven2 plugin for Nuiton Processor.\nCreated: 14 avril 2006\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "destDir (Default: ${basedir}/target/processed-sources/java)", 2);
                this.append(sb, "R\u00e9pertoire cible", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Fichiers \u00e0 exclure.\nIl s'agit des expressions sp\u00e9rar\u00e9es par des virgules.\n\nExemple :\n\n*.java,*.xml\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileInPattern", 2);
                this.append(sb, "???", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileOutPattern", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "filters (Default: org.nuiton.processor.filters.NoActionFilter)", 2);
                this.append(sb, "Les filtres a utiliser par le processor, s\u00e9par\u00e9s par des virgules", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Fichiers \u00e0 inclure.\nIl s'agit des expressions s\u00e9par\u00e9es par des virgules.\n\nExemple :\n\n*.java,*.xml\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "overwrite (Default: false)", 2);
                this.append(sb, "Ecrase les fichiers g\u00e9n\u00e9r\u00e9s", 3);
                this.append(sb, "", 0);
                this.append(sb, "project (Default: ${project})", 2);
                this.append(sb, "Dependance du projet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "srcDir (Default: ${basedir}/src/main/java)", 2);
                this.append(sb, "R\u00e9pertoire source", 3);
                this.append(sb, "", 0);
                this.append(sb, "testPhase (Default: false)", 2);
                this.append(sb, "Pour utiliser en phase de test", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Permet d'obtenir plus d'information", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

