package org.nuiton.db.meta;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcedureMeta}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcedureMeta.builder()}.
 */
@Generated(from = "ProcedureMeta", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableProcedureMeta implements ProcedureMeta {
  private final String name;
  private final ImmutableMap<String, String> args;
  private final @Nullable String comment;

  private ImmutableProcedureMeta(
      String name,
      ImmutableMap<String, String> args,
      @Nullable String comment) {
    this.name = name;
    this.args = args;
    this.comment = comment;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code args} attribute
   */
  @Override
  public ImmutableMap<String, String> getArgs() {
    return args;
  }

  /**
   * @return The value of the {@code comment} attribute
   */
  @Override
  public Optional<String> getComment() {
    return Optional.ofNullable(comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcedureMeta#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcedureMeta withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableProcedureMeta(newValue, this.args, this.comment);
  }

  /**
   * Copy the current immutable object by replacing the {@link ProcedureMeta#getArgs() args} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the args map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcedureMeta withArgs(Map<String, ? extends String> entries) {
    if (this.args == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableProcedureMeta(this.name, newValue, this.comment);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ProcedureMeta#getComment() comment} attribute.
   * @param value The value for comment
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcedureMeta withComment(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "comment");
    if (Objects.equals(this.comment, newValue)) return this;
    return new ImmutableProcedureMeta(this.name, this.args, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ProcedureMeta#getComment() comment} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for comment
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcedureMeta withComment(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.comment, value)) return this;
    return new ImmutableProcedureMeta(this.name, this.args, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcedureMeta} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcedureMeta
        && equalTo((ImmutableProcedureMeta) another);
  }

  private boolean equalTo(ImmutableProcedureMeta another) {
    return name.equals(another.name)
        && args.equals(another.args)
        && Objects.equals(comment, another.comment);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code args}, {@code comment}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + args.hashCode();
    h += (h << 5) + Objects.hashCode(comment);
    return h;
  }

  /**
   * Prints the immutable value {@code ProcedureMeta} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ProcedureMeta")
        .omitNullValues()
        .add("name", name)
        .add("args", args)
        .add("comment", comment)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ProcedureMeta} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcedureMeta instance
   */
  public static ImmutableProcedureMeta copyOf(ProcedureMeta instance) {
    if (instance instanceof ImmutableProcedureMeta) {
      return (ImmutableProcedureMeta) instance;
    }
    return ImmutableProcedureMeta.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcedureMeta ImmutableProcedureMeta}.
   * <pre>
   * ImmutableProcedureMeta.builder()
   *    .name(String) // required {@link ProcedureMeta#getName() name}
   *    .putArgs|putAllArgs(String =&gt; String) // {@link ProcedureMeta#getArgs() args} mappings
   *    .comment(String) // optional {@link ProcedureMeta#getComment() comment}
   *    .build();
   * </pre>
   * @return A new ImmutableProcedureMeta builder
   */
  public static ImmutableProcedureMeta.Builder builder() {
    return new ImmutableProcedureMeta.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcedureMeta ImmutableProcedureMeta}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcedureMeta", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;
    private ImmutableMap.Builder<String, String> args = ImmutableMap.builder();
    private @Nullable String comment;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProcedureMeta} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ProcedureMeta instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      putAllArgs(instance.getArgs());
      Optional<String> commentOptional = instance.getComment();
      if (commentOptional.isPresent()) {
        comment(commentOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProcedureMeta#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Put one entry to the {@link ProcedureMeta#getArgs() args} map.
     * @param key The key in the args map
     * @param value The associated value in the args map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putArgs(String key, String value) {
      this.args.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ProcedureMeta#getArgs() args} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putArgs(Map.Entry<String, ? extends String> entry) {
      this.args.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ProcedureMeta#getArgs() args} map. Nulls are not permitted
     * @param entries The entries that will be added to the args map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder args(Map<String, ? extends String> entries) {
      this.args = ImmutableMap.builder();
      return putAllArgs(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ProcedureMeta#getArgs() args} map. Nulls are not permitted
     * @param entries The entries that will be added to the args map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllArgs(Map<String, ? extends String> entries) {
      this.args.putAll(entries);
      return this;
    }

    /**
     * Initializes the optional value {@link ProcedureMeta#getComment() comment} to comment.
     * @param comment The value for comment
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder comment(String comment) {
      this.comment = Objects.requireNonNull(comment, "comment");
      return this;
    }

    /**
     * Initializes the optional value {@link ProcedureMeta#getComment() comment} to comment.
     * @param comment The value for comment
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder comment(Optional<String> comment) {
      this.comment = comment.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcedureMeta ImmutableProcedureMeta}.
     * @return An immutable instance of ProcedureMeta
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcedureMeta build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProcedureMeta(name, args.build(), comment);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build ProcedureMeta, some of required attributes are not set " + attributes;
    }
  }
}
