/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class SemVer
implements Comparable<SemVer> {
    private static final Log log = LogFactory.getLog(SemVer.class);
    public static final String SERIES_SEPARATOR = ".";
    public static final String PRERELEASE_SEPARATOR = "-";
    public static final String BUILD_SEPARATOR = "+";
    public static final String PATTERN_VERSION = "[0-9]+";
    public static final String PATTERN_PRERELEASE = "[0-9A-Za-z-]+";
    public static final String PATTERN_BUILD = "[0-9A-Za-z-]+";
    public static final String SNAPSHOT_SEPARATOR = "-";
    public static final String SNAPSHOT = "SNAPSHOT";
    static final Pattern PATTERN_ALL = Pattern.compile("([0-9]+(?:" + Pattern.quote(".") + "[0-9]+" + ")*)(" + Pattern.quote("-") + "[0-9A-Za-z-]+" + "(?:" + Pattern.quote(".") + "[0-9A-Za-z-]+" + ")*)?(" + Pattern.quote("+") + "[0-9A-Za-z-]+" + "(?:" + Pattern.quote(".") + "[0-9A-Za-z-]+" + ")*)?");
    protected String version;
    protected String prerelease;
    protected String build;
    protected String snapshot;

    public SemVer(String versionString) {
        Matcher matcher;
        boolean match;
        String v = StringUtils.strip((String)versionString);
        if (StringUtils.endsWithIgnoreCase((CharSequence)v, (CharSequence)"-SNAPSHOT")) {
            this.snapshot = SNAPSHOT;
            v = StringUtils.substringBeforeLast((String)v, (String)"-");
        }
        if (!(match = (matcher = PATTERN_ALL.matcher(v)).matches())) {
            throw new IllegalArgumentException(String.format("Bad version string: '%s'", versionString));
        }
        this.version = matcher.group(1);
        this.prerelease = StringUtils.removeStart((String)matcher.group(2), (String)"-");
        this.build = StringUtils.removeStart((String)matcher.group(3), (String)BUILD_SEPARATOR);
    }

    public boolean before(SemVer o) {
        int result = this.compareTo(o);
        return result < 0;
    }

    public boolean after(SemVer o) {
        int result = this.compareTo(o);
        return result > 0;
    }

    @Override
    public int compareTo(SemVer other) {
        int result = this.compare(this.getVersion(), other.getVersion(), false);
        if (result == 0 && (result = this.compare(this.getPrerelease(), other.getPrerelease(), true)) == 0 && (result = this.compare(this.getBuild(), other.getBuild(), false)) == 0) {
            result = this.compare(this.getSnapshot(), other.getSnapshot(), true);
        }
        return result;
    }

    protected int compare(String a, String b, boolean nullIsHigh) {
        int result = nullIsHigh ? this.nullIsHigh(a, b) : this.nullIsLow(a, b);
        if (result == 0 && a != null && b != null) {
            String[] aSeries = StringUtils.split((String)a, (String)SERIES_SEPARATOR);
            String[] bSeries = StringUtils.split((String)b, (String)SERIES_SEPARATOR);
            int length = Math.max(aSeries.length, bSeries.length);
            int i = 0;
            while (result == 0 & i < length) {
                String va = i < aSeries.length ? aSeries[i] : "";
                String vb = i < bSeries.length ? bSeries[i] : "";
                int pad = Math.max(va.length(), vb.length());
                if (StringUtils.isNumeric((CharSequence)va)) {
                    va = StringUtils.leftPad((String)va, (int)pad);
                }
                if (StringUtils.isNumeric((CharSequence)vb)) {
                    vb = StringUtils.leftPad((String)vb, (int)pad);
                }
                result = va.compareTo(vb);
                ++i;
            }
        }
        return result;
    }

    protected int nullIsHigh(String a, String b) {
        int result = 0;
        if (a == null ^ b == null) {
            result = a == null ? 1 : -1;
        }
        return result;
    }

    protected int nullIsLow(String a, String b) {
        int result = 0;
        if (a == null ^ b == null) {
            result = a == null ? -1 : 1;
        }
        return result;
    }

    protected int getComposantCount(String element) {
        int result = 0;
        if (StringUtils.isNotBlank((CharSequence)element)) {
            result = 1 + StringUtils.countMatches((CharSequence)element, (CharSequence)SERIES_SEPARATOR);
        }
        return result;
    }

    protected String getComposant(String element, int i) {
        Object[] v = StringUtils.split((String)element, (String)SERIES_SEPARATOR);
        Validate.validIndex((Object[])v, (int)i, (String)"Ask '%s', element '%s' don't have enought composant", (Object[])new Object[]{i, element});
        Object s = v[i];
        return s;
    }

    public String getVersion() {
        return this.version;
    }

    public int getVersionCount() {
        int result = this.getComposantCount(this.getVersion());
        return result;
    }

    public String getVersion(int i) {
        String s = this.getComposant(this.getVersion(), i);
        return s;
    }

    public String getMajor() {
        String result = this.getVersion(0);
        return result;
    }

    public String getMinor() {
        String result = this.getVersion(1);
        return result;
    }

    public String getPatch() {
        String result = this.getVersion(2);
        return result;
    }

    public String getPrerelease() {
        return this.prerelease;
    }

    public int getPrereleaseCount() {
        int result = this.getComposantCount(this.getPrerelease());
        return result;
    }

    public String getPrerelease(int i) {
        String s = this.getComposant(this.getPrerelease(), i);
        return s;
    }

    public String getBuild() {
        return this.build;
    }

    public int getBuildCount() {
        int result = this.getComposantCount(this.getBuild());
        return result;
    }

    public String getBuild(int i) {
        String s = this.getComposant(this.getBuild(), i);
        return s;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public boolean isSnapshot() {
        return StringUtils.isNotBlank((CharSequence)this.snapshot);
    }

    protected static String ifNotNull(String prefix, String s) {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)s)) {
            result = prefix + s;
        }
        return result;
    }

    public boolean equals(Object o) {
        boolean result = o instanceof SemVer && this.compareTo((SemVer)o) == 0;
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toJavaIdentifier() {
        String result = this.toString();
        result = result.replaceAll("[-+.]", "_");
        return result;
    }

    public String toString() {
        return this.getVersion() + SemVer.ifNotNull("-", this.getPrerelease()) + SemVer.ifNotNull(BUILD_SEPARATOR, this.getBuild()) + SemVer.ifNotNull("-", this.getSnapshot());
    }

    public SemVerCreator getCreator() {
        return SemVer.creator(this);
    }

    public static boolean isSemVer(String version) {
        if (StringUtils.endsWithIgnoreCase((CharSequence)version, (CharSequence)SNAPSHOT)) {
            version = StringUtils.substringBeforeLast((String)version, (String)SNAPSHOT);
        }
        Matcher matcher = PATTERN_ALL.matcher(version);
        boolean result = matcher.matches();
        return result;
    }

    public static SemVerCreator creator(String ... v) {
        SemVerCreator result = new SemVerCreator();
        if (v != null && v.length > 0) {
            result.setVersion(v[0]);
            if (v.length > 1) {
                result.setPrerelease(v[1]);
                if (v.length > 2) {
                    result.setBuild(v[2]);
                    if (v.length > 3) {
                        if (v[3] == null) {
                            result.setSnapshot(false);
                        } else if (StringUtils.equalsIgnoreCase((CharSequence)SNAPSHOT, (CharSequence)v[3])) {
                            result.setSnapshot(true);
                        } else {
                            throw new IllegalArgumentException(String.format("Illegal SNAPSHOT string '%s'", v[3]));
                        }
                        if (v.length > 4) {
                            throw new IllegalArgumentException(String.format("too many string arguments '%s' maximum 4", v.length));
                        }
                    }
                }
            }
        }
        return result;
    }

    public static SemVerCreator creator(int ... v) {
        SemVerCreator result = SemVer.creator(StringUtils.join((Object[])new Serializable[]{v, SERIES_SEPARATOR}));
        return result;
    }

    public static SemVerCreator creator(SemVer v) {
        SemVerCreator result = SemVer.creator(v.getVersion(), v.getPrerelease(), v.getBuild(), v.getSnapshot());
        return result;
    }

    public static SemVerCreator creator() {
        SemVerCreator result = new SemVerCreator();
        return result;
    }

    public static class SemVerCreator {
        protected String version;
        protected String prerelease;
        protected String build;
        protected String snapshot;

        public SemVerCreator setVersion(Integer ... v) {
            this.version = StringUtils.join((Object[])v, (String)SemVer.SERIES_SEPARATOR);
            return this;
        }

        public SemVerCreator setVersion(String v) {
            this.version = v;
            return this;
        }

        public SemVerCreator setPrerelease(String v) {
            this.prerelease = v;
            return this;
        }

        public SemVerCreator setBuild(String v) {
            this.build = v;
            return this;
        }

        public SemVerCreator setSnapshot(boolean b) {
            this.snapshot = b ? SemVer.SNAPSHOT : null;
            return this;
        }

        public SemVerCreator incVersion(int indice, int inc) {
            Object[] v = StringUtils.split((String)this.version, (String)SemVer.SERIES_SEPARATOR);
            Validate.validIndex((Object[])v, (int)indice, (String)"Version don't have enought composant", (Object[])new Object[0]);
            Object s = v[indice];
            Validate.isTrue((boolean)StringUtils.isNumeric((CharSequence)s), (String)"String '%s' must be numeric", (Object[])new Object[]{s});
            int i = Integer.parseInt((String)s);
            v[indice] = s = String.valueOf(i += inc);
            this.version = StringUtils.join((Object[])v, (String)SemVer.SERIES_SEPARATOR);
            return this;
        }

        public SemVerCreator incMajor() {
            return this.incVersion(0, 1);
        }

        public SemVerCreator incMinor() {
            return this.incVersion(1, 1);
        }

        public SemVerCreator incPatch() {
            return this.incVersion(2, 1);
        }

        public SemVer done() {
            SemVer result = new SemVer(StringUtils.defaultString((String)this.version) + SemVer.ifNotNull("-", this.prerelease) + SemVer.ifNotNull(SemVer.BUILD_SEPARATOR, this.build) + SemVer.ifNotNull("-", this.snapshot));
            return result;
        }
    }
}

