/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.License;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.nuiton.io.SortedProperties;
import org.nuiton.license.plugin.AbstractAddThirdPartyMojo;

public class LicenseMap
extends TreeMap<String, SortedSet<MavenProject>> {
    private static final long serialVersionUID = 864199843545688069L;
    private transient Log log;
    public static final String unknownLicenseMessage = "Unknown license";
    protected static transient Comparator<MavenProject> projectComparator;

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        return this.log;
    }

    public void addLicense(MavenProject project, List<?> licenses) throws ProjectBuildingException {
        if ("system".equals(project.getArtifact().getScope())) {
            return;
        }
        if (CollectionUtils.isEmpty(licenses)) {
            this.put(LicenseMap.getUnknownLicenseMessage(), project);
            return;
        }
        for (Object o : licenses) {
            String id = AbstractAddThirdPartyMojo.getArtifactId(project.getArtifact());
            if (o == null) {
                this.getLog().warn((CharSequence)("could not acquire the license for " + id));
                continue;
            }
            License license = (License)o;
            String licenseKey = license.getName();
            if (StringUtils.isEmpty((String)license.getName())) {
                this.getLog().warn((CharSequence)("No license name defined for " + id));
                licenseKey = license.getUrl();
            }
            if (StringUtils.isEmpty((String)licenseKey)) {
                this.getLog().warn((CharSequence)("No license url defined for " + id));
                licenseKey = LicenseMap.getUnknownLicenseMessage();
            }
            this.put(licenseKey, project);
        }
    }

    public SortedSet<MavenProject> getUnsafeDependencies() {
        Log log = this.getLog();
        SortedSet unsafeDependencies = (SortedSet)this.get(LicenseMap.getUnknownLicenseMessage());
        if (log.isDebugEnabled()) {
            if (CollectionUtils.isEmpty((Collection)unsafeDependencies)) {
                log.debug((CharSequence)"There is no dependency with no license from poms.");
            } else {
                log.debug((CharSequence)("There is " + unsafeDependencies.size() + " dependencies with no license from poms : "));
                for (MavenProject dep : unsafeDependencies) {
                    log.debug((CharSequence)(" - " + AbstractAddThirdPartyMojo.getArtifactId(dep.getArtifact())));
                }
            }
        }
        return unsafeDependencies;
    }

    protected SortedProperties loadUnsafeMapping(String encoding, File missingFile) throws IOException, ProjectBuildingException {
        String id;
        SortedSet<MavenProject> unsafeDependencies = this.getUnsafeDependencies();
        SortedProperties unsafeMappings = new SortedProperties(encoding);
        if (missingFile.exists()) {
            this.getLog().info((CharSequence)("Load missing file " + missingFile));
            unsafeMappings.load(missingFile);
        }
        for (Object o : unsafeMappings.keySet()) {
            id = (String)o;
            MavenProject project = (MavenProject)AbstractAddThirdPartyMojo.getArtifactCache().get(id);
            if (project == null) {
                this.getLog().warn((CharSequence)("dependency [" + id + "] does not exists in project."));
                continue;
            }
            String license = (String)unsafeMappings.get((Object)id);
            if (StringUtils.isEmpty((String)license)) continue;
            License l = new License();
            l.setName(license.trim());
            l.setUrl(license.trim());
            this.addLicense(project, Arrays.asList(l));
            unsafeDependencies.remove(project);
        }
        if (unsafeDependencies.isEmpty()) {
            this.remove(LicenseMap.getUnknownLicenseMessage());
        } else {
            for (MavenProject project : unsafeDependencies) {
                id = AbstractAddThirdPartyMojo.getArtifactId(project.getArtifact());
                unsafeMappings.setProperty(id, "");
            }
        }
        return unsafeMappings;
    }

    @Override
    public SortedSet<MavenProject> put(String key, MavenProject value) {
        TreeSet<MavenProject> valueList = (TreeSet<MavenProject>)this.get(key);
        if (valueList == null) {
            valueList = new TreeSet<MavenProject>(LicenseMap.getProjectComparator());
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("key:" + key + ",value: " + value));
        }
        valueList.add(value);
        return this.put(key, valueList);
    }

    public SortedMap<MavenProject, String[]> toDependencyMap() {
        TreeMap<MavenProject, HashSet<String>> tmp = new TreeMap<MavenProject, HashSet<String>>(LicenseMap.getProjectComparator());
        for (Map.Entry entry : this.entrySet()) {
            String license = (String)entry.getKey();
            SortedSet set = (SortedSet)entry.getValue();
            for (MavenProject p : set) {
                HashSet<String> list = (HashSet<String>)tmp.get(p);
                if (list == null) {
                    list = new HashSet<String>();
                    tmp.put(p, list);
                }
                list.add(license);
            }
        }
        TreeMap<MavenProject, String[]> result = new TreeMap<MavenProject, String[]>(LicenseMap.getProjectComparator());
        for (Map.Entry entry : tmp.entrySet()) {
            ArrayList value = new ArrayList((Collection)entry.getValue());
            Collections.sort(value);
            result.put((MavenProject)entry.getKey(), value.toArray(new String[value.size()]));
        }
        tmp.clear();
        return result;
    }

    public static String getUnknownLicenseMessage() {
        return unknownLicenseMessage;
    }

    public static Comparator<MavenProject> getProjectComparator() {
        if (projectComparator == null) {
            projectComparator = new Comparator<MavenProject>(){

                @Override
                public int compare(MavenProject o1, MavenProject o2) {
                    String id1 = AbstractAddThirdPartyMojo.getArtifactId(o1.getArtifact());
                    String id2 = AbstractAddThirdPartyMojo.getArtifactId(o2.getArtifact());
                    return id1.compareTo(id2);
                }
            };
        }
        return projectComparator;
    }

    public void mergeLicenses(String ... licenses) {
        if (licenses.length == 0) {
            return;
        }
        String mainLicense = licenses[0].trim();
        TreeSet<MavenProject> mainSet = (TreeSet<MavenProject>)this.get(mainLicense);
        if (mainSet == null) {
            this.getLog().warn((CharSequence)("No license [" + mainLicense + "] found, will create it."));
            mainSet = new TreeSet<MavenProject>(LicenseMap.getProjectComparator());
            this.put(mainLicense, mainSet);
        }
        int size = licenses.length;
        for (int i = 1; i < size; ++i) {
            String license = licenses[i].trim();
            SortedSet set = (SortedSet)this.get(license);
            if (set == null) {
                this.getLog().warn((CharSequence)("No license [" + license + "] found, skip this merge."));
                continue;
            }
            this.getLog().info((CharSequence)("Merge license [" + license + "] (" + set.size() + " depedencies)."));
            mainSet.addAll(set);
            set.clear();
            this.remove(license);
        }
    }
}

