/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.nuiton.io.SortedProperties;
import org.nuiton.license.plugin.AbstractAddThirdPartyMojo;
import org.nuiton.license.plugin.LicenseMap;
import org.nuiton.plugin.Plugin;

public class AggregatorAddThirdPartyMojo
extends AbstractAddThirdPartyMojo {
    protected List<?> reactorProjects;

    protected boolean checkPackaging() {
        return this.acceptPackaging(new Plugin.Packaging[]{Plugin.Packaging.pom});
    }

    protected boolean checkSkip() {
        if (!this.isDoGenerate() && !this.isDoGenerateBundle()) {
            this.getLog().info((CharSequence)"All files are up to date, skip goal execution.");
            return false;
        }
        return super.checkSkip();
    }

    @Override
    protected LicenseMap createLicenseMap() throws ProjectBuildingException {
        Log log = this.getLog();
        LicenseMap licenseMap = new LicenseMap();
        licenseMap.setLog(log);
        SortedMap<String, MavenProject> artifacts = AggregatorAddThirdPartyMojo.getArtifactCache();
        for (MavenProject project : artifacts.values()) {
            licenseMap.addLicense(project, project.getLicenses());
        }
        return licenseMap;
    }

    @Override
    protected SortedProperties createUnsafeMapping() throws ProjectBuildingException, IOException {
        String path = this.getMissingFile().getAbsolutePath().substring(this.getProject().getBasedir().getAbsolutePath().length() + 1);
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Use missing file path : " + path));
        }
        SortedProperties unsafeMappings = new SortedProperties(this.getEncoding());
        LicenseMap licenseMap = this.getLicenseMap();
        for (Object o : this.reactorProjects) {
            SortedSet<MavenProject> unsafes;
            MavenProject p = (MavenProject)o;
            File file = new File(p.getBasedir(), path);
            if (file.exists()) {
                SortedProperties tmp = licenseMap.loadUnsafeMapping(this.getEncoding(), file);
                unsafeMappings.putAll((Map)tmp);
            }
            if (!CollectionUtils.isEmpty(unsafes = licenseMap.getUnsafeDependencies())) continue;
            break;
        }
        return unsafeMappings;
    }

    protected void doAction() throws Exception {
        Log log = this.getLog();
        if (this.isVerbose()) {
            log.info((CharSequence)("After executing on " + this.reactorProjects.size() + " project(s)"));
        }
        SortedMap<String, MavenProject> artifacts = AggregatorAddThirdPartyMojo.getArtifactCache();
        LicenseMap licenseMap = this.getLicenseMap();
        this.getLog().info((CharSequence)(artifacts.size() + " detected artifact(s)."));
        if (this.isVerbose()) {
            for (String id : artifacts.keySet()) {
                this.getLog().info((CharSequence)(" - " + id));
            }
        }
        this.getLog().info((CharSequence)(licenseMap.size() + " detected license(s)."));
        if (this.isVerbose()) {
            for (String id : licenseMap.keySet()) {
                this.getLog().info((CharSequence)(" - " + id));
            }
        }
        boolean unsafe = this.checkUnsafeDependencies();
        this.writeThirdPartyFile();
        if (unsafe && this.isFailIfWarning()) {
            throw new MojoFailureException("There is some dependencies with no license, please review the modules.");
        }
    }
}

