/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin.header.transformer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuiton.license.plugin.header.FileHeader;
import org.nuiton.license.plugin.header.transformer.FileHeaderTransformer;

public abstract class AbstractFileHeaderTransformer
implements FileHeaderTransformer {
    protected static final Pattern COPYRIGHT_PATTERN = Pattern.compile("(.[^\\d]+)?\\s(\\d{4})?(\\s+-\\s+(\\d{4})?){0,1}\\s+(.+)?");
    protected String name;
    protected String description;
    protected String sectionDelimiter = "%%";
    protected String processStartTag = "#%L";
    protected String processEndTag = "#L%";
    protected String commentStartTag;
    protected String commentEndTag;
    protected String commentLinePrefix;

    protected AbstractFileHeaderTransformer(String name, String description, String commentStartTag, String commentEndTag, String commentLinePrefix) {
        this.name = name;
        this.description = description;
        if (commentStartTag.equals(commentLinePrefix)) {
            throw new IllegalStateException("commentStartTag can not be equals to commentPrefixLine, but was [" + commentStartTag + "]");
        }
        if (commentEndTag.equals(commentLinePrefix)) {
            throw new IllegalStateException("commentEndTag can not be equals to commentPrefixLine, but was [" + commentStartTag + "]");
        }
        this.commentStartTag = commentStartTag;
        this.commentEndTag = commentEndTag;
        this.commentLinePrefix = commentLinePrefix;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getSectionDelimiter() {
        return this.sectionDelimiter;
    }

    @Override
    public void setSectionDelimiter(String sectionDelimiter) {
        this.sectionDelimiter = sectionDelimiter;
    }

    @Override
    public String getProcessStartTag() {
        return this.processStartTag;
    }

    @Override
    public void setProcessStartTag(String processStartTag) {
        this.processStartTag = processStartTag;
    }

    @Override
    public String getProcessEndTag() {
        return this.processEndTag;
    }

    @Override
    public void setProcessEndTag(String processEndTag) {
        this.processEndTag = processEndTag;
    }

    @Override
    public String getCommentStartTag() {
        return this.commentStartTag;
    }

    @Override
    public void setCommentStartTag(String commentStartTag) {
        this.commentStartTag = commentStartTag;
    }

    @Override
    public String getCommentEndTag() {
        return this.commentEndTag;
    }

    @Override
    public void setCommentEndTag(String commentEndTag) {
        this.commentEndTag = commentEndTag;
    }

    @Override
    public String getCommentLinePrefix() {
        return this.commentLinePrefix;
    }

    @Override
    public String addHeader(String header, String content) {
        return header + content;
    }

    @Override
    public void setCommentLinePrefix(String commentLinePrefix) {
        this.commentLinePrefix = commentLinePrefix;
    }

    @Override
    public FileHeader toFileHeader(String header) {
        FileHeader model = new FileHeader();
        String[] sections = header.split(this.getSectionDelimiter());
        if (sections.length != 3) {
            throw new IllegalStateException("could not find 3 sections in\n" + header);
        }
        String description = sections[0].trim();
        model.setDescription(description);
        String copyright = sections[1].trim();
        Matcher matcher = COPYRIGHT_PATTERN.matcher(copyright);
        if (!matcher.matches()) {
            throw new IllegalStateException("copyright [" + copyright + "] is not valid");
        }
        String firstYear = matcher.group(2);
        String lastYear = matcher.group(4);
        String holder = matcher.group(5);
        model.setCopyrightFirstYear(Integer.valueOf(firstYear.trim()));
        if (lastYear != null) {
            model.setCopyrightLastYear(Integer.valueOf(lastYear.trim()));
        }
        model.setCopyrightHolder(holder.trim());
        String license = sections[2].trim();
        model.setLicense(license);
        return model;
    }

    @Override
    public String toString(FileHeader model) throws NullPointerException {
        if (model == null) {
            throw new NullPointerException("model can not be null!");
        }
        StringBuilder buffer = new StringBuilder();
        String sectionDelimiter = '\n' + this.getSectionDelimiter() + '\n';
        buffer.append(model.getDescription().trim());
        buffer.append(sectionDelimiter);
        buffer.append(model.getCopyright().trim());
        buffer.append(sectionDelimiter);
        buffer.append(model.getLicense().trim()).append('\n');
        return buffer.toString();
    }

    @Override
    public String boxComment(String header, boolean withTags) {
        StringBuilder buffer = new StringBuilder();
        if (withTags) {
            buffer.append(this.getCommentStartTag()).append('\n');
        }
        for (String line : header.split("\n")) {
            buffer.append(this.getCommentLinePrefix());
            buffer.append(line);
            buffer.append('\n');
        }
        if (withTags) {
            buffer.append(this.getCommentEndTag()).append('\n');
        }
        return buffer.toString();
    }

    @Override
    public String unboxComent(String header) {
        StringBuilder buffer = new StringBuilder();
        int prefixLength = this.getCommentLinePrefix().length();
        for (String line : header.split("\n")) {
            if (line.isEmpty() || line.contains(this.getCommentStartTag()) || line.contains(this.getCommentEndTag())) continue;
            int index = line.indexOf(this.getCommentLinePrefix());
            if (index > -1) {
                line = line.substring(index + prefixLength);
            }
            buffer.append(line).append('\n');
        }
        return buffer.toString();
    }

    @Override
    public String boxProcessTag(String header) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getProcessStartTag()).append('\n');
        buffer.append(header.trim()).append('\n');
        buffer.append(this.getProcessEndTag()).append('\n');
        return buffer.toString();
    }

    @Override
    public String unboxProcessTag(String boxedHeader) {
        StringBuilder buffer = new StringBuilder();
        for (String line : boxedHeader.split("\n")) {
            if (line.isEmpty() || line.contains(this.getProcessStartTag()) || line.contains(this.getProcessEndTag())) continue;
            buffer.append(line).append('\n');
        }
        return buffer.toString();
    }
}

